/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import mchorse.mappet.utils.Utils;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.io.FileUtils;

public class NBTToJsonLike {
    public static String toJson(NBTBase base) {
        return NBTToJsonLike.toJson(base, new StringBuilder(), "").toString();
    }

    public static StringBuilder toJson(NBTBase base, StringBuilder builder, String indent) {
        if (base instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)base;
            builder.append("[\n");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                builder.append(indent);
                builder.append("    ");
                NBTToJsonLike.toJson(list.func_179238_g(i), builder, indent + "    ");
                if (i < list.func_74745_c() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(indent);
            builder.append("]");
        } else if (base instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)base;
            builder.append("{\n");
            int i = 0;
            for (String key : tag.func_150296_c()) {
                builder.append(indent);
                builder.append("    \"");
                builder.append(key);
                builder.append("\": ");
                NBTToJsonLike.toJson(tag.func_74781_a(key), builder, indent + "    ");
                if (i < tag.func_186856_d() - 1) {
                    builder.append(",");
                }
                builder.append("\n");
                ++i;
            }
            builder.append(indent);
            builder.append("}");
        } else {
            builder.append(base.toString());
        }
        return builder;
    }

    public static NBTTagCompound fromJson(String json) {
        try {
            return JsonToNBT.func_180713_a((String)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void write(File file, NBTTagCompound tag) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)NBTToJsonLike.toJson((NBTBase)tag), (Charset)Utils.getCharset());
    }

    public static NBTTagCompound read(File file) throws IOException {
        String json = FileUtils.readFileToString((File)file, (Charset)Utils.getCharset());
        return NBTToJsonLike.fromJson(json);
    }
}

