/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.tile;

import java.util.ArrayList;
import java.util.Iterator;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.blocks.BlockEmitter;
import mchorse.mappet.network.common.blocks.PacketEditEmitter;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEmitter
extends TileEntity
implements ITickable {
    private Checker checker = new Checker();
    private float radius;
    private int update = 5;
    private boolean disable;
    private int tick = 0;

    public Checker getChecker() {
        return this.checker;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getUpdate() {
        return this.update;
    }

    public boolean getDisable() {
        return this.disable;
    }

    public void setExpression(PacketEditEmitter message) {
        this.checker.deserializeNBT((NBTBase)message.checker);
        this.radius = message.radius;
        this.update = Math.max(message.update, 1);
        this.disable = message.disable;
        this.updateExpression();
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick % this.update == 0 && !this.checker.isEmpty()) {
            this.updateExpression();
        }
        ++this.tick;
    }

    private void updateExpression() {
        boolean result;
        ArrayList<EntityPlayer> playersInside = new ArrayList<EntityPlayer>();
        if (this.radius > 0.0f) {
            BlockPos pos = this.func_174877_v();
            boolean playerIn = false;
            for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                if (!(player.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5) <= (double)this.radius)) continue;
                playerIn = true;
                playersInside.add(player);
                break;
            }
            if (!playerIn) {
                if (this.disable) {
                    this.updateState(false);
                }
                return;
            }
        }
        if (!(result = this.checker.check(new DataContext(this.field_145850_b, this.func_174877_v())))) {
            EntityPlayer player;
            Iterator iterator = playersInside.iterator();
            while (iterator.hasNext() && !(result = this.checker.check(new DataContext((Entity)(player = (EntityPlayer)iterator.next()))))) {
            }
        }
        this.updateState(result);
    }

    private void updateState(boolean result) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)state.func_177229_b((IProperty)BlockEmitter.POWERED) != result) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockEmitter.POWERED, (Comparable)Boolean.valueOf(result)));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("Checker", this.checker.serializeNBT());
        if (this.radius > 0.0f) {
            tag.func_74776_a("Radius", this.radius);
        }
        if (this.update > 0) {
            tag.func_74768_a("Update", this.update);
        }
        if (this.disable) {
            tag.func_74757_a("Disable", this.disable);
        }
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Checker")) {
            this.checker.deserializeNBT(tag.func_74781_a("Checker"));
        }
        if (tag.func_74764_b("Radius")) {
            this.radius = tag.func_74760_g("Radius");
        }
        if (tag.func_74764_b("Update")) {
            this.update = tag.func_74762_e("Update");
        }
        if (tag.func_74764_b("Disable")) {
            this.disable = tag.func_74767_n("Disable");
        }
    }
}

