/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.network.server.quests;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.dialogues.DialogueContext;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.chains.QuestStatus;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.network.common.quests.PacketQuestAction;
import mchorse.mclib.network.ServerMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ServerHandlerQuestAction
extends ServerMessageHandler<PacketQuestAction> {
    public void run(EntityPlayerMP player, PacketQuestAction message) {
        Quest quest;
        Character character = Character.get((EntityPlayer)player);
        if (message.status == QuestStatus.AVAILABLE) {
            Quest quest2 = (Quest)Mappet.quests.load(message.id);
            if (quest2 != null) {
                character.getQuests().add(quest2, (EntityPlayer)player);
            }
        } else if (message.status == QuestStatus.COMPLETED) {
            Quest quest3 = character.getQuests().getByName(message.id);
            if (quest3 != null && quest3.isComplete((EntityPlayer)player)) {
                character.getQuests().complete(message.id, (EntityPlayer)player);
                DialogueContext context = character.getDialogueContext();
                if (context.questChain != null) {
                    Mappet.dialogues.handleContext(player, character.getDialogue(), context, null);
                }
            }
        } else if (message.status == QuestStatus.CANCELED && (quest = character.getQuests().getByName(message.id)) != null && quest.cancelable) {
            character.getQuests().remove(message.id, (EntityPlayer)player, false);
        }
    }
}

