/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.network.common.factions;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.factions.Faction;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketFactions
implements IMessage {
    public Map<String, Faction> factions = new HashMap<String, Faction>();
    public Map<String, Double> states = new HashMap<String, Double>();

    public PacketFactions() {
    }

    public PacketFactions(Map<String, Faction> factions, Map<String, Double> states) {
        this.factions.putAll(factions);
        this.states.putAll(states);
    }

    public void fromBytes(ByteBuf buf) {
        String key;
        int i;
        int c = buf.readInt();
        for (i = 0; i < c; ++i) {
            NBTTagCompound tag;
            key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Faction faction = (Faction)Mappet.factions.create(key, tag = NBTUtils.readInfiniteTag((ByteBuf)buf));
            if (faction == null) continue;
            this.factions.put(key, faction);
        }
        c = buf.readInt();
        for (i = 0; i < c; ++i) {
            key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            double value = buf.readDouble();
            this.states.put(key, value);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.factions.size());
        for (Map.Entry<String, Faction> entry : this.factions.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)entry.getValue().serializeNBT());
        }
        buf.writeInt(this.states.size());
        for (Map.Entry<String, Object> entry : this.states.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeDouble(((Double)entry.getValue()).doubleValue());
        }
    }
}

