/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.npc.PacketNpcList;
import mchorse.mappet.network.common.npc.PacketNpcState;
import mchorse.mclib.utils.OpHelper;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNpcTool
extends Item {
    public ItemNpcTool() {
        this.func_77637_a(Mappet.creativeTab);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.mappet.npc_tool.tooltip", (Object[])new Object[0]));
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && target instanceof EntityNpc) {
            if (((Boolean)Mappet.npcsToolOnlyOP.get()).booleanValue() && !OpHelper.isPlayerOp((EntityPlayerMP)((EntityPlayerMP)player))) {
                return super.func_111207_a(stack, player, target, hand);
            }
            if (((Boolean)Mappet.npcsToolOnlyCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
                return super.func_111207_a(stack, player, target, hand);
            }
            EntityNpc npc = (EntityNpc)target;
            if (player.func_70093_af()) {
                npc.func_70106_y();
            } else {
                Dispatcher.sendTo(new PacketNpcState(target.func_145782_y(), npc.getState().serializeNBT()), (EntityPlayerMP)player);
            }
            return true;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)Mappet.npcsToolOnlyOP.get()).booleanValue() && !OpHelper.isPlayerOp((EntityPlayerMP)((EntityPlayerMP)playerIn))) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            if (((Boolean)Mappet.npcsToolOnlyCreative.get()).booleanValue() && !playerIn.field_71075_bZ.field_75098_d) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            if (this.openNpcTool(playerIn, playerIn.func_184586_b(handIn))) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private boolean openNpcTool(EntityPlayer player, ItemStack stack) {
        Collection<String> npcs = Mappet.npcs.getKeys();
        if (!npcs.isEmpty() && player instanceof EntityPlayerMP) {
            ArrayList<String> states = new ArrayList<String>();
            try {
                NBTTagCompound tag = stack.func_77978_p();
                Npc npc = (Npc)Mappet.npcs.load(tag.func_74779_i("Npc"));
                states.addAll(npc.states.keySet());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Dispatcher.sendTo(new PacketNpcList(npcs, states), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            if (((Boolean)Mappet.npcsToolOnlyOP.get()).booleanValue() && !OpHelper.isPlayerOp((EntityPlayerMP)((EntityPlayerMP)player))) {
                return EnumActionResult.PASS;
            }
            if (((Boolean)Mappet.npcsToolOnlyCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
                return EnumActionResult.PASS;
            }
            EntityNpc entity = new EntityNpc(worldIn);
            BlockPos posOffset = pos.func_177972_a(facing);
            entity.func_70107_b((float)posOffset.func_177958_n() + hitX, (float)posOffset.func_177956_o() + hitY, (float)posOffset.func_177952_p() + hitZ);
            this.setupState(entity, stack);
            entity.field_70170_p.func_72838_d((Entity)entity);
            entity.initialize();
            if (!player.func_70093_af()) {
                Dispatcher.sendTo(new PacketNpcState(entity.func_145782_y(), entity.getState().serializeNBT()), (EntityPlayerMP)player);
            }
        }
        return stack.func_77973_b() == Mappet.npcTool ? EnumActionResult.SUCCESS : super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    private void setupState(EntityNpc entity, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            NpcState state;
            String npcId = tag.func_74779_i("Npc");
            String stateId = tag.func_74779_i("State");
            Npc npc = (Npc)Mappet.npcs.load(npcId);
            NpcState npcState = state = npc == null ? null : npc.states.get(stateId);
            if (npc != null && state == null && npc.states.containsKey("default")) {
                state = npc.states.get("default");
            }
            if (state != null) {
                entity.setNpc(npc, state);
                if (!npc.serializeNBT().func_74779_i("StateName").equals("default")) {
                    entity.setStringInData("StateName", stateId);
                }
            }
        } else {
            AbstractMorph morph;
            tag = new NBTTagCompound();
            tag.func_74778_a("Name", "blockbuster.fred");
            entity.getState().morph = morph = MorphManager.INSTANCE.morphFromNBT(tag);
            entity.setMorph(morph);
        }
    }
}

