/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.entities;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.factions.Faction;
import mchorse.mappet.api.factions.FactionAttitude;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcDrop;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.entities.CommandNpc;
import mchorse.mappet.entities.ai.EntityAIAlwaysWander;
import mchorse.mappet.entities.ai.EntityAIAttackNpcMelee;
import mchorse.mappet.entities.ai.EntityAIFollowTarget;
import mchorse.mappet.entities.ai.EntityAIHurtByTargetNpc;
import mchorse.mappet.entities.ai.EntityAIPatrol;
import mchorse.mappet.entities.ai.EntityAIReturnToPost;
import mchorse.mappet.entities.ai.fly.EntityAINpcFly;
import mchorse.mappet.entities.ai.fly.FlyingMoveHelper;
import mchorse.mappet.entities.utils.MappetNpcRespawnManager;
import mchorse.mappet.entities.utils.NpcDamageSource;
import mchorse.mappet.items.ItemNpcTool;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.npc.PacketNpcStateChange;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mclib.utils.Interpolations;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNpc
extends EntityCreature
implements IEntityAdditionalSpawnData,
IMorphProvider {
    public static final int RENDER_DISTANCE = 160;
    private Morph morph = new Morph();
    private NpcState state = new NpcState();
    private int lastDamageTime;
    private boolean unkillableFailsafe = true;
    private Faction faction;
    private EntityAIHurtByTargetNpc targetAI;
    public float smoothYawHead;
    public float prevSmoothYawHead;
    public float smoothBodyYawHead;
    public float prevSmoothBodyYawHead;
    private Entity lastTarget;
    public boolean dieOnLoad = false;

    public EntityNpc(World worldIn) {
        super(worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3125);
    }

    public void func_70108_f(Entity entityIn) {
        if (!((Boolean)this.state.immovable.get()).booleanValue()) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!((Boolean)this.state.immovable.get()).booleanValue()) {
            super.func_82167_n(entityIn);
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.state.triggerEntityCollision.trigger(new DataContext((Entity)this, entityIn));
    }

    public boolean func_189652_ae() {
        return (Boolean)this.state.hasNoGravity.get();
    }

    public boolean func_98052_bS() {
        return (Boolean)this.state.canPickUpLoot.get();
    }

    public boolean func_82171_bF() {
        return (Boolean)this.state.canBeSteered.get();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int index = this.func_184188_bt().indexOf(passenger);
            BlockPos offsetPos = this.state.steeringOffset.isEmpty() || index >= this.state.steeringOffset.size() ? new BlockPos(0, 0, 0) : this.state.steeringOffset.get(index);
            double offsetX = offsetPos.func_177958_n();
            double offsetY = this.field_70163_u - 0.5 + (double)EntityUtils.getHeight((Entity)this) + (double)offsetPos.func_177956_o();
            double offsetZ = offsetPos.func_177952_p();
            double bodyYaw = Math.toRadians(this.field_70761_aq);
            double rotatedOffsetX = offsetX * Math.cos(bodyYaw) - offsetZ * Math.sin(bodyYaw);
            double rotatedOffsetZ = offsetX * Math.sin(bodyYaw) + offsetZ * Math.cos(bodyYaw);
            double finalPosX = this.field_70165_t + rotatedOffsetX;
            double finalPosZ = this.field_70161_v + rotatedOffsetZ;
            passenger.func_70107_b(finalPosX, offsetY, finalPosZ);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                passenger.func_180426_a(finalPosX, offsetY, finalPosZ, passenger.field_70177_z, passenger.field_70125_A, 3, true);
            } else {
                passenger.func_70107_b(finalPosX, offsetY, finalPosZ);
                this.field_70177_z = passenger.field_70177_z;
                this.field_70125_A = passenger.field_70125_A;
            }
            this.field_70177_z = passenger.field_70177_z;
            this.field_70125_A = passenger.field_70125_A;
        }
        if (passenger instanceof EntityPlayer && this.func_82171_bF() && this.func_184188_bt().indexOf(passenger) == this.func_184188_bt().size() - 1) {
            this.handleSteering((EntityPlayer)passenger);
        }
    }

    private void handleSteering(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            float forward = player.field_191988_bg;
            float strafe = player.field_70702_br;
            this.field_70177_z = player.field_70177_z;
            this.field_70759_as = player.field_70759_as;
            if (forward != 0.0f || strafe != 0.0f) {
                float baseSpeed;
                float speed = baseSpeed = ((Float)this.state.speed.get()).floatValue() / 15.0f;
                double motionX = -Math.sin(Math.toRadians(this.field_70177_z)) * (double)forward + Math.cos(Math.toRadians(this.field_70177_z)) * (double)strafe;
                double motionZ = Math.cos(Math.toRadians(this.field_70177_z)) * (double)forward + Math.sin(Math.toRadians(this.field_70177_z)) * (double)strafe;
                double motionMagnitude = Math.sqrt(motionX * motionX + motionZ * motionZ);
                this.field_70159_w = (motionX /= motionMagnitude) * (double)speed;
                this.field_70179_y = (motionZ /= motionMagnitude) * (double)speed;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.func_184207_aI()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected PathNavigate func_175447_b(World world) {
        if (this.state != null && ((Boolean)this.state.canFly.get()).booleanValue()) {
            return new PathNavigateFlying((EntityLiving)this, world);
        }
        return new PathNavigateGround((EntityLiving)this, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        double speed = 1.0;
        if (this.state != null) {
            speed = ((Float)this.state.speed.get()).floatValue();
            if (((Boolean)this.state.canSwim.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            }
            if (!((String)this.state.follow.get()).isEmpty()) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowTarget(this, speed, 2.0f, 10.0f));
            } else if (((Boolean)this.state.hasPost.get()).booleanValue() && this.state.postPosition != null) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIReturnToPost(this, this.state.postPosition, speed, ((Float)this.state.postRadius.get()).floatValue()));
            } else if (!this.state.patrol.isEmpty()) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPatrol(this, speed));
            }
            if (((Boolean)this.state.lookAround.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            }
            if (((Boolean)this.state.lookAtPlayer.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, ((Float)this.state.pathDistance.get()).floatValue(), 1.0f));
            }
            if (((Boolean)this.state.wander.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, speed / 2.0));
            }
            if (((Boolean)this.state.canFly.get()).booleanValue()) {
                this.field_70765_h = new FlyingMoveHelper(this);
                this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAINpcFly(this));
            } else if (((Boolean)this.state.alwaysWander.get()).booleanValue()) {
                this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIAlwaysWander(this, speed / 2.0));
            }
        }
        this.targetAI = new EntityAIHurtByTargetNpc(this, false, new Class[0]);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.targetAI);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, this::targetCheck));
        if (this.state != null) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackNpcMelee(this, speed, false, (Integer)this.state.damageDelay.get()));
        }
    }

    private boolean targetCheck(EntityLivingBase entity) {
        if (this.isEntityOutOfPostDistance((Entity)entity)) {
            return false;
        }
        Faction faction = this.getFaction();
        if (entity instanceof EntityNpc) {
            EntityNpc npc = (EntityNpc)entity;
            if (faction != null) {
                return faction.get((String)npc.getState().faction.get()) == FactionAttitude.AGGRESSIVE;
            }
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (player.func_175149_v() || player.func_184812_l_()) {
                return false;
            }
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)entity);
            if (attitude != null) {
                return attitude == FactionAttitude.AGGRESSIVE;
            }
        }
        return faction != null && faction.othersAttitude == FactionAttitude.AGGRESSIVE;
    }

    private FactionAttitude getPlayerAttitude(Faction faction, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Character character = Character.get((EntityPlayer)player);
            if (faction != null && character != null) {
                return faction.get(character.getStates());
            }
        }
        return null;
    }

    public void initialize() {
        this.state.triggerInitialize.trigger((EntityLivingBase)this);
    }

    public States getStates() {
        return this.state.states;
    }

    public Faction getFaction() {
        if (this.faction == null) {
            String faction = (String)this.state.faction.get();
            this.faction = faction.isEmpty() ? null : (Faction)Mappet.factions.load(faction);
        }
        return this.faction;
    }

    public void setNpc(Npc npc, NpcState state) {
        this.setState(state, false);
        if (((String)this.state.id.get()).isEmpty()) {
            this.state.id.set((Object)npc.getId());
        }
    }

    public String getId() {
        return (String)this.state.id.get();
    }

    public NpcState getState() {
        return this.state;
    }

    public void setState(NpcState state, boolean notify) {
        notify = true;
        this.state = new NpcState();
        this.state.deserializeNBT(state.serializeNBT());
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)((Float)this.state.pathDistance.get()).floatValue());
        this.field_70699_by = this.func_175447_b(this.field_70170_p);
        double max = this.func_110138_aP();
        double health = this.func_110143_aJ();
        this.setMaxHealth(((Float)state.maxHealth.get()).floatValue());
        this.func_70606_j((float)MathHelper.func_151237_a((double)((double)((Float)state.maxHealth.get()).floatValue() * (health / max)), (double)1.0, (double)((Float)state.maxHealth.get()).floatValue()));
        this.field_70178_ae = (Boolean)this.state.canGetBurned.get() == false;
        this.field_70728_aV = (Integer)this.state.xp.get();
        this.morph.set(state.morph);
        if (notify) {
            this.sendNpcStateChangePacket();
        }
        this.faction = null;
        this.func_184651_r();
    }

    public void sendNpcStateChangePacket() {
        if (this.field_70170_p instanceof WorldServer) {
            Dispatcher.sendToTracked((Entity)this, new PacketNpcStateChange(this));
        }
    }

    public AbstractMorph getMorph() {
        return this.morph.get();
    }

    public EntityLivingBase getFollowTarget() {
        if (((String)this.state.follow.get()).isEmpty()) {
            return null;
        }
        if (this.state.follow.equals((Object)"@r")) {
            List players = this.field_70170_p.field_73010_i;
            int index = MathHelper.func_76125_a((int)((int)(Math.random() * (double)players.size() - 1.0)), (int)0, (int)(players.size() - 1));
            return players.isEmpty() ? null : (EntityLivingBase)players.get(index);
        }
        if (((String)this.state.follow.get()).startsWith("@")) {
            try {
                ICommandSender sender = CommandNpc.getCommandSender(this);
                List entities = EntitySelector.func_179656_b((ICommandSender)sender, (String)((String)this.state.follow.get()), Entity.class);
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    return (EntityLivingBase)entity;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                EntityPlayer player = this.field_70170_p.func_72924_a((String)this.state.follow.get());
                return player == null ? this.field_70170_p.func_152378_a(UUID.fromString((String)this.state.follow.get())) : player;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setMorph(AbstractMorph morph) {
        this.morph.set(morph);
        this.state.morph = morph;
    }

    public void setMaxHealth(double value) {
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(value);
    }

    public void func_70071_h_() {
        if (this.lastTarget != this.func_70638_az()) {
            this.lastTarget = this.func_70638_az();
            this.state.triggerTarget.trigger(new DataContext((Entity)this, this.lastTarget));
        }
        this.healthFailsafe();
        this.updateAttackTarget();
        super.func_70071_h_();
        this.func_82168_bl();
        if (!this.morph.isEmpty()) {
            this.morph.get().update((EntityLivingBase)this);
        }
        if ((Integer)this.state.regenDelay.get() > 0 && !this.field_70170_p.field_72995_K) {
            int regen;
            int n = regen = (Integer)this.state.regenFrequency.get() == 0 ? 1 : (Integer)this.state.regenFrequency.get();
            if (this.lastDamageTime >= (Integer)this.state.regenDelay.get() && this.field_70173_aa % regen == 0 && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
            }
            ++this.lastDamageTime;
        }
        if (this.field_70170_p.field_72995_K) {
            this.prevSmoothYawHead = this.smoothYawHead;
            this.smoothYawHead = Interpolations.lerpYaw((float)this.smoothYawHead, (float)this.field_70759_as, (float)0.5f);
            this.prevSmoothBodyYawHead = this.smoothBodyYawHead;
            this.smoothBodyYawHead = Interpolations.lerpYaw((float)this.smoothBodyYawHead, (float)this.field_70761_aq, (float)0.5f);
        } else {
            this.state.triggerTick.trigger((EntityLivingBase)this);
        }
    }

    private boolean isEntityOutOfPostDistance(Entity entity) {
        if (this.state == null || this.state.postPosition == null || !((Boolean)this.state.hasPost.get()).booleanValue()) {
            return false;
        }
        BlockPos post = this.state.postPosition;
        BlockPos position = entity.func_180425_c();
        double distance = post.func_177951_i((Vec3i)position);
        return distance > (double)(((Float)this.state.fallback.get()).floatValue() * ((Float)this.state.fallback.get()).floatValue());
    }

    private void updateAttackTarget() {
        if (this.state != null && this.func_70638_az() != null && this.state.postPosition != null && ((Boolean)this.state.hasPost.get()).booleanValue() && this.isEntityOutOfPostDistance((Entity)this.func_70638_az())) {
            this.targetAI.reset = true;
            this.func_70624_b(null);
        }
        if (this.faction == null || this.field_70173_aa % 10 != 0) {
            return;
        }
        EntityLivingBase entity = this.func_70638_az();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Faction faction = this.getFaction();
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)player);
            if (attitude == FactionAttitude.FRIENDLY || player.func_184812_l_()) {
                this.func_70624_b(null);
            }
        }
    }

    protected void func_70609_aI() {
        if (((Boolean)this.state.killable.get()).booleanValue() || !this.unkillableFailsafe) {
            super.func_70609_aI();
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        for (NpcDrop drop : this.state.drops) {
            if (!(this.field_70146_Z.nextFloat() < drop.chance)) continue;
            this.func_70099_a(drop.stack.func_77946_l(), 0.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        NpcDamageSource source = (Boolean)Mappet.npcsPeacefulDamage.get() != false ? new NpcDamageSource((Entity)this) : DamageSource.func_76358_a((EntityLivingBase)this);
        entityIn.func_70097_a((DamageSource)source, ((Float)this.state.damage.get()).floatValue());
        return super.func_70652_k(entityIn);
    }

    protected void func_70665_d(DamageSource damage, float damageAmount) {
        super.func_70665_d(damage, damageAmount);
        if (!this.func_180431_b(damage)) {
            this.lastDamageTime = 0;
        }
        this.healthFailsafe();
        this.state.triggerDamaged.trigger((EntityLivingBase)this);
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Faction faction = this.getFaction();
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)player);
            if (attitude == FactionAttitude.FRIENDLY && !player.func_184812_l_()) {
                return true;
            }
        }
        if (((Boolean)this.state.invincible.get()).booleanValue()) {
            return !source.func_180136_u() && source != DamageSource.field_76380_i;
        }
        if (!((Boolean)this.state.canFallDamage.get()).booleanValue() && source == DamageSource.field_76379_h) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public void func_174812_G() {
        this.unkillableFailsafe = false;
        super.func_174812_G();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (((Boolean)this.state.respawn.get()).booleanValue() && !this.dieOnLoad) {
            MappetNpcRespawnManager respawnManager = MappetNpcRespawnManager.get(this.field_70170_p);
            respawnManager.addDiedNpc(this);
            this.dieOnLoad = true;
        }
        this.state.triggerDied.trigger((EntityLivingBase)this, cause.func_76346_g());
    }

    protected boolean func_70692_ba() {
        return (Boolean)this.state.unique.get();
    }

    public void healthFailsafe() {
        if (!((Boolean)this.state.killable.get()).booleanValue() && this.func_110143_aJ() <= 0.0f && this.unkillableFailsafe) {
            this.func_70606_j(0.001f);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (!player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
                this.state.triggerInteract.trigger(new DataContext((Entity)this, (Entity)player));
            }
            if ((this.func_184188_bt().size() < this.state.steeringOffset.size() || this.state.steeringOffset.isEmpty()) && this.func_82171_bF() && !(player.func_184586_b(hand).func_77973_b() instanceof ItemNpcTool)) {
                player.func_184205_a((Entity)this, true);
            }
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74757_a("DieOnLoad", this.dieOnLoad);
        if (!this.dieOnLoad) {
            super.func_70014_b(tag);
            tag.func_74782_a("State", (NBTBase)this.state.serializeNBT());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NpcState state = new NpcState();
        state.deserializeNBT(tag.func_74775_l("State"));
        if (tag.func_74764_b("States")) {
            state.states.deserializeNBT(tag.func_74775_l("States"));
        }
        this.setState(state, false);
        if (tag.func_74764_b("NpcId")) {
            state.id.set((Object)tag.func_74779_i("NpcId"));
        }
        if (tag.func_74764_b("DieOnLoad") && tag.func_74767_n("DieOnLoad")) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph.get());
        this.state.writeToBuf(buf);
    }

    public void readSpawnData(ByteBuf buf) {
        this.morph.setDirect(MorphUtils.morphFromBuf((ByteBuf)buf));
        this.state.readFromBuf(buf);
        this.field_70758_at = this.field_70759_as;
        this.smoothYawHead = this.field_70759_as;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 160.0) * d0;
    }

    public void setStringInData(String key, String value) {
        ScriptNBTCompound fullData = new ScriptNBTCompound(this.func_189511_e(new NBTTagCompound()));
        fullData.getCompound("State").setString(key, value);
        this.func_70020_e(fullData.getNBTTagCompound());
    }
}

