/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.commands.crafting;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingRecipe;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.commands.crafting.CommandCraftingBase;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class CommandCraftingDrop
extends CommandCraftingBase {
    public String func_71517_b() {
        return "drop";
    }

    public String func_71518_a(ICommandSender sender) {
        return "mappet.commands.mp.crafting.drop";
    }

    public String getSyntax() {
        return "{l}{6}/{r}mp {8}crafting drop{r} {7}<id> [index] [x] [y] [z] [mx] [my] [mz]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 1;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String id = args[0];
        CraftingTable table = this.getCraftingTable(id);
        if (table.recipes.isEmpty()) {
            throw new CommandException("crafting.empty", new Object[]{id});
        }
        int index = (int)Math.min(Math.round(Math.random() * (double)table.recipes.size()), (long)(table.recipes.size() - 1));
        if (args.length > 1 && !args[1].equals("@r")) {
            index = CommandBase.func_175764_a((String)args[1], (int)0, (int)(table.recipes.size() - 1));
        }
        Vec3d pos = sender.func_174791_d();
        double x = args.length > 2 ? CommandBase.func_175761_b((double)pos.field_72450_a, (String)args[2], (boolean)false) : pos.field_72450_a;
        double y = args.length > 3 ? CommandBase.func_175761_b((double)pos.field_72448_b, (String)args[3], (boolean)false) : pos.field_72448_b;
        double z = args.length > 4 ? CommandBase.func_175761_b((double)pos.field_72449_c, (String)args[4], (boolean)false) : pos.field_72449_c;
        CraftingRecipe recipe = table.recipes.get(index);
        for (ItemStack stack : recipe.output) {
            if (stack != null && !stack.func_190926_b()) continue;
            throw new CommandException("crafting.empty_output", new Object[]{id, index});
        }
        double mx = args.length > 5 ? CommandBase.func_175765_c((String)args[5]) : 0.0;
        double my = args.length > 6 ? CommandBase.func_175765_c((String)args[6]) : 0.0;
        double mz = args.length > 7 ? CommandBase.func_175765_c((String)args[7]) : 0.0;
        for (int i = 0; i < recipe.output.size(); ++i) {
            ItemStack stack = (ItemStack)recipe.output.get(i);
            EntityItem item = new EntityItem(sender.func_130014_f_(), x, y, z, stack.func_77946_l());
            item.field_70159_w = mx;
            item.field_70181_x = my;
            item.field_70179_y = mz;
            if (i > 0) {
                item.field_70159_w += (Math.random() - 0.5) * 0.1;
                item.field_70181_x += (Math.random() - 0.5) * 0.1;
                item.field_70179_y += (Math.random() - 0.5) * 0.1;
            }
            sender.func_130014_f_().func_72838_d((Entity)item);
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandCraftingDrop.func_175762_a((String[])args, Mappet.crafting.getKeys());
        }
        if (args.length == 2) {
            return CommandCraftingDrop.func_71530_a((String[])args, (String[])new String[]{"@r"});
        }
        return Collections.emptyList();
    }
}

