/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.renders.tile;

import java.util.List;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.tileentity.TileEntityModelSettings;
import mchorse.mappet.client.gui.panels.GuiConditionModelPanel;
import mchorse.mappet.tile.TileConditionModel;
import mchorse.mclib.client.Draw;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.RenderingUtils;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileConditionModelRenderer
extends TileEntitySpecialRenderer<TileConditionModel> {
    public RenderShadow renderer;

    public void render(TileConditionModel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)Blockbuster.modelBlockDisableRendering.get()).booleanValue()) {
            this.renderModel(te, x, y, z, partialTicks, destroyStage, alpha);
        }
        if (mc.field_71474_y.field_74330_P && (!mc.field_71474_y.field_74319_N || ((Boolean)Blockbuster.modelBlockRenderDebuginf1.get()).booleanValue())) {
            this.renderDebug(te, x, y, z);
        }
    }

    public void renderModel(TileConditionModel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        AbstractMorph newMorph;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.renderer == null) {
            this.renderer = new RenderShadow(mc.func_175598_ae());
        }
        TileEntityModelSettings teSettings = te.getSettings();
        EntityActor entity = te.entity;
        if (entity == null) {
            te.createEntity((World)mc.field_71441_e);
            entity = te.entity;
        }
        if ((newMorph = EntityUtils.getMorph((EntityLivingBase)entity)) == null) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        entity.func_70080_a((double)((float)pos.func_177958_n() + 0.5f + teSettings.getX()), (double)((float)pos.func_177956_o() + teSettings.getY()), (double)((float)pos.func_177952_p() + 0.5f + teSettings.getZ()), 0.0f, 0.0f);
        entity.func_70012_b((double)((float)pos.func_177958_n() + 0.5f + teSettings.getX()), (double)((float)pos.func_177956_o() + teSettings.getY()), (double)((float)pos.func_177952_p() + 0.5f + teSettings.getZ()), 0.0f, 0.0f);
        entity.field_70759_as = entity.field_70758_at;
        entity.field_70126_B = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = entity.field_70127_C;
        entity.field_70761_aq = entity.field_70760_ar;
        entity.func_70016_h(0.0, 0.0, 0.0);
        float xx = (float)x + 0.5f + teSettings.getX();
        float yy = (float)y + teSettings.getY();
        float zz = (float)z + 0.5f + teSettings.getZ();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xx, (float)yy, (float)zz);
        boolean wasSet = MatrixUtils.captureMatrix();
        this.transform(te);
        MorphUtils.render((AbstractMorph)newMorph, (EntityLivingBase)entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
        this.drawAxis(te);
        GlStateManager.func_179121_F();
        if (te.isShadow) {
            this.renderer.setShadowSize(newMorph.getWidth((EntityLivingBase)entity) * 0.8f);
            this.renderer.func_76979_b((Entity)te.entity, xx, yy, zz, 0.0f, partialTicks);
        }
        if (wasSet) {
            MatrixUtils.releaseMatrix();
        }
    }

    public void renderDebug(TileConditionModel te, double x, double y, double z) {
        TileEntityModelSettings teSettings = te.getSettings();
        int shader = GL11.glGetInteger((int)35725);
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)0);
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float xx = 0.0f;
        float yy = 1.0f;
        float zz = 0.5f;
        if (te.entity != null && !te.entity.morph.isEmpty() && te.entity.morph.get().errorRendering) {
            xx = 1.0f;
            zz = 0.0f;
            yy = 0.0f;
        }
        Draw.cube((BufferBuilder)buffer, (double)(x + 0.25), (double)(y + 0.25), (double)(z + 0.25), (double)(x + 0.75), (double)(y + 0.75), (double)(z + 0.75), (float)xx, (float)yy, (float)zz, (float)0.35f);
        Draw.cube((BufferBuilder)buffer, (double)(x + (double)0.45f + (double)teSettings.getX()), (double)(y + (double)teSettings.getY()), (double)(z + (double)0.45f + (double)teSettings.getZ()), (double)(x + (double)0.55f + (double)teSettings.getX()), (double)(y + (double)0.1f + (double)teSettings.getY()), (double)(z + (double)0.55f + (double)teSettings.getZ()), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        double distance = MathHelper.func_76133_a((double)Vec3d.field_186680_a.func_186679_c((double)teSettings.getX(), (double)teSettings.getY(), (double)teSettings.getZ()));
        if (distance > 0.1) {
            Draw.cube((BufferBuilder)buffer, (double)(x + (double)0.45f), (double)y, (double)(z + (double)0.45f), (double)(x + (double)0.55f), (double)(y + (double)0.1f), (double)(z + (double)0.55f), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
            tessellator.func_78381_a();
            double horizontalDistance = MathHelper.func_76129_c((float)(teSettings.getX() * teSettings.getX() + teSettings.getZ() * teSettings.getZ()));
            double yaw = 180.0 - MathHelper.func_181159_b((double)teSettings.getZ(), (double)teSettings.getX()) * 180.0 / Math.PI + 90.0;
            double pitch = MathHelper.func_181159_b((double)teSettings.getY(), (double)horizontalDistance) * 180.0 / Math.PI;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + (double)0.05f), (double)(z + 0.5));
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
            Draw.cube((double)-0.025f, (double)-0.025f, (double)0.0, (double)0.025f, (double)0.025f, (double)(-distance), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glPopMatrix();
        } else {
            tessellator.func_78381_a();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)shader);
        }
    }

    public boolean isGlobalRenderer(TileConditionModel te) {
        return te.isGlobal;
    }

    private void drawAxis(TileConditionModel te) {
        GuiConditionModelPanel modelBlockPanel;
        List childList = GuiBase.getCurrentChildren(GuiConditionModelPanel.class);
        if (childList != null && (modelBlockPanel = (GuiConditionModelPanel)((Object)childList.get(0))) != null && modelBlockPanel.isOpened() && modelBlockPanel.isSelected(te)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179090_x();
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
            Draw.point((double)0.0, (double)0.0, (double)0.0);
            if (GuiTransformations.GuiStaticTransformOrientation.getOrientation() == GuiTransformations.TransformOrientation.GLOBAL) {
                TileEntityModelSettings teSettings = te.getSettings();
                Vector3d rotation = new Vector3d(Math.toRadians(teSettings.getRx()), Math.toRadians(teSettings.getRy()), Math.toRadians(teSettings.getRz()));
                Vector3d scale = new Vector3d((double)teSettings.getSx(), (double)teSettings.getSy(), (double)teSettings.getSz());
                RenderingUtils.glRevertRotationScale((Vector3d)rotation, (Vector3d)scale, (MatrixUtils.RotationOrder)teSettings.getOrder());
            }
            Draw.axis((float)0.25f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public void transform(TileConditionModel te) {
        TileEntityModelSettings teSettings = te.getSettings();
        if (teSettings.getOrder() == MatrixUtils.RotationOrder.ZYX) {
            GlStateManager.func_179114_b((float)teSettings.getRx(), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)teSettings.getRy(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)teSettings.getRz(), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179114_b((float)teSettings.getRz(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)teSettings.getRy(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)teSettings.getRx(), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (teSettings.isUniform()) {
            GlStateManager.func_179152_a((float)teSettings.getSx(), (float)teSettings.getSx(), (float)teSettings.getSx());
        } else {
            GlStateManager.func_179152_a((float)teSettings.getSx(), (float)teSettings.getSy(), (float)teSettings.getSz());
        }
    }

    public static class RenderShadow
    extends Render<Entity> {
        protected RenderShadow(RenderManager renderManager) {
            super(renderManager);
        }

        protected ResourceLocation func_110775_a(Entity entity) {
            return null;
        }

        public void setShadowSize(float size) {
            this.field_76989_e = size;
            this.field_76987_f = 0.8f;
        }
    }
}

