/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils.text;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import mchorse.mappet.Mappet;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mappet.client.gui.utils.text.TextLine;
import mchorse.mappet.client.gui.utils.text.undo.TextEditUndo;
import mchorse.mappet.client.gui.utils.text.utils.Cursor;
import mchorse.mappet.client.gui.utils.text.utils.StringGroup;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.undo.IUndo;
import mchorse.mclib.utils.undo.UndoManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.SoundEvent;
import org.lwjgl.input.Keyboard;

public class GuiMultiTextElement<T extends TextLine>
extends GuiElement
implements IFocusedGuiElement,
ITextColoring {
    public ScrollArea horizontal = new ScrollArea();
    public ScrollArea vertical = new ScrollArea();
    public Consumer<String> callback;
    private boolean background;
    protected int padding = 10;
    protected int lineHeight = 12;
    protected int textColor = 0xFFFFFF;
    protected boolean textShadow;
    protected boolean wrapping;
    private boolean focused;
    private int dragging;
    protected List<T> text = new ArrayList<T>();
    public final Cursor cursor = new Cursor();
    public final Cursor selection = new Cursor(-1, 0);
    private int lastMX;
    private int lastMY;
    private long lastClick;
    private long update;
    private long lastUpdate;
    private StringGroup lastGroup;
    private UndoManager<GuiMultiTextElement> undo;
    private int lastW;

    public static List<String> splitNewlineString(String string) {
        ArrayList<String> splits = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int c = string.length();
        for (int i = 0; i < c; ++i) {
            char character = string.charAt(i);
            if (character == '\n') {
                splits.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(character);
        }
        splits.add(builder.toString());
        return splits;
    }

    public GuiMultiTextElement(Minecraft mc, Consumer<String> callback) {
        super(mc);
        this.callback = callback;
        this.horizontal.direction = ScrollDirection.HORIZONTAL;
        this.horizontal.cancelScrollEdge = true;
        this.horizontal.scrollSpeed = this.lineHeight * 2;
        this.vertical.cancelScrollEdge = true;
        this.vertical.scrollSpeed = this.lineHeight * 2;
        this.clear();
    }

    public GuiMultiTextElement<T> background() {
        return this.background(true);
    }

    public GuiMultiTextElement<T> background(boolean background) {
        this.background = background;
        return this;
    }

    public GuiMultiTextElement<T> padding(int padding) {
        this.padding = padding;
        return this;
    }

    public GuiMultiTextElement<T> lineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public GuiMultiTextElement<T> wrap() {
        return this.wrap(!this.wrapping);
    }

    public GuiMultiTextElement<T> wrap(boolean wrapping) {
        this.wrapping = wrapping;
        return this;
    }

    public void setColor(int textColor, boolean textShadow) {
        this.textColor = textColor;
        this.textShadow = textShadow;
    }

    public void setText(String text) {
        this.text.clear();
        for (String line : text.split("\n")) {
            this.text.add(this.createTextLine(line));
        }
        this.cursor.set(0, 0);
        this.selection.set(-1, 0);
        this.horizontal.scroll = 0;
        this.vertical.scroll = 0;
        this.undo = new UndoManager(100).simpleMerge();
        if (this.area.w > 0) {
            this.recalculateWrapping();
            this.recalculateSizes();
        }
    }

    protected T createTextLine(String line) {
        return (T)new TextLine(line);
    }

    public String getText() {
        return this.text.stream().map(t -> t.text).collect(Collectors.joining("\n"));
    }

    public List<T> getLines() {
        return this.text;
    }

    public int getWrappedWidth() {
        return this.area.w - this.padding * 3 - this.getShiftX();
    }

    public boolean isSelected() {
        return !this.selection.isEmpty();
    }

    public void startSelecting() {
        this.selection.copy(this.cursor);
    }

    public void deselect() {
        this.selection.set(-1, 0);
    }

    public void swapSelection() {
        if (this.isSelected()) {
            Cursor temp = new Cursor();
            temp.copy(this.selection);
            this.selection.copy(this.cursor);
            this.cursor.copy(temp);
        }
    }

    public void selectAll() {
        this.cursor.set(0, 0);
        this.startSelecting();
        this.cursor.line = this.text.size() - 1;
        this.moveCursorToLineEnd();
    }

    public String getSelectedText() {
        if (!this.isSelected()) {
            return "";
        }
        return this.getText(this.cursor, this.selection);
    }

    public String getText(Cursor a, Cursor b) {
        StringJoiner joiner = new StringJoiner("\n");
        Cursor min = a.isThisLessTo(b) ? a : b;
        Cursor max = a.isThisLessTo(b) ? b : a;
        for (int i = min.line; i <= Math.min(max.line, this.text.size() - 1); ++i) {
            String line = ((TextLine)this.text.get((int)i)).text;
            if (i == min.line && i == max.line) {
                joiner.add(line.substring(min.getOffset(line), max.getOffset(line)));
                continue;
            }
            if (i == min.line) {
                joiner.add(min.end(line));
                continue;
            }
            if (i == max.line) {
                joiner.add(max.start(line));
                continue;
            }
            joiner.add(line);
        }
        return joiner.toString();
    }

    public boolean selectGroup(int direction, boolean select) {
        List<Cursor> groups = this.findGroup(direction, this.cursor);
        if (groups.isEmpty()) {
            return false;
        }
        Cursor min = groups.get(0);
        Cursor max = groups.get(1);
        if (select) {
            if (direction == 0) {
                this.cursor.offset = max.offset;
                this.selection.set(this.cursor.line, min.offset);
            } else {
                if (!this.isSelected()) {
                    this.selection.copy(this.cursor);
                }
                this.cursor.offset = direction < 0 ? min.offset : max.offset;
            }
        } else {
            this.deselect();
            this.cursor.offset = direction < 0 ? min.offset : max.offset;
        }
        return true;
    }

    public int measureGroup(int direction, Cursor cursor) {
        if (direction == 0) {
            return 0;
        }
        List<Cursor> group = this.findGroup(direction, cursor);
        if (group.isEmpty()) {
            return 0;
        }
        Cursor other = group.get(direction < 0 ? 0 : 1);
        return other.offset - cursor.offset;
    }

    public List<Cursor> findGroup(int direction, Cursor cursor) {
        int min;
        String line = ((TextLine)this.text.get((int)cursor.line)).text;
        if (line.isEmpty() || this.cursor.offset >= line.length() - 1) {
            return Collections.emptyList();
        }
        int offset = cursor.offset;
        int first = direction < 0 && offset > 0 ? offset - 1 : offset;
        String character = String.valueOf(line.charAt(first));
        StringGroup group = StringGroup.get(character);
        int max = offset;
        this.lastGroup = null;
        if (direction <= 0) {
            for (min = offset; min > 0 && this.matchSelectGroup(group, String.valueOf(line.charAt(min - 1))); --min) {
            }
        }
        this.lastGroup = null;
        if (direction >= 0) {
            while (max < line.length() && this.matchSelectGroup(group, String.valueOf(line.charAt(max)))) {
                ++max;
            }
        }
        return ImmutableList.of((Object)new Cursor(cursor.line, min), (Object)new Cursor(cursor.line, max));
    }

    private boolean matchSelectGroup(StringGroup group, String character) {
        if (group.match(character)) {
            return this.lastGroup == null;
        }
        if (group == StringGroup.SPACE) {
            if (this.lastGroup == null) {
                this.lastGroup = StringGroup.get(character);
            }
            return StringGroup.get(character) == this.lastGroup;
        }
        return false;
    }

    public boolean selectTextful(String text, boolean reverse) {
        this.deselect();
        List<String> splits = GuiMultiTextElement.splitNewlineString(text);
        this.selection.copy(this.cursor);
        for (int i = 0; i < splits.size(); ++i) {
            String line = ((TextLine)this.text.get((int)this.selection.line)).text;
            int l = splits.get(reverse ? splits.size() - (i + 1) : i).length();
            this.selection.offset = this.selection.offset + (reverse ? -l : l);
            if (i >= splits.size() - 1) continue;
            if (reverse && this.selection.offset < 0) {
                return false;
            }
            if (!reverse && this.selection.offset + l < line.length()) {
                return false;
            }
            this.selection.line = this.selection.line + (reverse ? -1 : 1);
            this.selection.offset = reverse ? ((TextLine)this.text.get((int)this.selection.line)).text.length() : 0;
        }
        return true;
    }

    public void checkSelection(boolean selecting) {
        if (selecting && !this.isSelected()) {
            this.startSelecting();
        } else if (!selecting && this.isSelected()) {
            this.deselect();
        }
    }

    public void clear() {
        this.setText("");
    }

    protected void changedLine(int i) {
        this.calculateWrappedLine((TextLine)this.text.get(i));
        this.recalculateSizes();
    }

    protected void changedLineAfter(int i) {
        while (i < this.text.size()) {
            this.calculateWrappedLine((TextLine)this.text.get(i));
            ++i;
        }
        this.recalculateSizes();
    }

    public void writeNewLine() {
        if (!this.hasLine(this.cursor.line)) {
            return;
        }
        String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
        if (this.cursor.offset == 0 || line.isEmpty()) {
            this.text.add(this.cursor.line, this.createTextLine(""));
        } else if (this.cursor.offset >= line.length()) {
            this.text.add(this.cursor.line + 1, this.createTextLine(""));
        } else {
            ((TextLine)this.text.get(this.cursor.line)).set(this.cursor.start(line));
            this.text.add(this.cursor.line + 1, this.createTextLine(this.cursor.end(line)));
            this.moveCursorToLineStart();
        }
        this.changedLineAfter(this.cursor.line);
        ++this.cursor.line;
        this.cursor.offset = 0;
    }

    public void writeCharacter(String character) {
        if (this.hasLine(this.cursor.line)) {
            int index = this.cursor.offset;
            String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
            line = index >= line.length() ? line + character : (index == 0 ? character + line : this.cursor.start(line) + character + this.cursor.end(line));
            ((TextLine)this.text.get(this.cursor.line)).set(line);
            this.changedLine(this.cursor.line);
        }
    }

    public void writeString(String string) {
        List<String> splits = GuiMultiTextElement.splitNewlineString(string);
        int size = splits.size();
        if (size == 1) {
            this.writeCharacter(string);
            this.cursor.offset += string.length();
        } else {
            int line = this.cursor.line;
            String remainder = this.cursor.end(((TextLine)this.text.get((int)line)).text);
            ((TextLine)this.text.get(line)).set(this.cursor.start(((TextLine)this.text.get((int)line)).text));
            for (int i = 0; i < size; ++i) {
                if (i != 0 && i <= size - 1) {
                    ++this.cursor.line;
                    this.moveCursorToLineStart();
                    this.text.add(this.cursor.line, this.createTextLine(""));
                }
                this.writeCharacter(splits.get(i));
            }
            this.cursor.offset = splits.get(size - 1).length();
            this.writeCharacter(remainder);
            this.changedLineAfter(line);
        }
    }

    public void pasteText(String text) {
        TextEditUndo undo = new TextEditUndo(this);
        this.deleteSelection();
        this.writeString(text);
        undo.ready().post(text, this.cursor, this.selection);
        this.undo.pushUndo((IUndo)undo);
    }

    public String deleteCharacter() {
        if (this.hasLine(this.cursor.line)) {
            String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
            int index = Math.min(this.cursor.offset, line.length());
            if (line.isEmpty()) {
                if (this.cursor.line > 0) {
                    this.text.remove(this.cursor.line);
                    --this.cursor.line;
                    this.moveCursorToLineEnd();
                    this.changedLineAfter(this.cursor.line);
                    return "\n";
                }
            } else {
                if (index >= line.length()) {
                    String deleted = line.substring(line.length() - 1);
                    line = line.substring(0, line.length() - 1);
                    ((TextLine)this.text.get(this.cursor.line)).set(line);
                    this.moveCursorToLineEnd();
                    this.changedLine(this.cursor.line);
                    return deleted;
                }
                if (index == 0) {
                    if (this.cursor.line > 0) {
                        String text = ((TextLine)this.text.remove((int)this.cursor.line)).text;
                        --this.cursor.line;
                        this.moveCursorToLineEnd();
                        ((TextLine)this.text.get((int)this.cursor.line)).text = ((TextLine)this.text.get((int)this.cursor.line)).text + text;
                        this.changedLineAfter(this.cursor.line);
                        return "\n";
                    }
                } else {
                    String deleted = line.substring(this.cursor.getOffset(line, -1), this.cursor.getOffset(line));
                    ((TextLine)this.text.get((int)this.cursor.line)).text = line = this.cursor.start(line, -1) + this.cursor.end(line);
                    this.moveCursor(-1, 0);
                    this.changedLine(this.cursor.line);
                    return deleted;
                }
            }
        }
        return "";
    }

    public void deleteSelection() {
        if (!this.isSelected()) {
            return;
        }
        Cursor min = this.getMin();
        Cursor max = this.getMax();
        if (min.line == max.line) {
            String line = ((TextLine)this.text.get((int)min.line)).text;
            if (min.offset <= 0 && max.offset >= line.length()) {
                ((TextLine)this.text.get(min.line)).set("");
            } else {
                ((TextLine)this.text.get(min.line)).set(min.start(line) + max.end(line));
            }
        } else {
            String end = "";
            for (int i = max.line; i >= min.line; --i) {
                String line = ((TextLine)this.text.get((int)i)).text;
                if (i == max.line) {
                    end = max.end(line);
                    this.text.remove(i);
                    continue;
                }
                if (i == min.line) {
                    ((TextLine)this.text.get(i)).set(min.start(line) + end);
                    continue;
                }
                this.text.remove(i);
            }
        }
        this.changedLineAfter(min.line);
        this.cursor.copy(min);
        this.deselect();
    }

    public boolean hasLine(int line) {
        return line >= 0 && line < this.text.size();
    }

    public Cursor getMin() {
        return this.selection.isThisLessTo(this.cursor) ? this.selection : this.cursor;
    }

    public Cursor getMax() {
        return this.selection.isThisLessTo(this.cursor) ? this.cursor : this.selection;
    }

    public void moveCursor(int x, int y) {
        this.moveCursor(x, y, true);
    }

    public void moveCursor(int x, int y, boolean jumpLine) {
        int ny;
        if (!this.hasLine(this.cursor.line)) {
            return;
        }
        String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
        if (x != 0) {
            int nx = this.cursor.offset + (x > 0 ? 1 : -1);
            if (nx < 0) {
                if (jumpLine) {
                    if (this.hasLine(this.cursor.line - 1)) {
                        --this.cursor.line;
                        this.moveCursorToLineEnd();
                    }
                } else {
                    this.moveCursorToLineStart();
                }
            } else if (nx > line.length()) {
                if (jumpLine) {
                    if (this.hasLine(this.cursor.line + 1)) {
                        ++this.cursor.line;
                        this.moveCursorToLineStart();
                    }
                } else {
                    this.moveCursorToLineEnd();
                }
            } else {
                this.cursor.offset = nx;
            }
        }
        if (y != 0 && this.hasLine(ny = this.cursor.line + (y > 0 ? 1 : -1))) {
            this.cursor.line = ny;
            this.cursor.offset = MathUtils.clamp((int)this.cursor.offset, (int)0, (int)((TextLine)this.text.get((int)this.cursor.line)).text.length());
        }
    }

    public void moveCursorToLineStart() {
        this.cursor.offset = 0;
    }

    public void moveCursorToLineEnd() {
        if (this.hasLine(this.cursor.line)) {
            this.cursor.offset = ((TextLine)this.text.get((int)this.cursor.line)).text.length();
        }
    }

    public void moveCursorTo(Cursor cursor, int x, int y) {
        x -= this.area.x + this.padding;
        y -= this.area.y + this.padding;
        x += this.horizontal.scroll - this.getShiftX();
        y += this.vertical.scroll;
        if (this.wrapping) {
            this.moveToCursorWrapped(cursor, x, y);
        } else {
            this.moveCursorToUnwrapped(cursor, x, y);
        }
    }

    private void moveToCursorWrapped(Cursor cursor, int x, int y) {
        if (this.text.isEmpty()) {
            return;
        }
        TextLine current = null;
        int line = y < 0 ? 0 : y / this.lineHeight;
        int l = 0;
        int s = 0;
        int c = this.text.size();
        for (int i = 0; i < c; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            if (line >= l && line < l + textLine.getLines()) {
                current = textLine;
                cursor.line = i;
                s = line - l;
                break;
            }
            l += textLine.getLines();
        }
        if (current == null) {
            current = (TextLine)this.text.get(this.text.size() - 1);
            cursor.line = this.text.size() - 1;
            s = current.getLines() - 1;
        }
        cursor.offset = 0;
        String lineText = current.text;
        if (current.wrappedLines != null) {
            for (int i = 0; i < s; ++i) {
                cursor.offset += current.wrappedLines.get(i).length();
            }
            lineText = current.wrappedLines.get(s);
        }
        int w = 0;
        if (x > this.font.func_78256_a(lineText)) {
            cursor.offset += lineText.length();
            return;
        }
        if (x < 0) {
            return;
        }
        int i = 0;
        while (x > w) {
            w = this.font.func_78256_a(lineText.substring(0, i));
            ++cursor.offset;
            ++i;
        }
        if (cursor.offset > 0) {
            cursor.offset -= 2;
        }
    }

    private void moveCursorToUnwrapped(Cursor cursor, int x, int y) {
        cursor.line = MathUtils.clamp((int)(y / this.lineHeight), (int)0, (int)(this.text.size() - 1));
        String line = ((TextLine)this.text.get((int)cursor.line)).text;
        int w = this.font.func_78256_a(line);
        if (x <= 0) {
            this.moveCursorToLineStart();
        } else if (x > w) {
            this.moveCursorToLineEnd();
        } else {
            cursor.offset = 0;
            w = this.font.func_78256_a(cursor.start(line));
            while (x > w) {
                w = this.font.func_78256_a(cursor.start(line, 1));
                ++cursor.offset;
            }
            if (cursor.offset > 0) {
                --cursor.offset;
            }
        }
    }

    public void moveViewportToCursor() {
        if (!this.hasLine(this.cursor.line)) {
            return;
        }
        Vector2d pos = this.getCursorPosition(this.cursor);
        pos.x += (double)this.horizontal.scroll;
        pos.y += (double)this.vertical.scroll;
        int w = 4;
        int h = this.lineHeight;
        this.horizontal.scrollIntoView((int)pos.x, w + this.padding * 2, this.getShiftX());
        this.vertical.scrollIntoView((int)pos.y, h + this.padding * 2, this.getShiftX());
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void focus(GuiContext context) {
        this.focused = true;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void unfocus(GuiContext context) {
        this.focused = false;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void selectAll(GuiContext context) {
        this.selectAll();
    }

    public void unselect(GuiContext context) {
        this.deselect();
    }

    public void resize() {
        super.resize();
        if (this.lastW != this.area.w) {
            this.lastW = this.area.w;
            this.recalculateWrapping();
        }
        this.recalculateSizes();
        this.horizontal.clamp();
        this.vertical.clamp();
    }

    public void recalculate() {
        for (TextLine textLine : this.text) {
            this.calculateWrappedLine(textLine);
        }
        this.recalculateSizes();
    }

    protected void recalculateWrapping() {
        if (this.wrapping) {
            for (TextLine textLine : this.text) {
                this.calculateWrappedLine(textLine);
            }
        }
    }

    protected void calculateWrappedLine(T textLine) {
        if (this.wrapping) {
            ((TextLine)textLine).calculateWrappedLines(this.font, this.getWrappedWidth());
        } else {
            ((TextLine)textLine).resetWrapping();
        }
    }

    protected void recalculateSizes() {
        int w = 0;
        int h = 0;
        for (TextLine textLine : this.text) {
            if (!this.wrapping) {
                w = Math.max(this.font.func_78256_a(textLine.text), w);
            }
            h += textLine.getLines() * this.lineHeight;
        }
        int offset = this.getShiftX();
        this.horizontal.copy(this.area);
        this.horizontal.x += offset;
        this.horizontal.w -= offset;
        this.horizontal.scrollSize = this.wrapping ? w : this.getHorizontalSize(w);
        this.vertical.copy(this.area);
        this.vertical.scrollSize = h - (this.lineHeight - this.font.field_78288_b) + this.padding * 2;
    }

    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (this.horizontal.mouseClicked(context) || this.vertical.mouseClicked(context)) {
            return true;
        }
        boolean wasFocused = this.focused;
        boolean shift = GuiScreen.func_146272_n();
        this.focused = this.area.isInside(context);
        if (this.focused) {
            if (context.mouseButton == 0) {
                if (System.currentTimeMillis() < this.lastClick) {
                    this.selectGroup(0, true);
                    this.lastClick -= 500L;
                } else {
                    if (!shift) {
                        this.deselect();
                        this.dragging = 1;
                    } else if (!this.isSelected()) {
                        this.startSelecting();
                    }
                    this.moveCursorTo(this.cursor, context.mouseX, context.mouseY);
                    this.lastClick = System.currentTimeMillis() + 200L;
                }
            } else if (context.mouseButton == 2) {
                this.dragging = 3;
            }
            this.lastMX = context.mouseX;
            this.lastMY = context.mouseY;
        }
        if (wasFocused != this.focused) {
            context.focus((IFocusedGuiElement)(wasFocused ? null : this));
        }
        return this.focused;
    }

    public boolean mouseScrolled(GuiContext context) {
        if (super.mouseScrolled(context)) {
            return true;
        }
        if (GuiScreen.func_146272_n()) {
            return this.horizontal.mouseScroll(context);
        }
        if (this.vertical.scrollSize < this.area.h) {
            return false;
        }
        return this.vertical.mouseScroll(context);
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.horizontal.mouseReleased(context);
        this.vertical.mouseReleased(context);
        this.dragging = 0;
    }

    public boolean keyTyped(GuiContext context) {
        boolean shift;
        if (super.keyTyped(context)) {
            return true;
        }
        if (!this.focused) {
            return false;
        }
        if (context.keyCode == 1) {
            context.unfocus();
            return true;
        }
        TextEditUndo undo = new TextEditUndo(this);
        boolean ctrl = GuiScreen.func_146271_m();
        if (this.handleKeys(context, undo, ctrl, shift = GuiScreen.func_146272_n())) {
            this.moveViewportToCursor();
        }
        if (undo.ready) {
            this.undo.pushUndo((IUndo)undo);
        }
        this.update = context.tick + 20L;
        this.horizontal.clamp();
        this.vertical.clamp();
        return false;
    }

    protected boolean handleKeys(GuiContext context, TextEditUndo undo, boolean ctrl, boolean shift) {
        if (ctrl && context.keyCode == 44) {
            boolean result = this.undo.undo((Object)this);
            if (result) {
                this.playSound(SoundEvents.field_187651_T);
            }
            return result;
        }
        if (ctrl && context.keyCode == 21) {
            boolean result = this.undo.redo((Object)this);
            if (result) {
                this.playSound(SoundEvents.field_187657_V);
            }
            return result;
        }
        if (ctrl && context.keyCode == 30) {
            this.selectAll();
        } else {
            if (context.keyCode == 200 || context.keyCode == 208 || context.keyCode == 205 || context.keyCode == 203) {
                int y;
                int x;
                int n = context.keyCode == 205 ? 1 : (x = context.keyCode == 203 ? -1 : 0);
                int n2 = context.keyCode == 200 ? -1 : (y = context.keyCode == 208 ? 1 : 0);
                if (x != 0 && ctrl) {
                    if (!this.selectGroup(x, shift)) {
                        this.checkSelection(shift);
                        this.moveCursor(x, 0);
                    }
                } else {
                    this.checkSelection(shift);
                    this.moveCursor(x, y);
                }
                this.playSound(SoundEvents.field_187554_ai);
                return true;
            }
            if (context.keyCode == 199) {
                this.checkSelection(shift);
                this.moveCursorToLineStart();
                this.playSound(SoundEvents.field_187737_v);
                return true;
            }
            if (context.keyCode == 207) {
                this.checkSelection(shift);
                this.moveCursorToLineEnd();
                this.playSound(SoundEvents.field_187731_t);
                return true;
            }
            if (ctrl && (context.keyCode == 46 || context.keyCode == 45) && this.isSelected()) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (context.keyCode == 45) {
                    this.deleteSelection();
                    this.deselect();
                    undo.ready().post("", this.cursor, this.selection);
                    this.playSound(SoundEvents.field_187698_i);
                } else {
                    this.playSound(SoundEvents.field_187638_cR);
                }
                return context.keyCode == 45;
            }
            if (ctrl && context.keyCode == 47) {
                String pasted = GuiScreen.func_146277_j();
                this.deleteSelection();
                this.deselect();
                this.writeString(pasted);
                undo.ready().post(pasted, this.cursor, this.selection);
                this.playSound(SoundEvents.field_187539_bB);
                return true;
            }
            if (ctrl && context.keyCode == 32) {
                this.deselect();
                String copy = ((TextLine)this.text.get((int)this.cursor.line)).text;
                this.moveCursorToLineEnd();
                this.writeNewLine();
                this.moveCursorToLineStart();
                this.writeString(copy);
                undo.ready().post(copy + "\n" + copy, this.cursor, this.selection);
                this.playSound(SoundEvents.field_187539_bB);
                return true;
            }
            if (context.keyCode == 15) {
                this.keyTab(undo.ready());
                undo.post(undo.postText, this.cursor, this.selection);
                this.playSound(GuiScreen.func_146272_n() ? SoundEvents.field_187712_dQ : SoundEvents.field_187715_dR);
                return true;
            }
            if (ctrl && context.keyCode == 53) {
                String line;
                int i;
                Cursor min = new Cursor();
                Cursor max = new Cursor();
                if (this.isSelected()) {
                    min.copy(this.getMin());
                    max.copy(this.getMax());
                } else {
                    min.copy(this.cursor);
                    max.copy(this.cursor);
                }
                int numCommentedLines = 0;
                int numUncommentedLines = 0;
                for (i = min.line; i <= max.line; ++i) {
                    line = ((TextLine)this.text.get((int)i)).text;
                    if (line.startsWith("//")) {
                        ++numCommentedLines;
                        continue;
                    }
                    ++numUncommentedLines;
                }
                for (i = min.line; i <= max.line; ++i) {
                    line = ((TextLine)this.text.get((int)i)).text;
                    if (numUncommentedLines == 0 && numCommentedLines > 0) {
                        if (!line.startsWith("//")) continue;
                        ((TextLine)this.text.get(i)).set(line.substring(2));
                        continue;
                    }
                    if (numUncommentedLines <= 0 || line.startsWith("//")) continue;
                    ((TextLine)this.text.get(i)).set("//" + line);
                }
                if (this.isSelected()) {
                    String selected = this.getSelectedText();
                    this.deleteSelection();
                    this.writeString(selected);
                } else {
                    String currentLine = ((TextLine)this.text.get((int)this.cursor.line)).text;
                    ((TextLine)this.text.get(this.cursor.line)).set("");
                    this.writeString(currentLine);
                }
                undo.ready().post("", this.cursor, this.selection);
                this.changedLineAfter(min.line);
                this.playSound(SoundEvents.field_187654_U);
                return true;
            }
            if (context.keyCode == 28) {
                this.keyNewLine(undo.ready());
                undo.post(undo.postText, this.cursor, this.selection);
                this.playSound(SoundEvents.field_187534_aX);
                return true;
            }
            if (context.keyCode == 14 || context.keyCode == 211) {
                boolean delete;
                boolean bl = delete = context.keyCode == 211;
                if (this.isSelected()) {
                    this.deleteSelection();
                    this.deselect();
                    this.playSound(SoundEvents.field_187539_bB);
                } else {
                    if (delete) {
                        int measure = ctrl ? Math.max(this.measureGroup(1, this.cursor), 1) : 1;
                        for (int i = 0; i < measure; ++i) {
                            this.moveCursor(1, 0);
                            undo.text = undo.text + this.deleteCharacter();
                        }
                    } else {
                        this.keyBackspace(undo, ctrl);
                    }
                    this.playSound(SoundEvents.field_187835_fT);
                }
                undo.ready().post("", this.cursor, this.selection);
                return true;
            }
            if (ChatAllowedCharacters.func_71566_a((char)context.typedChar)) {
                String character = this.getFromChar(context.typedChar);
                if (!character.isEmpty()) {
                    this.deleteSelection();
                    this.deselect();
                    this.writeCharacter(character);
                    this.moveCursor(1, 0);
                    undo.ready().post(character, this.cursor, this.selection);
                    this.playSound(SoundEvents.field_187845_fY);
                }
                return true;
            }
        }
        return false;
    }

    protected void playSound(SoundEvent event) {
        if (((Boolean)Mappet.scriptEditorSounds.get()).booleanValue()) {
            GuiMappetUtils.playSound(event);
        }
    }

    protected String getFromChar(char typedChar) {
        return String.valueOf(typedChar);
    }

    protected void keyNewLine(TextEditUndo undo) {
        this.deleteSelection();
        this.deselect();
        this.writeNewLine();
        undo.postText = undo.postText + "\n";
    }

    protected void keyBackspace(TextEditUndo undo, boolean ctrl) {
        int measure = ctrl ? Math.max(Math.abs(this.measureGroup(-1, this.cursor)), 1) : 1;
        for (int i = 0; i < measure; ++i) {
            undo.text = this.deleteCharacter() + undo.text;
        }
    }

    protected void keyTab(TextEditUndo undo) {
        undo.postText = "    ";
        this.deleteSelection();
        this.deselect();
        this.writeString(undo.postText);
    }

    public void draw(GuiContext context) {
        this.handleLogic(context);
        if (this.background) {
            this.drawBackground();
        }
        super.draw(context);
        GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
        int x = this.area.x + this.padding;
        int y = this.area.y + this.padding;
        Cursor min = this.getMin();
        Cursor max = this.getMax();
        if (this.isSelected()) {
            this.drawSelectionBar(x, y, min, max);
        }
        int ci = this.text.size();
        for (int i = 0; i < ci; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            String line = textLine.text;
            int newX = x - this.horizontal.scroll + this.getShiftX();
            int newY = y - this.vertical.scroll;
            if (newY > this.area.ey()) break;
            boolean drawCursor = this.cursor.line == i && this.focused;
            int lines = textLine.getLines() - 1;
            if (newY + this.font.field_78288_b + lines * this.lineHeight >= this.area.y) {
                int cursorW = 0;
                int cursorA = 0;
                if (drawCursor) {
                    cursorW = line.isEmpty() ? 0 : this.font.func_78256_a(this.cursor.start(line));
                    cursorA = (int)(Math.sin((double)((float)context.tick + context.partialTicks) / 2.0) * 127.5 + 127.5) << 24;
                }
                if (textLine.wrappedLines == null) {
                    if (drawCursor) {
                        Gui.func_73734_a((int)(newX + cursorW), (int)(newY - 1), (int)(newX + cursorW + 1), (int)(newY + this.font.field_78288_b + 1), (int)(cursorA + 0xFFFFFF));
                    }
                    this.drawTextLine(line, i, 0, newX, newY);
                } else {
                    int wrappedW = 0;
                    int cj = textLine.wrappedLines.size();
                    for (int j = 0; j < cj; ++j) {
                        String wrappedLine = textLine.wrappedLines.get(j);
                        int lineW = this.font.func_78256_a(wrappedLine);
                        int lineY = newY + j * this.lineHeight;
                        if (cursorW >= wrappedW && cursorW < wrappedW + lineW || this.cursor.offset >= textLine.text.length()) {
                            Gui.func_73734_a((int)(newX + cursorW - wrappedW), (int)(lineY - 1), (int)(newX + cursorW - wrappedW + 1), (int)(lineY + this.font.field_78288_b + 1), (int)(cursorA + 0xFFFFFF));
                        }
                        this.drawTextLine(wrappedLine, i, j, newX, lineY);
                        wrappedW += lineW;
                    }
                }
            }
            y += textLine.getLines() * this.lineHeight;
        }
        this.horizontal.drawScrollbar();
        this.vertical.drawScrollbar();
        this.drawForeground(context);
        GuiDraw.unscissor((GuiContext)context);
    }

    protected int getShiftX() {
        return 0;
    }

    protected int getHorizontalSize(int w) {
        return w + this.padding * 2 + this.getShiftX();
    }

    protected void drawTextLine(String line, int i, int j, int nx, int ny) {
        this.font.func_175065_a(line, (float)nx, (float)ny, this.textColor, this.textShadow);
    }

    protected void drawBackground() {
        this.area.draw(-6250336);
        this.area.draw(-16777216, 1);
    }

    protected void drawForeground(GuiContext context) {
    }

    private void handleLogic(GuiContext context) {
        if (this.update > this.lastUpdate) {
            this.lastUpdate = this.update;
            if (this.callback != null) {
                this.callback.accept(this.getText());
            }
        }
        if (this.dragging == 1 && (Math.abs(context.mouseX - this.lastMX) > 4 || Math.abs(context.mouseY - this.lastMY) > 4)) {
            this.startSelecting();
            this.dragging = 2;
        }
        if (this.focused && this.dragging == 2) {
            this.moveCursorTo(this.cursor, context.mouseX, context.mouseY);
            this.moveViewportToCursor();
        }
        if (this.dragging == 3) {
            this.horizontal.scroll += this.lastMX - context.mouseX;
            this.horizontal.clamp();
            this.vertical.scroll += this.lastMY - context.mouseY;
            this.vertical.clamp();
            this.lastMX = context.mouseX;
            this.lastMY = context.mouseY;
        }
        this.horizontal.drag(context);
        this.vertical.drag(context);
    }

    private void drawSelectionBar(int x, int y, Cursor min, Cursor max) {
        Vector2d minPos = this.getCursorPosition(min);
        Vector2d maxPos = this.getCursorPosition(max);
        this.drawSelectionArea(x + (int)minPos.x, y + (int)minPos.y, x + (int)maxPos.x, y + (int)maxPos.y);
    }

    protected Vector2d getCursorPosition(Cursor cursor) {
        Vector2d pos = new Vector2d();
        if (this.wrapping) {
            this.getCusrorPositionWrapped(cursor, pos);
        } else {
            String line = ((TextLine)this.text.get((int)cursor.line)).text;
            pos.x = this.font.func_78256_a(cursor.start(line));
            pos.y = cursor.line * this.lineHeight;
        }
        pos.x = pos.x - (double)this.horizontal.scroll + (double)this.getShiftX();
        pos.y -= (double)this.vertical.scroll;
        return pos;
    }

    private void getCusrorPositionWrapped(Cursor cursor, Vector2d pos) {
        int lines = 0;
        int offset = 0;
        int c = this.text.size();
        for (int i = 0; i < c; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            int textLines = textLine.getLines();
            if (i == cursor.line) {
                if (textLine.wrappedLines == null) {
                    offset = this.font.func_78256_a(cursor.start(textLine.text));
                    break;
                }
                int textOffset = 0;
                for (int j = 0; j < textLine.wrappedLines.size(); ++j) {
                    String wrappedLine = textLine.wrappedLines.get(j);
                    if (cursor.offset >= textOffset && cursor.offset < textOffset + wrappedLine.length()) {
                        offset = this.font.func_78256_a(wrappedLine.substring(0, cursor.offset - textOffset));
                        break;
                    }
                    ++lines;
                    textOffset += wrappedLine.length();
                }
                if (cursor.offset < textLine.text.length()) break;
                --lines;
                offset = this.font.func_78256_a(textLine.wrappedLines.get(textLine.wrappedLines.size() - 1));
                break;
            }
            lines += textLines;
        }
        pos.x = offset;
        pos.y = lines * this.lineHeight;
    }

    private void drawSelectionArea(int x1, int y1, int x2, int y2) {
        int endY;
        int selectionPad = 2;
        int color = -2013265920 + (Integer)McLib.primaryColor.get();
        boolean middle = y2 > y1 + this.lineHeight;
        boolean bottom = y2 > y1;
        int endX = bottom || middle ? this.area.ex() : x2 + 2;
        int n = endY = bottom && !middle ? y2 : y1 + this.font.field_78288_b;
        if (!bottom && !middle) {
            endY += 2;
        }
        Gui.func_73734_a((int)(x1 - 2), (int)(y1 - 2), (int)endX, (int)endY, (int)color);
        if (middle) {
            Gui.func_73734_a((int)this.area.x, (int)(y1 + this.font.field_78288_b), (int)this.area.ex(), (int)y2, (int)color);
        }
        if (bottom) {
            Gui.func_73734_a((int)this.area.x, (int)y2, (int)(x2 + 2), (int)(y2 + this.font.field_78288_b + 2), (int)color);
        }
    }
}

