/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils.graphics;

import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mappet.client.gui.utils.graphics.GradientGraphic;
import mchorse.mappet.client.gui.utils.graphics.IconGraphic;
import mchorse.mappet.client.gui.utils.graphics.ImageGraphic;
import mchorse.mappet.client.gui.utils.graphics.RectGraphic;
import mchorse.mappet.client.gui.utils.graphics.ShadowGraphic;
import mchorse.mappet.client.gui.utils.graphics.TextGraphic;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Graphic
implements INBTSerializable<NBTTagCompound> {
    private static Area computed = new Area();
    public Area pixels = new Area();
    public float relativeX;
    public float relativeY;
    public float relativeW;
    public float relativeH;
    public float anchorX;
    public float anchorY;
    public int primary;
    public boolean hover;

    @DiscardMethod
    public static Graphic fromNBT(NBTTagCompound tag) {
        String type = tag.func_74779_i("Type");
        Graphic graphic = null;
        if (type.equals("rect")) {
            graphic = new RectGraphic();
        } else if (type.equals("gradient")) {
            graphic = new GradientGraphic();
        } else if (type.equals("image")) {
            graphic = new ImageGraphic();
        } else if (type.equals("text")) {
            graphic = new TextGraphic();
        } else if (type.equals("icon")) {
            graphic = new IconGraphic();
        } else if (type.equals("shadow")) {
            graphic = new ShadowGraphic();
        }
        if (graphic != null) {
            graphic.deserializeNBT(tag);
        }
        return graphic;
    }

    @DiscardMethod
    public static NBTTagCompound toNBT(Graphic graphic) {
        NBTTagCompound tag = graphic.serializeNBT();
        String type = "rect";
        if (graphic instanceof GradientGraphic) {
            type = "gradient";
        } else if (graphic instanceof ImageGraphic) {
            type = "image";
        } else if (graphic instanceof TextGraphic) {
            type = "text";
        } else if (graphic instanceof IconGraphic) {
            type = "icon";
        } else if (graphic instanceof ShadowGraphic) {
            type = "shadow";
        }
        tag.func_74778_a("Type", type);
        return tag;
    }

    public Graphic x(int value) {
        this.relativeX = 0.0f;
        this.pixels.x = value;
        return this;
    }

    public Graphic rx(float value) {
        return this.rx(value, 0);
    }

    public Graphic rx(float value, int offset) {
        this.relativeX = value;
        this.pixels.x = offset;
        return this;
    }

    public Graphic y(int value) {
        this.relativeY = 0.0f;
        this.pixels.y = value;
        return this;
    }

    public Graphic ry(float value) {
        return this.ry(value, 0);
    }

    public Graphic ry(float value, int offset) {
        this.relativeY = value;
        this.pixels.y = offset;
        return this;
    }

    public Graphic w(int value) {
        this.relativeW = 0.0f;
        this.pixels.w = value;
        return this;
    }

    public Graphic rw(float value) {
        return this.rw(value, 0);
    }

    public Graphic rw(float value, int offset) {
        this.relativeW = value;
        this.pixels.w = offset;
        return this;
    }

    public Graphic h(int value) {
        this.relativeH = 0.0f;
        this.pixels.h = value;
        return this;
    }

    public Graphic rh(float value) {
        return this.rh(value, 0);
    }

    public Graphic rh(float value, int offset) {
        this.relativeH = value;
        this.pixels.h = offset;
        return this;
    }

    public Graphic xy(int x, int y) {
        return this.x(x).y(y);
    }

    public Graphic rxy(float x, float y) {
        return this.rx(x).ry(y);
    }

    public Graphic wh(int w, int h) {
        return this.w(w).h(h);
    }

    public Graphic rwh(float w, float h) {
        return this.rw(w).rh(h);
    }

    public Graphic anchor(float anchor) {
        return this.anchor(anchor, this.anchorY);
    }

    public Graphic anchor(float x, float y) {
        return this.anchorX(x).anchorY(y);
    }

    public Graphic anchorX(float x) {
        this.anchorX = x;
        return this;
    }

    public Graphic anchorY(float y) {
        this.anchorY = y;
        return this;
    }

    public Graphic hoverOnly() {
        this.hover = true;
        return this;
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public final void draw(GuiContext context, Area elementArea) {
        Graphic.computed.x = elementArea.x + (int)((float)elementArea.w * this.relativeX) + this.pixels.x;
        Graphic.computed.y = elementArea.y + (int)((float)elementArea.h * this.relativeY) + this.pixels.y;
        Graphic.computed.w = (int)((float)elementArea.w * this.relativeW) + this.pixels.w;
        Graphic.computed.h = (int)((float)elementArea.h * this.relativeH) + this.pixels.h;
        Graphic.computed.x = (int)((float)Graphic.computed.x - (float)Graphic.computed.w * this.anchorX);
        Graphic.computed.y = (int)((float)Graphic.computed.y - (float)Graphic.computed.h * this.anchorY);
        if (!this.hover || computed.isInside(context)) {
            this.drawGraphic(computed);
        }
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected abstract void drawGraphic(Area var1);

    @DiscardMethod
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.serializeNBT(tag);
        return tag;
    }

    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        tag.func_74768_a("X", this.pixels.x);
        tag.func_74768_a("Y", this.pixels.y);
        tag.func_74768_a("W", this.pixels.w);
        tag.func_74768_a("H", this.pixels.h);
        tag.func_74776_a("RX", this.relativeX);
        tag.func_74776_a("RY", this.relativeY);
        tag.func_74776_a("RW", this.relativeW);
        tag.func_74776_a("RH", this.relativeH);
        tag.func_74776_a("AX", this.anchorX);
        tag.func_74776_a("AY", this.anchorY);
        tag.func_74768_a("Primary", this.primary);
        tag.func_74757_a("Hover", this.hover);
    }

    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        this.pixels.x = tag.func_74762_e("X");
        this.pixels.y = tag.func_74762_e("Y");
        this.pixels.w = tag.func_74762_e("W");
        this.pixels.h = tag.func_74762_e("H");
        this.relativeX = tag.func_74760_g("RX");
        this.relativeY = tag.func_74760_g("RY");
        this.relativeW = tag.func_74760_g("RW");
        this.relativeH = tag.func_74760_g("RH");
        this.anchorX = tag.func_74760_g("AX");
        this.anchorY = tag.func_74760_g("AY");
        this.primary = tag.func_74762_e("Primary");
        this.hover = tag.func_74767_n("Hover");
    }
}

