/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils;

import java.util.List;
import mchorse.mappet.client.gui.utils.GuiSteeringOffsetElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class GuiBlockPosList
extends GuiElement {
    private List<BlockPos> posList;

    public GuiBlockPosList(Minecraft mc) {
        super(mc);
        this.flex().column(5).stretch().vertical();
    }

    public void addBlockPos() {
        this.posList.add(new BlockPos(0, 0, 0));
        this.add((IGuiElement)this.create());
        this.getParentContainer().resize();
    }

    public void set(List<BlockPos> posList) {
        this.posList = posList;
        this.removeAll();
        for (BlockPos pos : posList) {
            GuiSteeringOffsetElement posElement = this.create();
            posElement.position.set(pos);
            this.add((IGuiElement)posElement);
        }
        this.getParentContainer().resize();
    }

    private GuiSteeringOffsetElement create() {
        GuiSteeringOffsetElement element = new GuiSteeringOffsetElement(this.mc);
        element.position.callback = blockPos -> this.posList.set(this.getChildren().indexOf((Object)element), (BlockPos)blockPos);
        element.position.context(() -> element.position.createDefaultContextMenu(false).action(Icons.REMOVE, IKey.lang((String)"mappet.gui.block_pos.context.remove"), () -> this.removeBlock(element), 0xFF0033));
        return element;
    }

    private void removeBlock(GuiSteeringOffsetElement element) {
        int index = this.getChildren().indexOf((Object)element);
        this.remove(element);
        this.posList.remove(index);
        this.getParentContainer().resize();
    }
}

