/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.utils.documentation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import mchorse.mappet.ClientProxy;
import mchorse.mappet.client.gui.scripts.GuiDocumentationOverlayPanel;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocClass;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocMethod;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocPackage;
import mchorse.mappet.client.gui.scripts.utils.documentation.Docs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class DocMerger {
    public static Docs getMergedDocs() {
        Minecraft mc = Minecraft.func_71410_x();
        Language language = mc.func_135016_M().func_135041_c();
        Gson gson = new GsonBuilder().create();
        ArrayList<Docs> docsList = new ArrayList<Docs>();
        File docsFolder = new File(ClientProxy.configFolder.getPath(), "documentation");
        docsFolder.mkdirs();
        DocMerger.addAddonsDocs(gson, docsList);
        List files = FileUtils.listFiles((File)docsFolder, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(File::isFile).collect(Collectors.toList());
        List translationFiles = files.stream().filter(file -> file.getParent().equals("translation")).collect(Collectors.toList());
        for (File file2 : files) {
            boolean isTranslation = file2.getParent().equals("translation");
            if (isTranslation) continue;
            DocMerger.addDocToList(gson, docsList, file2);
        }
        for (File file2 : translationFiles) {
            if (!language.func_135034_a().equals(file2.getName())) continue;
            DocMerger.addDocToList(gson, docsList, file2);
        }
        InputStream stream = GuiDocumentationOverlayPanel.class.getResourceAsStream("/assets/mappet/docs.json");
        Scanner scanner = new Scanner(stream, "UTF-8");
        Docs mainDocs = (Docs)gson.fromJson(scanner.useDelimiter("\\A").next(), Docs.class);
        for (Docs doc : docsList) {
            DocMerger.mergeDocs(mainDocs, doc);
        }
        return mainDocs;
    }

    private static void addAddonsDocs(Gson gson, List<Docs> docsList) {
    }

    private static void mergeDocs(Docs docsMain, Docs docsAdd) {
        for (DocClass classAdd : docsAdd.classes) {
            classAdd.source = docsAdd.source;
            DocClass classMain = docsMain.getClass(classAdd.name);
            if (classMain == null) {
                docsMain.classes.add(classAdd);
                continue;
            }
            classMain.doc = classAdd.doc.trim().isEmpty() ? classMain.doc : classAdd.doc.trim();
            DocMerger.mergeClasses(classMain, classAdd);
        }
        for (DocPackage packageAdd : docsAdd.packages) {
            packageAdd.source = docsAdd.source;
            DocPackage packageMain = docsMain.getPackage(packageAdd.name);
            if (packageMain == null) {
                docsMain.packages.add(packageAdd);
                continue;
            }
            packageMain.doc = packageAdd.doc;
            Collections.replaceAll(docsMain.packages, packageMain, packageAdd);
        }
    }

    private static void mergeClasses(DocClass classMain, DocClass classAdd) {
        for (DocMethod methodAdd : classAdd.methods) {
            methodAdd.source = classAdd.source;
            DocMethod methodMain = classMain.getExactMethod(methodAdd.name);
            if (methodMain == null) {
                classMain.methods.add(methodAdd);
                continue;
            }
            methodMain.doc = methodAdd.doc;
            Collections.replaceAll(classMain.methods, methodMain, methodAdd);
        }
    }

    private static void addDocToList(Gson gson, List<Docs> list, File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            Scanner scanner = new Scanner((InputStream)stream, "UTF-8");
            Docs docs = (Docs)gson.fromJson(scanner.useDelimiter("\\A").next(), Docs.class);
            docs.source = new File(ClientProxy.configFolder.getPath()).toPath().relativize(file.toPath()).toFile().getPath();
            docs.classes.forEach(clazz -> {
                clazz.source = docs.source;
                clazz.methods.forEach(method -> {
                    method.source = docs.source;
                });
            });
            list.add(docs);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

