/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.utils.documentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import joptsimple.internal.Strings;
import mchorse.mappet.Mappet;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public abstract class DocEntry {
    public DocEntry parent;
    public String name = "";
    public String doc = "";
    public String source = "Mappet";

    public static String processCode(String code) {
        int i;
        String string;
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(code.split("\n")));
        int first = 0;
        Iterator iterator = strings.iterator();
        while (iterator.hasNext() && (string = (String)iterator.next()).trim().isEmpty()) {
            ++first;
        }
        String firstLine = (String)strings.get(first);
        int indent = 0;
        for (i = 0; i < firstLine.length() && firstLine.charAt(i) == ' '; ++i) {
            ++indent;
        }
        strings.remove(strings.size() - 1);
        if (indent > 0) {
            for (i = 0; i < strings.size(); ++i) {
                String string2 = (String)strings.get(i);
                if (string2.length() <= indent) continue;
                strings.set(i, string2.substring(indent));
            }
        }
        return Strings.join(strings, (String)"\n").trim();
    }

    public static void process(String doc, Minecraft mc, GuiScrollElement target) {
        String[] splits = doc.split("\n{2,}");
        boolean parsing = false;
        String code = "";
        for (String line : splits) {
            Object text;
            if (line.trim().startsWith("<pre>{@code")) {
                parsing = true;
                line = line.trim().substring("<pre>{@code".length() + 1);
            }
            if (parsing) {
                code = code + "\n\n" + line;
            } else {
                boolean p = line.trim().startsWith("<p>");
                line = line.replaceAll("\n", "").trim();
                line = line.replaceAll("<b>", TextFormatting.BOLD.toString());
                line = line.replaceAll("<i>", TextFormatting.ITALIC.toString());
                line = line.replaceAll("<s>", TextFormatting.STRIKETHROUGH.toString());
                line = line.replaceAll("<code>", TextFormatting.GRAY.toString());
                line = line.replaceAll("<li> *", "\n- ");
                line = line.replaceAll("</(b|i|s|code|ul|li)>", TextFormatting.RESET.toString());
                line = line.replaceAll("</?(p|ul|li)>", "");
                line = line.replaceAll("\\{@link +[^}]+\\.([^}]+)}", TextFormatting.GOLD + "$1" + TextFormatting.RESET);
                line = line.replaceAll("\\{@link +([^}]*)#([^}]+)}", TextFormatting.GOLD + "$1" + TextFormatting.RESET + "." + TextFormatting.GRAY + "$2" + TextFormatting.RESET);
                line = line.replaceAll("\\{@link ([^}]+)}", TextFormatting.GOLD + "$1" + TextFormatting.RESET);
                line = line.replaceAll("&lt;", "<");
                line = line.replaceAll("&gt;", ">");
                line = line.replaceAll("&amp;", "&");
                text = new GuiText(mc).text(line.trim().replaceAll(" {2,}", " "));
                if (p) {
                    text.marginTop(12);
                }
                target.add((IGuiElement)text);
            }
            if (!line.trim().endsWith("}</pre>")) continue;
            GuiTextEditor editor = new GuiTextEditor(mc, null);
            text = DocEntry.processCode(code).replaceAll("\u00a7", "\\\\u00A7");
            editor.setText((String)text);
            editor.background().flex().h(editor.getLines().size() * 12 + 20);
            editor.getHighlighter().setStyle(Mappet.scriptEditorSyntaxStyle.get());
            target.add((IGuiElement)editor);
            parsing = false;
            code = "";
        }
    }

    public String getName() {
        int index = this.name.lastIndexOf(".");
        if (index < 0) {
            return this.name;
        }
        return this.name.substring(index + 1);
    }

    public void fillIn(Minecraft mc, GuiScrollElement target) {
        target.add((IGuiElement)new GuiText(mc).text(IKey.format((String)"mappet.gui.scripts.documentation.source", (Object[])new Object[]{this.source})));
        DocEntry.process(this.doc, mc, target);
    }

    public List<DocEntry> getEntries() {
        return Collections.emptyList();
    }

    public DocEntry getEntry() {
        return this;
    }
}

