/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.themes;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mappet.Mappet;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.scripts.themes.Themes;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.client.gui.utils.overlays.GuiEditorOverlayPanel;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;

public class GuiThemeEditorOverlayPanel
extends GuiEditorOverlayPanel<SyntaxStyleEntry> {
    public static final String CODE_SAMPLE = "/* Main function */\nfunction main(e) {\n    // Set subject's position one block higher\n    var pos = e.subject().position();\n    \n    this.orange = \"Hello, world!\";\n    \n    e.send(this.orange);\n    e.subject().position(pos.x, pos.y + 1, pos.z);\n}";
    public GuiIconElement open;
    public GuiTextElement title;
    public GuiToggleElement shadow;
    public GuiColorElement primary;
    public GuiColorElement secondary;
    public GuiColorElement identifier;
    public GuiColorElement special;
    public GuiColorElement strings;
    public GuiColorElement comments;
    public GuiColorElement numbers;
    public GuiColorElement other;
    public GuiColorElement lineNumbers;
    public GuiColorElement background;
    public GuiTextEditor preview;

    public GuiThemeEditorOverlayPanel(Minecraft mc) {
        super(mc, IKey.lang((String)"mappet.gui.syntax_theme.main"));
        this.open = new GuiIconElement(mc, Icons.FOLDER, b -> Themes.open());
        this.open.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.folder")).flex().wh(16, 16);
        this.title = new GuiTextElement(mc, 100, s -> {
            ((SyntaxStyleEntry)this.item).style.title = s;
        });
        this.shadow = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.syntax_theme.shadow"), b -> {
            ((SyntaxStyleEntry)this.item).style.shadow = b.isToggled();
        });
        this.primary = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.primary = c;
            this.preview.resetHighlight();
        });
        this.primary.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.primary"));
        this.secondary = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.secondary = c;
            this.preview.resetHighlight();
        });
        this.secondary.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.secondary"));
        this.identifier = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.identifier = c;
            this.preview.resetHighlight();
        });
        this.identifier.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.identifier"));
        this.special = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.special = c;
            this.preview.resetHighlight();
        });
        this.special.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.special"));
        this.strings = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.strings = c;
            this.preview.resetHighlight();
        });
        this.strings.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.strings"));
        this.comments = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.comments = c;
            this.preview.resetHighlight();
        });
        this.comments.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.comments"));
        this.numbers = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.numbers = c;
            this.preview.resetHighlight();
        });
        this.numbers.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.numbers"));
        this.other = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.other = c;
            this.preview.resetHighlight();
        });
        this.other.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.colors.other"));
        this.lineNumbers = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.lineNumbers = c;
        });
        this.lineNumbers.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.background_colors.line_numbers"));
        this.background = new GuiColorElement(mc, c -> {
            ((SyntaxStyleEntry)this.item).style.background = c;
        });
        this.background.tooltip(IKey.lang((String)"mappet.gui.syntax_theme.background_colors.background"));
        this.preview = new GuiTextEditor(mc, null);
        this.editor.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.syntax_theme.title")), this.title, this.shadow});
        this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.syntax_theme.colors.title")).marginTop(12));
        this.editor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.primary, this.secondary}));
        this.editor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.identifier, this.special}));
        this.editor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.strings, this.comments}));
        this.editor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.numbers, this.other}));
        this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.syntax_theme.background_colors.title")).marginTop(12));
        this.editor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.lineNumbers, this.background}));
        this.content.flex().h(0.5f);
        this.preview.flex().relative((GuiElement)this).y(0.5f, 28).w(1.0f).hTo((IResizer)this.area, 1.0f);
        this.preview.setText(CODE_SAMPLE);
        this.add((IGuiElement)this.preview.background());
        this.icons.add((IGuiElement)this.open);
        this.loadThemes();
    }

    private void loadThemes() {
        for (File file : Themes.themes()) {
            SyntaxStyle style = Themes.readTheme(file);
            if (style == null) continue;
            SyntaxStyleEntry entry = new SyntaxStyleEntry(file, style);
            this.list.add((Object)entry);
        }
        if (this.list.getList().isEmpty()) {
            this.list.add((Object)new SyntaxStyleEntry(Themes.themeFile("monokai.json"), new SyntaxStyle()));
        }
        for (SyntaxStyleEntry entry : this.list.getList()) {
            if (!entry.file.getName().equals(Mappet.scriptEditorSyntaxStyle.getFile())) continue;
            this.pickItem(entry, true);
            break;
        }
        if (this.list.isDeselected()) {
            this.list.setIndex(0);
            this.pickItem((SyntaxStyleEntry)this.list.getCurrentFirst(), true);
        }
    }

    @Override
    protected GuiListElement<SyntaxStyleEntry> createList(Minecraft mc) {
        return new GuiSyntaxStyleListElement(mc, l -> this.pickItem((SyntaxStyleEntry)l.get(0), false));
    }

    @Override
    protected IKey getAddLabel() {
        return IKey.lang((String)"mappet.gui.syntax_theme.context.add");
    }

    @Override
    protected IKey getRemoveLabel() {
        return IKey.lang((String)"mappet.gui.syntax_theme.context.remove");
    }

    @Override
    protected void addItem() {
        GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"mappet.gui.syntax_theme.modal.add"), this::addNewTheme));
    }

    private void addNewTheme(String string) {
        File file = Themes.themeFile(string);
        if (!file.isFile()) {
            SyntaxStyle style = new SyntaxStyle();
            SyntaxStyleEntry entry = new SyntaxStyleEntry(file, style);
            style.title = "";
            this.list.add((Object)entry);
            this.list.update();
            this.pickItem(entry, true);
        }
    }

    @Override
    protected void removeItem() {
        ((SyntaxStyleEntry)this.list.getCurrentFirst()).file.delete();
        super.removeItem();
    }

    @Override
    protected void pickItem(SyntaxStyleEntry item, boolean select) {
        item.save();
        Mappet.scriptEditorSyntaxStyle.set(item.file.getName(), item.style);
        this.preview.getHighlighter().setStyle(item.style);
        this.preview.resetHighlight();
        super.pickItem(item, select);
    }

    @Override
    protected void fillData(SyntaxStyleEntry item) {
        this.title.setText(item.style.title);
        this.shadow.toggled(item.style.shadow);
        this.primary.picker.setColor(item.style.primary);
        this.secondary.picker.setColor(item.style.secondary);
        this.identifier.picker.setColor(item.style.identifier);
        this.special.picker.setColor(item.style.special);
        this.strings.picker.setColor(item.style.strings);
        this.comments.picker.setColor(item.style.comments);
        this.numbers.picker.setColor(item.style.numbers);
        this.lineNumbers.picker.setColor(item.style.lineNumbers);
        this.background.picker.setColor(item.style.background);
        this.other.picker.setColor(item.style.other);
    }

    @Override
    public void onClose() {
        SyntaxStyleEntry item = (SyntaxStyleEntry)this.list.getCurrentFirst();
        item.save();
        Mappet.scriptEditorSyntaxStyle.set(item.file.getName(), item.style);
        super.onClose();
    }

    public static class SyntaxStyleEntry {
        public File file;
        public SyntaxStyle style;

        public SyntaxStyleEntry(File file, SyntaxStyle style) {
            this.file = file;
            this.style = style;
        }

        public void save() {
            Themes.writeTheme(this.file, this.style);
        }
    }

    public static class GuiSyntaxStyleListElement
    extends GuiListElement<SyntaxStyleEntry> {
        public GuiSyntaxStyleListElement(Minecraft mc, Consumer<List<SyntaxStyleEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(SyntaxStyleEntry element) {
            if (element.style.title.trim().isEmpty()) {
                return element.file.getName();
            }
            return element.style.title + " (" + element.file.getName() + ")";
        }
    }
}

