/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.scriptedItem;

import java.util.function.Consumer;
import mchorse.mappet.client.gui.scripts.scriptedItem.util.Textbox;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class GuiFormattedTextElement
extends GuiElement
implements IFocusedGuiElement {
    private static String[] formattingCodes = new String[]{"\u00a70", "\u00a71", "\u00a72", "\u00a73", "\u00a74", "\u00a75", "\u00a76", "\u00a77", "\u00a78", "\u00a79", "\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e", "\u00a7f", "\u00a7k", "\u00a7l", "\u00a7m", "\u00a7n", "\u00a7o"};
    private static int[] colors = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
    public Textbox text;
    private Consumer<String> callback;

    public GuiFormattedTextElement(Minecraft mc, Consumer<String> consumer) {
        super(mc);
        this.callback = consumer;
        this.text = new Textbox(consumer);
        this.text.setFont(mc.field_71466_p);
        this.text.setBorder(true);
    }

    public void resize() {
        super.resize();
        this.text.area.set(this.area.x, this.area.ey() - 20, this.area.w, 20);
    }

    public boolean mouseClicked(GuiContext context) {
        int cell = this.area.h - 20;
        if (this.area.isInside(context) && context.mouseY < this.area.y + cell) {
            int index = (context.mouseX - this.area.x) / cell;
            if (index >= formattingCodes.length || !this.text.isSelected()) {
                return super.mouseClicked(context);
            }
            String formattingCode = formattingCodes[index];
            String text = this.text.getText();
            int cursor = this.text.getCursor();
            int selection = this.text.getSelection();
            int beginning = Math.min(cursor, selection);
            int end = Math.max(cursor, selection);
            this.text.setText(text.substring(0, beginning) + formattingCode + this.text.getSelectedText() + "\u00a7r" + text.substring(end));
            this.text.moveCursorTo(beginning);
            this.text.setSelection(end + 4);
            if (this.callback != null) {
                this.callback.accept(this.text.getText());
            }
            return true;
        }
        if (super.mouseClicked(context)) {
            return true;
        }
        boolean wasFocused = this.text.isFocused();
        this.text.mouseClicked(context.mouseX, context.mouseY, context.mouseButton);
        if (wasFocused != this.text.isFocused()) {
            context.focus((IFocusedGuiElement)(wasFocused ? null : this));
        }
        return this.text.area.isInside(context);
    }

    public void mouseReleased(GuiContext context) {
        this.text.mouseReleased(context.mouseX, context.mouseY, context.mouseButton);
        super.mouseReleased(context);
    }

    public boolean keyTyped(GuiContext context) {
        if (this.isFocused()) {
            if (context.keyCode == 15) {
                context.focus((GuiElement)this, -1, GuiScreen.func_146272_n() ? -1 : 1);
                return true;
            }
            if (context.keyCode == 1) {
                context.unfocus();
                return true;
            }
        }
        return this.text.keyPressed(context) || this.text.textInput(context.typedChar) || super.keyTyped(context);
    }

    public void draw(GuiContext context) {
        this.area.draw(-15658735);
        int x = this.area.x;
        int y = this.area.y;
        int cell = this.area.h - 20;
        for (int i = 0; i < formattingCodes.length; ++i) {
            float aa;
            Area.SHARED.set(x, y, cell, cell);
            int a = Area.SHARED.isInside(context) ? -2013265920 : -16777216;
            float f = aa = Area.SHARED.isInside(context) ? 0.5f : 1.0f;
            if (i < colors.length) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + cell), (int)(y + cell), (int)(colors[i] | a));
            } else if (i == 16) {
                this.func_73732_a(context.font, formattingCodes[i] + "W", x + cell / 2, y + cell / 2 - context.font.field_78288_b / 2, ColorUtils.multiplyColor((int)0xFFFFFF, (float)aa));
            } else if (i == 17) {
                this.func_73732_a(context.font, formattingCodes[i] + "B", x + cell / 2, y + cell / 2 - context.font.field_78288_b / 2, ColorUtils.multiplyColor((int)0xFFFFFF, (float)aa));
            } else if (i == 18) {
                this.func_73732_a(context.font, formattingCodes[i] + "S", x + cell / 2, y + cell / 2 - context.font.field_78288_b / 2, ColorUtils.multiplyColor((int)0xFFFFFF, (float)aa));
            } else if (i == 19) {
                this.func_73732_a(context.font, formattingCodes[i] + "U", x + cell / 2, y + cell / 2 - context.font.field_78288_b / 2, ColorUtils.multiplyColor((int)0xFFFFFF, (float)aa));
            } else if (i == 20) {
                this.func_73732_a(context.font, formattingCodes[i] + "I", x + cell / 2, y + cell / 2 - context.font.field_78288_b / 2, ColorUtils.multiplyColor((int)0xFFFFFF, (float)aa));
            }
            x += cell;
        }
        this.text.render(context);
        super.draw(context);
    }

    public boolean isFocused() {
        return this.text.isFocused();
    }

    public void focus(GuiContext guiContext) {
        this.text.setFocused(true);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void unfocus(GuiContext guiContext) {
        this.text.setFocused(false);
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void selectAll(GuiContext guiContext) {
        this.text.moveCursorToEnd();
        this.text.setSelection(0);
    }

    public void unselect(GuiContext guiContext) {
        this.text.deselect();
    }
}

