/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.client.gui.panels.GuiScriptPanel;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.scripts.utils.HighlightedTextLine;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.client.gui.utils.text.utils.Cursor;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.scripts.PacketRepl;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiRepl
extends GuiElement {
    public GuiTextEditor repl;
    public GuiScrollElement log;
    private List<String> history = new ArrayList<String>();
    private int index = 0;

    public GuiRepl(Minecraft mc) {
        super(mc);
        this.repl = new GuiTextEditor(mc, null);
        this.repl.background().flex().relative((GuiElement)this).y(1.0f).w(1.0f).h(100).anchorY(1.0f);
        this.repl.context(() -> GuiScriptPanel.createScriptContextMenu(this.mc, this.repl));
        this.log = new GuiScrollElement(mc);
        this.log.flex().relative((GuiElement)this).w(1.0f).h(1.0f, -100).column(0).vertical().stretch().scroll();
        this.add(new IGuiElement[]{this.repl, this.log});
        this.repl.setText("\"" + I18n.func_135052_a((String)"mappet.gui.scripts.repl.hello_world", (Object[])new Object[0]) + "\"");
        this.log(I18n.func_135052_a((String)"mappet.gui.scripts.repl.welcome", (Object[])new Object[0]));
    }

    public boolean keyTyped(GuiContext context) {
        if (this.repl.isFocused() && context.keyCode == 28 && !GuiScreen.func_146272_n()) {
            String text = this.repl.getText();
            if (text.trim().startsWith("clear()")) {
                this.repl.clear();
                this.log.removeAll();
                return true;
            }
            if (!text.isEmpty()) {
                Dispatcher.sendToServer(new PacketRepl(text));
                this.repl.clear();
                this.history.add(text);
                this.index = this.history.size();
            }
            return true;
        }
        if (this.repl.isFocused() && !this.repl.isSelected() && !this.history.isEmpty() && GuiScreen.func_146271_m()) {
            Cursor cursor = this.repl.cursor;
            if (context.keyCode == 200 && this.index > 0) {
                --this.index;
                this.repl.setText(this.history.get(this.index));
                int lastLine = this.repl.getLines().size() - 1;
                cursor.set(lastLine, ((HighlightedTextLine)this.repl.getLines().get((int)lastLine)).text.length());
                this.repl.moveViewportToCursor();
                return true;
            }
            if (context.keyCode == 208 && this.index < this.history.size() - 1) {
                ++this.index;
                this.repl.setText(this.history.get(this.index));
                int lastLine = this.repl.getLines().size() - 1;
                cursor.set(lastLine, ((HighlightedTextLine)this.repl.getLines().get((int)lastLine)).text.length());
                this.repl.moveViewportToCursor();
                return true;
            }
        }
        return super.keyTyped(context);
    }

    public void log(String code) {
        if ((code = code.trim()).isEmpty()) {
            return;
        }
        int size = this.log.getChildren().size();
        boolean odd = (size + 1) % 2 == 1;
        this.log.add((IGuiElement)new GuiReplText(this.mc, odd, size == 0 ? 10 : 5).text(code));
        this.resize();
        this.log.scroll.scrollTo(this.log.scroll.scrollSize);
    }

    public static class GuiReplText
    extends GuiText {
        private boolean odd;

        public GuiReplText(Minecraft mc, boolean odd, int vertical) {
            super(mc);
            this.odd = odd;
            this.padding(10, vertical);
            this.context(() -> new GuiSimpleContextMenu(mc).action(Icons.COPY, IKey.str((String)"Copy text"), () -> GuiScreen.func_146275_d((String)this.getText().get())));
        }

        @Override
        public void draw(GuiContext context) {
            if (this.odd) {
                this.area.draw(-2013265920);
            }
            super.draw(context);
        }
    }
}

