/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.quests.objectives;

import mchorse.mappet.api.quests.objectives.KillObjective;
import mchorse.mappet.client.gui.quests.objectives.GuiObjective;
import mchorse.mappet.client.gui.utils.overlays.GuiEntityOverlayPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiResourceLocationOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiKillObjective
extends GuiObjective<KillObjective> {
    public GuiButtonElement entity;
    public GuiTrackpadElement count;
    public GuiTextElement tag;

    public GuiKillObjective(Minecraft mc, KillObjective objective) {
        super(mc, objective);
        this.entity = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.overlays.entities.main"), b -> this.openPickEntityOverlay());
        this.entity.flex().relative((GuiElement)this).y(12).w(0.5f, -3);
        this.count = new GuiTrackpadElement(mc, value -> {
            ((KillObjective)this.objective).count = value.intValue();
        });
        this.count.integer().limit(0.0).setValue((double)objective.count);
        this.count.flex().relative((GuiElement)this).x(1.0f).y(12).w(0.5f, -2).anchorX(1.0f);
        this.tag = new GuiTextElement(mc, 10000, this::parseTag);
        this.tag.flex().relative((GuiElement)this).y(49).w(1.0f);
        this.tag.setText(objective.tag == null ? "" : objective.tag.toString());
        this.message.flex().relative((GuiElement)this).y(1.0f).w(1.0f).anchorY(1.0f);
        this.flex().h(106);
        this.add(new IGuiElement[]{this.message, this.entity, this.count, this.tag});
    }

    private void parseTag(String tag) {
        NBTTagCompound nbt = null;
        try {
            nbt = JsonToNBT.func_180713_a((String)tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((KillObjective)this.objective).tag = nbt;
    }

    private void openPickEntityOverlay() {
        GuiResourceLocationOverlayPanel overlay = new GuiEntityOverlayPanel(this.mc, this::setEntity).set(((KillObjective)this.objective).entity);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay, 0.5f, 0.6f);
    }

    private void setEntity(ResourceLocation location) {
        ((KillObjective)this.objective).entity = location == null ? new ResourceLocation("") : location;
    }

    @Override
    public IKey getMessageTooltip() {
        return IKey.lang((String)"mappet.gui.quests.objective_kill.message_tooltip");
    }

    @Override
    public void draw(GuiContext context) {
        super.draw(context);
        this.font.func_175063_a(I18n.func_135052_a((String)"mappet.gui.quests.objective_kill.entity", (Object[])new Object[0]), (float)this.entity.area.x, (float)(this.entity.area.y - 12), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"mappet.gui.quests.objective_kill.count", (Object[])new Object[0]), (float)this.count.area.x, (float)(this.count.area.y - 12), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"mappet.gui.quests.objective_kill.nbt", (Object[])new Object[0]), (float)this.tag.area.x, (float)(this.tag.area.y - 12), 0xFFFFFF);
    }
}

