/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.client.gui.regions.GuiRegionEditor;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.blocks.PacketEditRegion;
import mchorse.mappet.tile.TileRegion;
import mchorse.mappet.utils.ReflectionUtils;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class GuiRegionPanel
extends GuiDashboardPanel<GuiMappetDashboard> {
    public static final IKey EMPTY = IKey.lang((String)"mappet.gui.region.info.empty");
    public GuiIconElement toggleSidebar;
    public GuiElement sidebar;
    public GuiTileRegionListElement tiles;
    public GuiScrollElement editor;
    public GuiRegionEditor region;
    protected TileRegion tile;
    protected boolean wasOpened;

    public GuiRegionPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, (GuiAbstractDashboard)dashboard);
        this.sidebar = new GuiElement(mc);
        this.sidebar.flex().relative((GuiElement)this).x(1.0f).w(200).h(1.0f).anchorX(1.0f);
        this.toggleSidebar = new GuiIconElement(mc, Icons.RIGHTLOAD, element -> this.toggleSidebar());
        this.toggleSidebar.flex().relative(this.sidebar).x(-20);
        GuiDrawable drawable = new GuiDrawable(context -> this.font.func_175063_a(I18n.func_135052_a((String)this.getTitle(), (Object[])new Object[0]), (float)this.tiles.area.x, (float)(this.area.y + 10), 0xFFFFFF));
        this.tiles = new GuiTileRegionListElement(mc, list -> this.fill((TileRegion)((Object)((Object)list.get(0))), false));
        this.tiles.flex().relative(this.sidebar).xy(10, 25).w(1.0f, -20).h(1.0f, -35);
        this.sidebar.add(new IGuiElement[]{drawable, this.tiles});
        this.editor = new GuiScrollElement(mc);
        this.editor.markContainer();
        this.editor.flex().relative((GuiElement)this).w(240).h(1.0f).column(5).vertical().stretch().scroll().padding(10);
        this.region = new GuiRegionEditor(mc);
        this.editor.scroll.opposite = true;
        this.editor.add((IGuiElement)this.region);
        this.add(new IGuiElement[]{this.sidebar, this.editor, this.toggleSidebar});
        this.keys().register(IKey.lang((String)"mappet.gui.panels.keys.toggle_sidebar"), 49, () -> this.toggleSidebar.clickItself(GuiBase.getCurrent())).category(GuiMappetDashboardPanel.KEYS_CATEGORY);
        this.fill(null, true);
    }

    private void toggleSidebar() {
        this.sidebar.toggleVisible();
        this.toggleSidebar.both(this.sidebar.isVisible() ? Icons.RIGHTLOAD : Icons.LEFTLOAD);
        if (this.sidebar.isVisible()) {
            this.toggleSidebar.flex().relative(this.sidebar).x(-20);
        } else {
            this.toggleSidebar.flex().relative((GuiElement)this).x(1.0f, -20);
        }
        this.resize();
    }

    public TileRegion getTile() {
        return this.tile;
    }

    public String getTitle() {
        return "mappet.gui.panels.regions";
    }

    public void fill(TileRegion tile, boolean ignoreSave) {
        if (!ignoreSave) {
            this.save();
        }
        if (tile != null && tile.func_145837_r()) {
            tile = null;
        }
        this.tile = tile;
        this.editor.setVisible(tile != null);
        this.tiles.setCurrentScroll((Object)tile);
        if (tile != null) {
            this.region.set(tile.region);
        }
    }

    public void fillTiles(Collection<TileEntity> tiles) {
        this.tiles.clear();
        if (tiles == null) {
            return;
        }
        for (TileEntity tile : tiles) {
            if (!(tile instanceof TileRegion)) continue;
            this.tiles.add((Object)((TileRegion)tile));
        }
        this.tiles.setCurrentScroll((Object)this.tile);
    }

    public boolean needsBackground() {
        return false;
    }

    public void open() {
        super.open();
        this.fillTiles(ReflectionUtils.getGlobalTiles(this.mc.field_71438_f));
    }

    public void appear() {
        super.appear();
        if (this.tile != null && this.tile.func_145837_r()) {
            this.fill(null, true);
        }
        this.wasOpened = true;
    }

    public void close() {
        super.close();
        this.save();
        this.wasOpened = false;
    }

    private void save() {
        if (this.tile != null && !this.tile.func_145837_r() && this.wasOpened) {
            Dispatcher.sendToServer(new PacketEditRegion(this.tile.func_174877_v(), this.tile.region.serializeNBT()));
        }
    }

    public void draw(GuiContext context) {
        if (this.editor.isVisible()) {
            Gui.func_73734_a((int)this.editor.area.x, (int)this.editor.area.y, (int)this.editor.area.mx(), (int)this.editor.area.ey(), (int)-1157627904);
            GuiDraw.drawHorizontalGradientRect((int)this.editor.area.mx(), (int)this.editor.area.y, (int)this.editor.area.x(1.25f), (int)this.editor.area.ey(), (int)-1157627904, (int)0);
        }
        if (this.sidebar.isVisible()) {
            this.sidebar.area.draw(-587202560);
        }
        super.draw(context);
        if (!this.editor.isVisible()) {
            int w = (this.sidebar.isVisible() ? this.sidebar.area.x - this.area.x : this.area.w) / 2;
            int x = this.area.x + w / 2;
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY.get(), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
    }

    public static class GuiTileRegionListElement
    extends GuiListElement<TileRegion> {
        public GuiTileRegionListElement(Minecraft mc, Consumer<List<TileRegion>> callback) {
            super(mc, callback);
        }

        protected String elementToString(TileRegion element) {
            BlockPos pos = element.func_174877_v();
            String first = element.region.shapes.isEmpty() ? "" : I18n.func_135052_a((String)("mappet.gui.shapes." + element.region.shapes.get(0).getType()), (Object[])new Object[0]) + " ";
            return first + "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")";
        }
    }
}

