/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mchorse.mappet.api.utils.logs.LoggerLevel;
import mchorse.mappet.api.utils.logs.MappetLogger;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.utils.GuiLoggingLevelList;
import mchorse.mappet.client.gui.utils.GuiScrollLogsElement;
import mchorse.mappet.client.gui.utils.GuiTextLabeledElement;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.logs.PacketRequestLogs;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiLogPanel
extends GuiDashboardPanel<GuiMappetDashboard> {
    String lastLogTime = LocalDateTime.of(1, 1, 1, 0, 0, 0).format(MappetLogger.dtf);
    List<String> logLines = new ArrayList<String>();
    String search = "";
    GuiScrollLogsElement text;
    GuiLoggingLevelList levelFlags;
    GuiTextLabeledElement searchBar;
    boolean searchIgnoreCase = false;
    boolean searchRegex = false;
    boolean searchOnlyMessage = false;
    GuiToggleElement toggleIgnoreCase;
    GuiToggleElement toggleRegex;
    GuiToggleElement toggleOnlyMessage;
    private static final Pattern replacePattern = Pattern.compile("\\r(?=[^\\[\\n])");

    public GuiLogPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, (GuiAbstractDashboard)dashboard);
        this.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc);
            menu.action(Icons.REFRESH, IKey.lang((String)"mappet.gui.logs.context.update"), this::sendRequestPacket);
            return menu.shadow();
        });
        this.text = new GuiScrollLogsElement(mc);
        this.text.background().flex().relative((GuiElement)this).xy(10, 10).w(0.75f, -10).h(1.0f, -50).column(5).vertical().stretch().scroll().padding(10);
        this.searchBar = new GuiTextLabeledElement(mc, s -> {
            this.search = s;
            this.createTextElements();
        }).label(IKey.lang((String)"mappet.gui.search"));
        this.searchBar.flex().relative((GuiElement)this).anchorY(1.0f).w(0.75f, -10).x(10).h(20).y(1.0f, -10);
        this.searchBar.field.func_146203_f(Integer.MAX_VALUE);
        this.toggleIgnoreCase = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.logs.toggle.ignore_case"), b -> {
            this.searchIgnoreCase = b.isToggled();
            this.createTextElements();
        });
        this.toggleIgnoreCase.flex().relative((GuiElement)this).anchorY(1.0f).anchorX(1.0f).x(1.0f, -20).y(1.0f, -10).w(0.2f, -20).h(20);
        this.toggleRegex = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.logs.toggle.regex"), b -> {
            this.searchRegex = b.isToggled();
            this.toggleIgnoreCase.setEnabled(!b.isToggled());
            this.createTextElements();
        });
        this.toggleRegex.flex().relative((GuiElement)this.toggleIgnoreCase).anchorY(1.0f).anchorX(1.0f).wh(1.0f, 1.0f).y(-1.0f, 10).x(1.0f);
        this.toggleOnlyMessage = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.logs.toggle.onlyMessage"), b -> {
            this.searchOnlyMessage = b.isToggled();
            this.createTextElements();
        });
        this.toggleOnlyMessage.flex().relative((GuiElement)this.toggleRegex).anchorY(1.0f).anchorX(1.0f).wh(1.0f, 1.0f).y(-1.0f, 10).x(1.0f);
        this.levelFlags = new GuiLoggingLevelList(mc, l -> this.createTextElements());
        this.levelFlags.background().flex().relative((GuiElement)this).anchorX(1.0f).x(1.0f, -10).y(10).w(0.2f).h(0.5f, -20).column(10).vertical().stretch().scroll().padding(10);
        this.levelFlags.resize();
        this.add((IGuiElement)this.text);
        this.add((IGuiElement)this.levelFlags);
        this.add((IGuiElement)this.searchBar);
        this.add((IGuiElement)this.toggleIgnoreCase);
        this.add((IGuiElement)this.toggleRegex);
        this.add((IGuiElement)this.toggleOnlyMessage);
        this.resize();
    }

    public void appear() {
        super.appear();
        this.sendRequestPacket();
    }

    public void update(String data) {
        this.fillList(data);
        this.updateLastTime();
        this.createTextElements();
    }

    public void createTextElements() {
        this.text.removeAll();
        for (String line : this.logLines) {
            LoggerLevel level = this.getLineLevel(line);
            if (!this.levelFlags.flags.get((Object)level).booleanValue() || !this.isMatchesSearch(line)) continue;
            this.text.add((IGuiElement)new GuiText(this.mc).text(line).color(level.color, false).context(() -> {
                GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.logs.context.copy"), () -> {
                    int secondCloseBracket = line.indexOf("]", line.indexOf("]") + 1);
                    GuiScreen.func_146275_d((String)line.substring(secondCloseBracket + 2));
                });
                return menu.shadow();
            }));
        }
        this.text.resize();
    }

    public void fillList(String data) {
        String[] lines;
        data = replacePattern.matcher(data).replaceAll("\n");
        for (String line : lines = data.split("\r")) {
            if (line.equals("")) continue;
            this.logLines.add(line);
        }
    }

    public void updateLastTime() {
        String last = this.logLines.get(this.logLines.size() - 1);
        this.lastLogTime = last.substring(1, last.indexOf("]"));
    }

    public boolean isMatchesSearch(String line) {
        if (this.searchOnlyMessage) {
            int secondIndex = line.indexOf(93, line.indexOf(93) + 1);
            line = line.substring(secondIndex + 1);
        }
        if (this.searchRegex) {
            try {
                Pattern searchPattern = Pattern.compile(this.search);
                return searchPattern.matcher(line).find();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.searchIgnoreCase) {
            return line.toLowerCase().contains(this.search.toLowerCase());
        }
        return line.contains(this.search);
    }

    public LoggerLevel getLineLevel(String line) {
        int secondOpenBracket = line.indexOf(91, line.indexOf(91) + 1);
        int secondClosedBracket = line.indexOf(93, secondOpenBracket);
        LoggerLevel level = null;
        if (secondClosedBracket != -1) {
            level = LoggerLevel.valueOf(line.substring(secondOpenBracket + 1, secondClosedBracket));
        }
        return level;
    }

    public void sendRequestPacket() {
        Dispatcher.sendToServer(new PacketRequestLogs().setLastDate(this.lastLogTime));
    }
}

