/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.util.ArrayList;
import java.util.function.Consumer;
import mchorse.mappet.api.factions.Faction;
import mchorse.mappet.api.factions.FactionAttitude;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.conditions.GuiCheckerElement;
import mchorse.mappet.client.gui.factions.GuiFactionRelationOverlayPanel;
import mchorse.mappet.client.gui.factions.GuiFactions;
import mchorse.mappet.client.gui.factions.GuiFactionsOverlayPanel;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiFactionPanel
extends GuiMappetDashboardPanel<Faction> {
    public static final IKey EMPTY = IKey.lang((String)"mappet.gui.factions.info.empty");
    public GuiTextElement title;
    public GuiCheckerElement visible;
    public GuiColorElement color;
    public GuiTrackpadElement score;
    public GuiCirculateElement playerAttitude;
    public GuiCirculateElement othersAttitude;
    public GuiButtonElement openOwnRelation;
    public GuiFactions relations;

    public static GuiCirculateElement createButton(Minecraft mc, Consumer<FactionAttitude> callback) {
        GuiCirculateElement element = new GuiCirculateElement(mc, b -> callback.accept(FactionAttitude.values()[b.getValue()]));
        for (FactionAttitude attitude : FactionAttitude.values()) {
            element.addLabel(IKey.lang((String)("mappet.gui.faction_attitudes." + attitude.name().toLowerCase())));
        }
        return element;
    }

    public static void setValue(GuiCirculateElement element, FactionAttitude attitude) {
        element.setValue(attitude.ordinal());
    }

    public GuiFactionPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
        this.namesList.setFileIcon(Icons.BOOKMARK);
        this.title = new GuiTextElement(mc, 1000, t -> {
            ((Faction)this.data).title = t;
        });
        this.visible = new GuiCheckerElement(mc);
        this.color = new GuiColorElement(mc, c -> {
            ((Faction)this.data).color = c;
        });
        this.score = new GuiTrackpadElement(mc, v -> {
            ((Faction)this.data).score = v.intValue();
        });
        this.score.limit(0.0).integer();
        this.playerAttitude = GuiFactionPanel.createButton(mc, a -> {
            ((Faction)this.data).playerAttitude = a;
        });
        this.othersAttitude = GuiFactionPanel.createButton(mc, a -> {
            ((Faction)this.data).othersAttitude = a;
        });
        this.openOwnRelation = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.factions.relations.open"), b -> this.openRelation());
        this.relations = new GuiFactions(mc);
        GuiElement a2 = new GuiElement(mc);
        a2.flex().column(4).vertical().stretch();
        a2.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.title")), this.title});
        GuiElement b2 = new GuiElement(mc);
        b2.flex().w(140).column(4).vertical().stretch();
        b2.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.color")), this.color});
        GuiElement c2 = new GuiElement(mc);
        c2.flex().column(4).vertical().stretch();
        c2.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.others_attitude")), this.othersAttitude});
        GuiElement d = new GuiElement(mc);
        d.flex().column(4).vertical().stretch();
        d.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.player_attitude")), this.playerAttitude});
        GuiLabel label = Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.relations.label")).background();
        GuiIconElement add = new GuiIconElement(mc, Icons.ADD, button -> {
            ArrayList<String> keys = new ArrayList<String>(this.names.list.getList());
            keys.removeIf(key -> ((Faction)this.data).relations.containsKey(key));
            keys.remove(((Faction)this.data).getId());
            if (!keys.isEmpty()) {
                GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)new GuiFactionsOverlayPanel(this.mc, keys, this::addRelation), 200, 140);
            }
        });
        add.flex().relative((GuiElement)label).xy(1.0f, 0.5f).w(10).anchor(1.0f, 0.5f);
        label.add((IGuiElement)add);
        GuiScrollElement scrollEditor = this.createScrollEditor();
        scrollEditor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{a2, b2}));
        scrollEditor.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.visible")).marginTop(12), this.visible});
        scrollEditor.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.factions.score")).marginTop(12), this.score});
        scrollEditor.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{c2, d}).marginTop(12));
        scrollEditor.add(new IGuiElement[]{label.marginTop(12), this.relations});
        scrollEditor.add((IGuiElement)this.openOwnRelation);
        this.editor.add((IGuiElement)scrollEditor);
        this.fill(null);
    }

    private void addRelation(String string) {
        this.relations.addRelation(string, FactionAttitude.PASSIVE, true);
    }

    private void openRelation() {
        GuiFactionRelationOverlayPanel overlay = new GuiFactionRelationOverlayPanel(this.mc, ((Faction)this.data).ownRelation);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay, 0.5f, 0.7f);
    }

    @Override
    public ContentType getType() {
        return ContentType.FACTION;
    }

    @Override
    public String getTitle() {
        return "mappet.gui.panels.factions";
    }

    @Override
    public void fill(Faction data, boolean allowed) {
        super.fill(data, allowed);
        this.editor.setVisible(data != null);
        if (data != null) {
            this.title.setText(data.title);
            this.visible.set(data.visible);
            this.color.picker.setColor(data.color);
            this.score.setValue((double)data.score);
            GuiFactionPanel.setValue(this.playerAttitude, data.playerAttitude);
            GuiFactionPanel.setValue(this.othersAttitude, data.othersAttitude);
            this.relations.set(data.relations);
        }
        this.resize();
    }

    @Override
    public void draw(GuiContext context) {
        super.draw(context);
        if (!this.editor.isVisible()) {
            int w = this.editor.area.w / 2;
            int x = this.editor.area.mx() - w / 2;
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY.get(), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
    }
}

