/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.conditionModel.GuiConditionModelBasicSettingsElement;
import mchorse.mappet.client.gui.conditionModel.GuiConditionModelElement;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.blocks.PacketEditConditionModel;
import mchorse.mappet.tile.TileConditionModel;
import mchorse.mappet.utils.ConditionModel;
import mchorse.mappet.utils.ReflectionUtils;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class GuiConditionModelPanel
extends GuiDashboardPanel<GuiMappetDashboard> {
    public static final IKey EMPTY = IKey.lang((String)"mappet.gui.conditionModel.info.empty");
    public GuiIconElement toggleSidebar;
    public GuiElement sidebar;
    public GuiTileConditionModelListElement tiles;
    public GuiScrollElement editor;
    public GuiConditionModelBasicSettingsElement basicSettings;
    protected TileConditionModel tile;
    protected boolean wasOpened;
    public GuiModelBlockTransformations trans;
    public GuiConditionModelElementsListElement conditionModelList;
    public GuiConditionModelElement conditionModelElement;

    public GuiConditionModelPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, (GuiAbstractDashboard)dashboard);
        this.sidebar = new GuiElement(mc);
        this.sidebar.flex().relative((GuiElement)this).x(1.0f).w(200).h(1.0f).anchorX(1.0f);
        this.toggleSidebar = new GuiIconElement(mc, Icons.RIGHTLOAD, element -> this.toggleSidebar());
        this.toggleSidebar.flex().relative(this.sidebar).x(-20);
        GuiDrawable drawable = new GuiDrawable(context -> this.font.func_175063_a(I18n.func_135052_a((String)this.getTitle(), (Object[])new Object[0]), (float)this.tiles.area.x, (float)(this.area.y + 10), 0xFFFFFF));
        this.tiles = new GuiTileConditionModelListElement(mc, list -> this.fill((TileConditionModel)((Object)((Object)list.get(0))), false));
        this.tiles.flex().relative(this.sidebar).xy(10, 25).w(1.0f, -20).h(1.0f, -35);
        this.sidebar.add(new IGuiElement[]{drawable, this.tiles});
        this.editor = new GuiScrollElement(mc);
        this.editor.markContainer();
        this.editor.flex().relative((GuiElement)this).w(240).h(1.0f).column(5).vertical().stretch().scroll().padding(10);
        this.basicSettings = new GuiConditionModelBasicSettingsElement(mc);
        this.editor.scroll.opposite = true;
        this.editor.add((IGuiElement)this.basicSettings);
        this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.conditionModel.list")).marginTop(12));
        GuiElement row = Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{new GuiIconElement(mc, Icons.ADD, b -> {
            ConditionModel model = new ConditionModel();
            this.tile.list.add(model);
            this.fillConditionBlockList(this.tile.list);
            this.conditionModelElement.set(model);
            this.conditionModelList.setCurrent(model);
        }).tooltip(IKey.lang((String)"mappet.gui.conditionModel.add")), new GuiIconElement(mc, Icons.REMOVE, b -> {
            this.tile.list.remove(this.conditionModelList.getCurrentFirst());
            this.fillConditionBlockList(this.tile.list);
            this.conditionModelElement.setVisible(false);
        }).tooltip(IKey.lang((String)"mappet.gui.conditionModel.remove")), new GuiIconElement(mc, Icons.MOVE_UP, b -> {
            List<ConditionModel> list = this.tile.list;
            ConditionModel current = (ConditionModel)this.conditionModelList.getCurrentFirst();
            int index = list.indexOf(current);
            if (index - 1 >= 0) {
                Collections.swap(list, index, index - 1);
            }
            this.fillConditionBlockList(this.tile.list);
            this.conditionModelList.setCurrent(current);
        }).tooltip(IKey.lang((String)"mappet.gui.conditionModel.move_up")), new GuiIconElement(mc, Icons.MOVE_DOWN, b -> {
            List<ConditionModel> list = this.tile.list;
            ConditionModel current = (ConditionModel)this.conditionModelList.getCurrentFirst();
            int index = list.indexOf(current);
            if (index + 1 < list.size()) {
                Collections.swap(list, index, index + 1);
            }
            this.fillConditionBlockList(list);
            this.conditionModelList.setCurrent(current);
        }).tooltip(IKey.lang((String)"mappet.gui.conditionModel.move_down"))});
        row.flex().row(5).width(50);
        this.editor.add((IGuiElement)row);
        this.conditionModelList = new GuiConditionModelElementsListElement(mc, list -> this.setBasicSettings((ConditionModel)list.get(0)));
        this.conditionModelList.flex().relative((GuiElement)this).h(350);
        this.editor.add((IGuiElement)this.conditionModelList);
        this.conditionModelElement = new GuiConditionModelElement(mc);
        this.conditionModelElement.flex().relative((GuiElement)this).anchorY(0.5f).anchorX(0.5f).x(0.5f).y(0.5f, -30).wh(290, 290);
        this.add((IGuiElement)this.conditionModelElement);
        this.trans = new GuiModelBlockTransformations(mc);
        this.trans.flex().relative((GuiElement)this).x(0.5f, -32).y(1.0f, -10).wh(250, 70).anchor(0.5f, 1.0f);
        this.trans.model = this.tile;
        this.trans.set(this.tile);
        this.add(new IGuiElement[]{this.sidebar, this.editor, this.toggleSidebar, this.trans});
        this.keys().register(IKey.lang((String)"mappet.gui.panels.keys.toggle_sidebar"), 49, () -> this.toggleSidebar.clickItself(GuiBase.getCurrent())).category(GuiMappetDashboardPanel.KEYS_CATEGORY);
        this.fill(null, true);
    }

    private void toggleSidebar() {
        this.sidebar.toggleVisible();
        this.toggleSidebar.both(this.sidebar.isVisible() ? Icons.RIGHTLOAD : Icons.LEFTLOAD);
        if (this.sidebar.isVisible()) {
            this.toggleSidebar.flex().relative(this.sidebar).x(-20);
        } else {
            this.toggleSidebar.flex().relative((GuiElement)this).x(1.0f, -20);
        }
        this.resize();
    }

    public TileConditionModel getTile() {
        return this.tile;
    }

    public String getTitle() {
        return "mappet.gui.panels.condition_models";
    }

    public boolean isOpened() {
        return this.wasOpened;
    }

    public boolean isSelected(TileConditionModel tileEntityModel) {
        return this.tile == tileEntityModel;
    }

    public void setBasicSettings(ConditionModel conditionModel) {
        if (conditionModel != null && !conditionModel.equals(this.conditionModelElement.conditionModel)) {
            this.conditionModelElement.set(conditionModel);
        }
        this.conditionModelElement.setVisible(conditionModel != null);
    }

    public void fill(TileConditionModel tile, boolean ignoreSave) {
        if (!ignoreSave) {
            this.save();
        }
        if (tile != null && tile.func_145837_r()) {
            tile = null;
        }
        this.tile = tile;
        this.editor.setVisible(tile != null);
        this.trans.setVisible(tile != null);
        this.conditionModelElement.setVisible(tile != null && this.conditionModelList.getCurrentFirst() != null);
        this.tiles.setCurrentScroll((Object)tile);
        if (tile != null) {
            this.trans.set(tile);
            this.basicSettings.set(tile);
            this.fillConditionBlockList(tile.list);
        }
    }

    public void fillConditionBlockList(List<ConditionModel> list) {
        this.conditionModelList.clear();
        for (ConditionModel model : list) {
            this.conditionModelList.add(model);
        }
    }

    public void fillTiles(Collection<TileEntity> tiles) {
        this.tiles.clear();
        if (tiles == null) {
            return;
        }
        for (TileEntity tile : tiles) {
            if (!(tile instanceof TileConditionModel)) continue;
            this.tiles.add((Object)((TileConditionModel)tile));
        }
        this.tiles.setCurrentScroll((Object)this.tile);
        this.setBasicSettings(null);
    }

    public boolean needsBackground() {
        return false;
    }

    public void open() {
        super.open();
        this.fillTiles(ReflectionUtils.getGlobalTiles(this.mc.field_71438_f));
    }

    public void appear() {
        super.appear();
        if (this.tile != null && this.tile.func_145837_r()) {
            this.fill(null, true);
        }
        this.wasOpened = true;
    }

    public void close() {
        super.close();
        this.save();
        this.wasOpened = false;
    }

    private void save() {
        if (this.tile != null && !this.tile.func_145837_r() && this.wasOpened) {
            this.tile.func_70296_d();
            Dispatcher.sendToServer(new PacketEditConditionModel(this.tile.func_174877_v(), this.tile.serializeNBT()));
        }
    }

    public void draw(GuiContext context) {
        if (this.editor.isVisible()) {
            Gui.func_73734_a((int)this.editor.area.x, (int)this.editor.area.y, (int)this.editor.area.mx(), (int)this.editor.area.ey(), (int)-1157627904);
            GuiDraw.drawHorizontalGradientRect((int)this.editor.area.mx(), (int)this.editor.area.y, (int)this.editor.area.x(1.25f), (int)this.editor.area.ey(), (int)-1157627904, (int)0);
            Gui.func_73734_a((int)this.conditionModelList.area.x, (int)this.conditionModelList.area.y, (int)this.conditionModelList.area.ex(), (int)this.conditionModelList.area.ey(), (int)-1157627904);
        }
        if (this.conditionModelElement.isVisible()) {
            this.conditionModelElement.area.draw(-587202560);
        }
        if (this.sidebar.isVisible()) {
            this.sidebar.area.draw(-587202560);
        }
        super.draw(context);
        if (!this.editor.isVisible()) {
            int w = (this.sidebar.isVisible() ? this.sidebar.area.x - this.area.x : this.area.w) / 2;
            int x = this.area.x + w / 2;
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY.get(), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
    }

    public static class GuiModelBlockTransformations
    extends GuiTransformations {
        public TileConditionModel model;

        public GuiModelBlockTransformations(Minecraft mc) {
            super(mc);
            this.one.callback = toggle -> {
                boolean one = toggle.isToggled();
                this.model.getSettings().setUniform(one);
                this.updateScaleFields();
                if (!one) {
                    this.sy.setValueAndNotify(this.sx.value);
                    this.sz.setValueAndNotify(this.sx.value);
                }
            };
        }

        public void set(TileConditionModel model) {
            this.model = model;
            if (model != null) {
                this.fillT(model.getSettings().getX(), model.getSettings().getY(), model.getSettings().getZ());
                this.fillS(model.getSettings().getSx(), model.getSettings().getSy(), model.getSettings().getSz());
                this.fillR(model.getSettings().getRx(), model.getSettings().getRy(), model.getSettings().getRz());
                this.one.toggled(model.getSettings().isUniform());
                this.updateScaleFields();
            }
        }

        public void setT(double x, double y, double z) {
            this.model.getSettings().setX((float)x);
            this.model.getSettings().setY((float)y);
            this.model.getSettings().setZ((float)z);
        }

        public void setS(double x, double y, double z) {
            this.model.getSettings().setSx((float)x);
            this.model.getSettings().setSy((float)y);
            this.model.getSettings().setSz((float)z);
        }

        public void setR(double x, double y, double z) {
            this.model.getSettings().setRx((float)x);
            this.model.getSettings().setRy((float)y);
            this.model.getSettings().setRz((float)z);
        }

        protected void localTranslate(double x, double y, double z) {
            this.model.getSettings().addTranslation(x, y, z, GuiTransformations.GuiStaticTransformOrientation.getOrientation());
            this.fillT(this.model.getSettings().getX(), this.model.getSettings().getY(), this.model.getSettings().getZ());
        }

        protected void prepareRotation(Matrix4f mat) {
            MatrixUtils.RotationOrder order = MatrixUtils.RotationOrder.valueOf((String)this.model.getSettings().getOrder().toString());
            float[] rot = new float[]{(float)this.rx.value, (float)this.ry.value, (float)this.rz.value};
            Matrix4f trans = new Matrix4f();
            trans.setIdentity();
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.thirdIndex, (double)rot[order.thirdIndex]));
            mat.mul(trans);
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.secondIndex, (double)rot[order.secondIndex]));
            mat.mul(trans);
            trans.set(MatrixUtils.Transformation.getRotationMatrix((int)order.firstIndex, (double)rot[order.firstIndex]));
            mat.mul(trans);
        }

        protected void postRotation(MatrixUtils.Transformation transform) {
            Vector3f result = transform.getRotation(MatrixUtils.RotationOrder.valueOf((String)this.model.getSettings().getOrder().toString()), new Vector3f((float)this.rx.value, (float)this.ry.value, (float)this.rz.value));
            this.rx.setValueAndNotify((double)result.x);
            this.ry.setValueAndNotify((double)result.y);
            this.rz.setValueAndNotify((double)result.z);
        }
    }

    public static class GuiConditionModelElementsListElement
    extends GuiListElement<ConditionModel> {
        public GuiConditionModelElementsListElement(Minecraft mc, Consumer<List<ConditionModel>> callback) {
            super(mc, callback);
        }

        protected String elementToString(ConditionModel element) {
            String string;
            Checker checker = element.checker;
            if (checker.isEmpty()) {
                return "-";
            }
            if (checker.mode == Checker.Mode.CONDITION) {
                int size = checker.condition.blocks.size();
                string = checker.condition.blocks.get(0).stringify() + (size > 1 ? " (" + (size - 1) + "+)" : "");
            } else {
                string = checker.expression;
            }
            return string;
        }
    }

    public static class GuiTileConditionModelListElement
    extends GuiListElement<TileConditionModel> {
        public GuiTileConditionModelListElement(Minecraft mc, Consumer<List<TileConditionModel>> callback) {
            super(mc, callback);
        }

        protected String elementToString(TileConditionModel element) {
            BlockPos pos = element.func_174877_v();
            String first = "(" + element.list.size() + ") ";
            return first + "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")";
        }
    }
}

