/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.utils.factory.IFactory;
import mchorse.mappet.api.utils.nodes.Node;
import mchorse.mappet.api.utils.nodes.NodeRelation;
import mchorse.mappet.api.utils.nodes.NodeSystem;
import mchorse.mappet.api.utils.nodes.NodeUtils;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiCanvas;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.lwjgl.input.Keyboard;

public class GuiNodeGraph<T extends Node>
extends GuiCanvas {
    public static final IKey KEYS_CATEGORY = IKey.lang((String)"mappet.gui.nodes.keys.editor");
    public static final IKey ADD_CATEGORY = IKey.lang((String)"mappet.gui.nodes.keys.add");
    public NodeSystem<T> system;
    private List<T> selected = new ArrayList<T>();
    private boolean lastSelected;
    private boolean selecting;
    private int lastNodeX;
    private int lastNodeY;
    private T output;
    private T input;
    private Color a = new Color();
    private Color b = new Color();
    private boolean notifyAboutMain;
    private long tick;
    private int average;
    private int prevAverage;
    private Consumer<T> callback;

    public GuiNodeGraph(Minecraft mc, IFactory<T> factory, Consumer<T> callback) {
        super(mc);
        this.callback = callback;
        this.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
            int x = (int)this.fromX(GuiBase.getCurrent().mouseX);
            int y = (int)this.fromY(GuiBase.getCurrent().mouseY);
            menu.action(Icons.ADD, IKey.lang((String)"mappet.gui.nodes.context.add"), () -> {
                GuiSimpleContextMenu adds = new GuiSimpleContextMenu(this.mc);
                for (String key : this.system.getFactory().getKeys()) {
                    IKey label = IKey.format((String)"mappet.gui.nodes.context.add_node", (Object[])new Object[]{IKey.lang((String)("mappet.gui.node_types." + key))});
                    int color = this.system.getFactory().getColor(key);
                    adds.action(Icons.ADD, label, () -> this.addNode(key, x, y), color);
                }
                GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)adds);
            });
            if (!this.selected.isEmpty()) {
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.nodes.context.copy"), this::copyNodes);
            }
            try {
                this.addPaste(menu, x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.selected.isEmpty()) {
                menu.action(Icons.DOWNLOAD, IKey.lang((String)"mappet.gui.nodes.context.main"), this::markMain);
                menu.action(Icons.REVERSE, IKey.lang((String)"mappet.gui.nodes.context.sort"), this::sortInputs);
                menu.action(Icons.MINIMIZE, IKey.lang((String)"mappet.gui.nodes.context.tie"), this::tieSelected);
                menu.action(Icons.MAXIMIZE, IKey.lang((String)"mappet.gui.nodes.context.untie"), this::untieSelected);
                menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.nodes.context.remove"), this::removeSelected, 0xFF0033);
            }
            return menu;
        });
        this.keys().register(IKey.lang((String)"mappet.gui.nodes.context.tie"), 33, this::tieSelected).inside().category(KEYS_CATEGORY);
        this.keys().register(IKey.lang((String)"mappet.gui.nodes.context.untie"), 22, this::untieSelected).inside().category(KEYS_CATEGORY);
        this.keys().register(IKey.lang((String)"mappet.gui.nodes.context.main"), 50, this::markMain).inside().category(KEYS_CATEGORY);
        this.keys().register(IKey.lang((String)"mappet.gui.nodes.context.sort"), 46, this::sortInputs).inside().category(KEYS_CATEGORY);
        int keycode = 2;
        for (String key : factory.getKeys()) {
            Keybind keybind = this.keys().register(IKey.format((String)"mappet.gui.nodes.context.add_node", (Object[])new Object[]{IKey.lang((String)("mappet.gui.node_types." + key))}), keycode, () -> {
                GuiContext context = GuiBase.getCurrent();
                this.addNode(key, (int)this.fromX(context.mouseX), (int)this.fromY(context.mouseY));
            });
            keybind.inside().held(new int[]{29}).category(ADD_CATEGORY);
            ++keycode;
        }
    }

    public GuiNodeGraph<T> notifyAboutMain() {
        this.notifyAboutMain = true;
        return this;
    }

    private void copyNodes() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        NBTTagCompound relations = new NBTTagCompound();
        for (Node node : this.selected) {
            NBTTagCompound nodeTag = NodeUtils.nodeToNBT(this.system, node);
            list.func_74742_a((NBTBase)nodeTag);
            List<Node> children = this.system.getChildren(node);
            for (Node child : children) {
                NBTTagList relation;
                if (!this.selected.contains(child)) continue;
                String key = node.getId().toString();
                if (relations.func_74764_b(key)) {
                    relation = relations.func_150295_c(key, 8);
                } else {
                    relation = new NBTTagList();
                    relations.func_74782_a(key, (NBTBase)relation);
                }
                relation.func_74742_a((NBTBase)new NBTTagString(child.getId().toString()));
            }
        }
        tag.func_74757_a("_CopyNodes", true);
        tag.func_74782_a("Nodes", (NBTBase)list);
        tag.func_74782_a("Relations", (NBTBase)relations);
        GuiScreen.func_146275_d((String)tag.toString());
    }

    private void addPaste(GuiSimpleContextMenu menu, int x, int y) throws NBTException {
        String json = GuiScreen.func_146277_j();
        NBTTagCompound tag = JsonToNBT.func_180713_a((String)json);
        if (!tag.func_74767_n("_CopyNodes")) {
            return;
        }
        NBTTagList nodesTag = tag.func_150295_c("Nodes", 10);
        NBTTagCompound relationsTag = tag.func_74775_l("Relations");
        ArrayList<T> nodes = new ArrayList<T>();
        HashMap<String, T> mapping = new HashMap<String, T>();
        for (int i = 0; i < nodesTag.func_74745_c(); ++i) {
            NBTTagCompound nodeTag = nodesTag.func_150305_b(i);
            String id = nodeTag.func_74779_i("Id");
            nodeTag.func_82580_o("Id");
            T node = NodeUtils.nodeFromNBT(this.system, nodeTag);
            mapping.put(id, node);
            nodes.add(node);
        }
        int nx = ((Node)nodes.get((int)0)).x;
        int ny = ((Node)nodes.get((int)0)).y;
        menu.action(Icons.PASTE, IKey.lang((String)"mappet.gui.nodes.context.paste"), () -> {
            this.selected.clear();
            for (Node node : nodes) {
                this.system.add(node);
                node.x = node.x - nx + x;
                node.y = node.y - ny + y;
                this.select(node, true);
            }
            for (String key : relationsTag.func_150296_c()) {
                NBTTagList relations = relationsTag.func_150295_c(key, 8);
                Node output = (Node)mapping.get(key);
                for (NBTBase base : relations) {
                    Node input = (Node)mapping.get(((NBTTagString)base).func_150285_a_());
                    if (output == null || input == null) continue;
                    this.system.tie(output, input);
                }
            }
        });
    }

    private void addNode(String key, int x, int y) {
        Node node = (Node)this.system.getFactory().create(key);
        if (node != null) {
            node.x = x;
            node.y = y;
            this.system.add(node);
            this.select(node);
        }
    }

    private void removeSelected() {
        for (Node selected : this.selected) {
            this.system.remove(selected);
        }
        if (this.system.main != null && this.selected.contains(this.system.main)) {
            this.system.main = null;
        }
        this.select(null);
    }

    private void tieSelected() {
        if (this.selected.size() <= 1) {
            return;
        }
        Node last = (Node)this.selected.get(this.selected.size() - 1);
        ArrayList<T> nodes = new ArrayList<T>(this.selected);
        nodes.remove(last);
        nodes.sort(Comparator.comparingInt(a -> a.x));
        for (Node node : nodes) {
            this.system.tie(last, node);
        }
    }

    private void untieSelected() {
        if (this.selected.isEmpty()) {
            return;
        }
        if (this.selected.size() == 1) {
            this.system.relations.remove(((Node)this.selected.get(0)).getId());
        } else if (this.selected.size() == 2) {
            Node a = (Node)this.selected.get(0);
            Node b = (Node)this.selected.get(1);
            this.system.untie(a, b);
            this.system.untie(b, a);
        } else {
            Node last = (Node)this.selected.get(this.selected.size() - 1);
            for (int i = 0; i < this.selected.size() - 1; ++i) {
                this.system.untie(last, (Node)this.selected.get(i));
            }
        }
    }

    private void markMain() {
        if (this.selected.isEmpty()) {
            return;
        }
        this.system.main = (Node)this.selected.get(this.selected.size() - 1);
    }

    private void sortInputs() {
        if (this.selected.size() != 1) {
            return;
        }
        Node node = (Node)this.selected.get(0);
        List relations = this.system.relations.get(node.getId());
        if (relations != null) {
            relations.sort(Comparator.comparingInt(a -> ((Node)a.input).x));
        }
    }

    public void setNode(T node) {
        if (this.callback != null) {
            this.callback.accept(node);
        }
    }

    public void select(T node) {
        this.select(node, false);
    }

    public void select(T node, boolean add) {
        if (!add) {
            this.selected.clear();
        }
        if (node != null) {
            this.selected.add(node);
        }
        this.setNode(node);
    }

    public Area getNodeArea(T node) {
        int x1 = this.toX(((Node)node).x - 60);
        int y1 = this.toY(((Node)node).y - 35);
        int x2 = this.toX(((Node)node).x + 60);
        int y2 = this.toY(((Node)node).y + 35);
        Area.SHARED.setPoints(x1, y1, x2, y2);
        return Area.SHARED;
    }

    public Area getNodeOutletArea(Area nodeArea, boolean output) {
        int y = output ? 7 : -7;
        int x1 = nodeArea.mx() - 4;
        int y1 = nodeArea.y(output ? 1.0f : 0.0f) - 4 + y;
        int x2 = nodeArea.mx() + 4;
        int y2 = nodeArea.y(output ? 1.0f : 0.0f) + 4 + y;
        Area area = new Area();
        area.setPoints(x1, y1, x2, y2);
        return area;
    }

    public boolean isConnecting() {
        return this.output != null || this.input != null;
    }

    public void set(NodeSystem<T> system) {
        boolean same = this.system != null && system != null && this.system.getId().equals(system.getId());
        this.system = system;
        if (system != null && !same) {
            int y;
            int x = system.main == null ? 0 : ((Node)system.main).x;
            int n = y = system.main == null ? 0 : ((Node)system.main).y;
            if (system.main == null && !system.nodes.isEmpty()) {
                for (Node node : system.nodes.values()) {
                    x += node.x;
                    y += node.y;
                }
                x /= system.nodes.size();
                y /= system.nodes.size();
            }
            this.scaleX.setShift((double)x);
            this.scaleY.setShift((double)y);
            this.scaleX.setZoom(0.5);
            this.scaleY.setZoom(0.5);
        }
        if (same) {
            List ids = this.selected.stream().map(Node::getId).collect(Collectors.toList());
            this.selected.clear();
            for (UUID uuid : ids) {
                this.selected.add(this.system.nodes.get(uuid));
            }
            this.setNode(this.selected.isEmpty() ? null : (Node)this.selected.get(this.selected.size() - 1));
        } else {
            this.selected.clear();
        }
    }

    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context) && context.mouseButton == 2) {
            return true;
        }
        if (this.system == null) {
            return false;
        }
        if (context.mouseButton == 0) {
            this.lastNodeX = (int)this.fromX(context.mouseX);
            this.lastNodeY = (int)this.fromY(context.mouseY);
            boolean shift = GuiScreen.func_146272_n();
            ArrayList nodes = new ArrayList(this.system.nodes.values());
            Collections.reverse(nodes);
            for (Node node : nodes) {
                Area nodeArea = this.getNodeArea(node);
                if (nodeArea.isInside(context)) {
                    if (shift) {
                        if (!this.selected.contains(node)) {
                            this.select(node, true);
                        } else {
                            this.selected.remove(node);
                            this.select(node, true);
                        }
                    } else if (!this.selected.contains(node)) {
                        this.select(node);
                    }
                    this.lastSelected = true;
                    return true;
                }
                Area output = this.getNodeOutletArea(nodeArea, true);
                Area input = this.getNodeOutletArea(nodeArea, false);
                if (output.isInside(context)) {
                    this.output = node;
                } else if (input.isInside(context) && this.system.main != node) {
                    this.input = node;
                }
                if (!this.isConnecting()) continue;
                return false;
            }
            if (shift) {
                this.selecting = true;
            } else {
                this.select(null);
            }
        }
        return false;
    }

    protected void startDragging(GuiContext context) {
        if (context.mouseButton == 0 && GuiScreen.func_146271_m()) {
            this.mouse = 2;
        }
        super.startDragging(context);
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        if (this.isConnecting()) {
            boolean output = this.output != null;
            for (Node node : this.system.nodes.values()) {
                Area nodeArea = this.getNodeArea(node);
                Area outlet = this.getNodeOutletArea(nodeArea, !output);
                if (!outlet.isInside(context)) continue;
                if (output) {
                    this.input = node;
                    break;
                }
                this.output = node;
                break;
            }
        }
        if (this.selecting) {
            Area area = new Area();
            boolean wasSelected = !this.selected.isEmpty();
            area.setPoints(this.lastX, this.lastY, context.mouseX, context.mouseY);
            for (Node node : this.system.nodes.values()) {
                Area nodeArea = this.getNodeArea(node);
                if (!nodeArea.intersects(area) || this.selected.contains(node)) continue;
                this.selected.add(0, node);
            }
            if (!wasSelected && !this.selected.isEmpty()) {
                this.setNode((Node)this.selected.get(this.selected.size() - 1));
            }
        } else if (this.output != null && this.input != null && this.input != this.output) {
            this.system.tie(this.output, this.input);
        }
        this.lastSelected = false;
        this.selecting = false;
        this.input = null;
        this.output = null;
    }

    protected void dragging(GuiContext context) {
        super.dragging(context);
        if (this.dragging && this.mouse == 0 && this.lastSelected && !this.selected.isEmpty()) {
            int lastNodeX = (int)this.fromX(context.mouseX);
            int lastNodeY = (int)this.fromY(context.mouseY);
            for (Node node : this.selected) {
                node.x += lastNodeX - this.lastNodeX;
                node.y += lastNodeY - this.lastNodeY;
            }
            this.lastNodeX = lastNodeX;
            this.lastNodeY = lastNodeY;
        }
    }

    public void draw(GuiContext context) {
        if (this.area.isInside(context) && !context.isFocused()) {
            float y;
            float x;
            float steps = this.prevAverage <= 0 ? 1.0f : (float)this.prevAverage;
            float step = 15.0f / steps;
            float f = Keyboard.isKeyDown((int)203) ? -step : (x = Keyboard.isKeyDown((int)205) ? step : 0.0f);
            float f2 = Keyboard.isKeyDown((int)200) ? -step : (y = Keyboard.isKeyDown((int)208) ? step : 0.0f);
            if (x != 0.0f) {
                this.scaleX.setShift((double)x / this.scaleX.getZoom() + this.scaleX.getShift());
            }
            if (y != 0.0f) {
                this.scaleY.setShift((double)y / this.scaleY.getZoom() + this.scaleY.getShift());
            }
            ++this.average;
            if (this.tick < context.tick) {
                this.tick = context.tick;
                this.prevAverage = this.average;
                this.average = 0;
            }
        }
        super.draw(context);
        if (this.system.nodes.isEmpty()) {
            int w = this.area.w / 2;
            GlStateManager.func_179098_w();
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)I18n.func_135052_a((String)"mappet.gui.nodes.info.empty_nodes", (Object[])new Object[0]), (int)this.area.mx(w), (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        } else if (this.notifyAboutMain && this.system.main == null) {
            String label = I18n.func_135052_a((String)"mappet.gui.nodes.info.empty_main", (Object[])new Object[0]);
            int w = this.font.func_78256_a(label);
            Gui.func_73734_a((int)(this.area.x + 4), (int)(this.area.y + 4), (int)(this.area.x + 24 + w), (int)(this.area.y + 20), (int)-2013265920);
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.1f, (float)1.0f);
            Icons.EXCLAMATION.render(this.area.x + 4, this.area.y + 4);
            this.font.func_175063_a(label, (float)(this.area.x + 20), (float)(this.area.y + 8), 0xFF0010);
        }
    }

    protected void drawCanvas(GuiContext context) {
        Area nodeArea;
        super.drawCanvas(context);
        if (this.system == null) {
            return;
        }
        int thickness = (Integer)Mappet.nodeThickness.get();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)thickness);
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        Node lastSelected = this.selected.isEmpty() ? null : (Node)this.selected.get(this.selected.size() - 1);
        ArrayList<Vector2d> positions = new ArrayList<Vector2d>();
        if (thickness > 0) {
            builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            this.renderConnections(context, builder, positions, lastSelected);
            Tessellator.func_178181_a().func_78381_a();
        }
        Area main = null;
        for (Node node : this.system.nodes.values()) {
            nodeArea = this.getNodeArea(node);
            if (nodeArea.w > 25) {
                this.renderOutlets(context, node, nodeArea);
            }
            boolean hover = Area.SHARED.isInside(context);
            int index = this.selected.indexOf(node);
            int colorBg = hover ? -16250872 : -16777216;
            int colorFg = -1442840576 + this.system.getFactory().getColor(node);
            if (index >= 0) {
                int colorSh = index == this.selected.size() - 1 ? 35071 : 8874;
                GuiDraw.drawDropShadow((int)(nodeArea.x + 4), (int)(nodeArea.y + 4), (int)(nodeArea.ex() - 4), (int)(nodeArea.ey() - 4), (int)8, (int)(-16777216 + colorSh), (int)colorSh);
            }
            Gui.func_73734_a((int)(nodeArea.x + 1), (int)nodeArea.y, (int)(nodeArea.ex() - 1), (int)nodeArea.ey(), (int)colorBg);
            Gui.func_73734_a((int)nodeArea.x, (int)(nodeArea.y + 1), (int)nodeArea.ex(), (int)(nodeArea.ey() - 1), (int)colorBg);
            GuiDraw.drawOutline((int)(nodeArea.x + 3), (int)(nodeArea.y + 3), (int)(nodeArea.ex() - 3), (int)(nodeArea.ey() - 3), (int)colorFg);
            if (node != this.system.main) continue;
            main = new Area();
            main.copy(nodeArea);
        }
        for (Node node : this.system.nodes.values()) {
            nodeArea = this.getNodeArea(node);
            String title = node.getTitle();
            if (title.isEmpty() || nodeArea.w <= 40) continue;
            if (title.length() > 37) {
                title = title.substring(0, 37) + "\u00a7r...";
            }
            GuiDraw.drawTextBackground((FontRenderer)this.font, (String)title, (int)(nodeArea.mx() - this.font.func_78256_a(title) / 2), (int)(nodeArea.my() - 4), (int)0xFFFFFF, (int)-2013265920);
        }
        for (int i = 0; i < positions.size(); ++i) {
            Vector2d pos = (Vector2d)positions.get(i);
            String label = String.valueOf(i);
            this.font.func_175063_a(label, (float)((int)pos.x - this.font.func_78256_a(label) / 2), (float)((int)pos.y - 4), this.getIndexLabelColor(lastSelected, i));
        }
        if (main != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.drawOutlinedIcon((Icon)Icons.DOWNLOAD, (int)main.mx(), (int)(main.y - 4), (int)-1, (float)0.5f, (float)1.0f);
        }
        GlStateManager.func_187441_d((float)1.0f);
        if (this.selecting) {
            Gui.func_73734_a((int)this.lastX, (int)this.lastY, (int)context.mouseX, (int)context.mouseY, (int)1140885759);
        }
    }

    private void renderOutlets(GuiContext context, T node, Area nodeArea) {
        Area output = this.getNodeOutletArea(nodeArea, true);
        Area input = this.getNodeOutletArea(nodeArea, false);
        boolean insideO = output.isInside(context);
        boolean insideI = input.isInside(context);
        int colorO = ColorUtils.multiplyColor((int)0xFFFFFF, (float)(insideO ? 1.0f : 0.6f));
        int colorI = ColorUtils.multiplyColor((int)0xFFFFFF, (float)(insideI ? 1.0f : 0.6f));
        if (this.output == node) {
            colorO = 35071;
            if (insideI) {
                colorI = 0xFF0033;
            }
        } else if (this.output != null) {
            if (insideO) {
                colorO = 0xFF0033;
            } else if (insideI) {
                colorI = 65348;
            }
        }
        if (this.input == node) {
            colorI = 35071;
            if (insideO) {
                colorO = 0xFF0033;
            }
        } else if (this.input != null) {
            if (insideI) {
                colorI = 0xFF0033;
            } else if (insideO) {
                colorO = 65348;
            }
        }
        GuiDraw.drawOutline((int)output.x, (int)output.y, (int)output.ex(), (int)output.ey(), (int)(-16777216 + colorO));
        if (this.system.main != node) {
            GuiDraw.drawOutline((int)input.x, (int)input.y, (int)input.ex(), (int)input.ey(), (int)(-16777216 + colorI));
        }
    }

    private void renderConnections(GuiContext context, BufferBuilder builder, List<Vector2d> positions, T lastSelected) {
        for (List relations : this.system.relations.values()) {
            for (int r = 0; r < relations.size(); ++r) {
                NodeRelation relation = relations.get(r);
                Area output = this.getNodeOutletArea(this.getNodeArea(relation.output), true);
                Area input = this.getNodeOutletArea(this.getNodeArea(relation.input), false);
                int x1 = input.mx();
                int y1 = input.my();
                int x2 = output.mx();
                int y2 = output.my();
                this.drawConnection(builder, context, relation.output, r, x1, y1, x2, y2, false);
                if (relation.output != lastSelected) continue;
                positions.add(new Vector2d((double)((float)(x1 + x2) / 2.0f), (double)((float)(y1 + y2) / 2.0f)));
            }
        }
        if (this.isConnecting()) {
            T node = this.output == null ? this.input : this.output;
            Area area = this.getNodeArea(node);
            Area outlet = this.getNodeOutletArea(area, node == this.output);
            int x1 = context.mouseX;
            int y1 = context.mouseY;
            int x2 = outlet.mx();
            int y2 = outlet.my();
            List list = this.system.relations.get(((Node)node).getId());
            this.drawConnection(builder, context, node, list == null ? 0 : list.size(), x1, y1, x2, y2, true);
        }
    }

    private void drawConnection(BufferBuilder builder, GuiContext context, T node, int r, int x1, int y1, int x2, int y2, boolean forceLine) {
        float factor = ((float)context.tick + context.partialTicks) / 60.0f;
        float segments = 8.0f;
        float opacity = this.getNodeActiveColorOpacity(node, r);
        int c1 = (Boolean)Mappet.nodePulseBackgroundMcLibPrimary.get() != false ? ((Integer)McLib.primaryColor.get()).intValue() : ((Integer)Mappet.nodePulseBackgroundColor.get()).intValue();
        int c2 = this.getNodeActiveColor(node, r);
        int i = 0;
        while ((float)i < 8.0f) {
            float factor1 = (float)i / 8.0f;
            float factor2 = (float)(i + 1) / 8.0f;
            float color1 = 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor1 - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f);
            float color2 = 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor2 - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f);
            color1 = Math.max(color1, 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor1 + 1.0f - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f));
            color2 = Math.max(color2, 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor2 + 1.0f - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f));
            color1 = Math.max(color1, 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor1 - 1.0f - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f));
            color2 = Math.max(color2, 1.0f - MathUtils.clamp((float)(Math.abs(1.0f - factor2 - 1.0f - factor % 1.0f) / 0.2f), (float)0.0f, (float)1.0f));
            ColorUtils.interpolate((Color)this.a, (int)c1, (int)c2, (float)color1, (boolean)false);
            ColorUtils.interpolate((Color)this.b, (int)c1, (int)c2, (float)color2, (boolean)false);
            this.a.a = opacity;
            this.b.a = opacity;
            if (y2 <= y1 || forceLine) {
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)factor1), (double)Interpolations.lerp((float)y1, (float)y2, (float)factor1), 0.0).func_181666_a(this.a.r, this.a.g, this.a.b, this.a.a).func_181675_d();
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)factor2), (double)Interpolations.lerp((float)y1, (float)y2, (float)factor2), 0.0).func_181666_a(this.b.r, this.b.g, this.b.b, this.b.a).func_181675_d();
            } else if ((float)i == 4.0f) {
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)0.5f), (double)y1, 0.0).func_181666_a(this.a.r, this.a.g, this.a.b, this.a.a).func_181675_d();
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)0.5f), (double)y2, 0.0).func_181666_a(this.b.r, this.b.g, this.b.b, this.b.a).func_181675_d();
            } else {
                int y = (float)i < 4.0f ? y1 : y2;
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)((float)i == 5.0f ? 0.5f : factor1)), (double)y, 0.0).func_181666_a(this.a.r, this.a.g, this.a.b, this.a.a).func_181675_d();
                builder.func_181662_b((double)Interpolations.lerp((float)x1, (float)x2, (float)((float)i == 3.0f ? 0.5f : factor2)), (double)y, 0.0).func_181666_a(this.b.r, this.b.g, this.b.b, this.b.a).func_181675_d();
            }
            ++i;
        }
    }

    protected int getIndexLabelColor(T lastSelected, int i) {
        return 0xFFFFFF;
    }

    protected int getNodeActiveColor(T output, int r) {
        return 35071;
    }

    protected float getNodeActiveColorOpacity(T output, int r) {
        return 0.75f;
    }
}

