/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.huds;

import java.util.function.Consumer;
import mchorse.mappet.api.huds.HUDMorph;
import mchorse.mappet.api.huds.HUDScene;
import mchorse.mappet.client.gui.huds.GuiHUDMorphListElement;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class GuiHUDMorphsOverlayPanel
extends GuiOverlayPanel {
    public GuiHUDMorphListElement morphs;
    private HUDScene scene;
    private Consumer<HUDMorph> callback;

    public GuiHUDMorphsOverlayPanel(Minecraft mc, HUDScene scene, Consumer<HUDMorph> callback) {
        super(mc, IKey.lang((String)"mappet.gui.huds.overlay.title"));
        this.scene = scene;
        this.callback = callback;
        this.morphs = new GuiHUDMorphListElement(mc, list -> this.accept((HUDMorph)list.get(0)));
        this.morphs.sorting().context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc);
            menu.action(Icons.ADD, IKey.lang((String)"mappet.gui.huds.context.add"), this::addMorph);
            if (!this.morphs.isDeselected()) {
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.huds.context.copy"), this::copyMorph);
                try {
                    NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
                    if (tag.func_74764_b("_HUDMorphCopy")) {
                        HUDMorph morph = new HUDMorph();
                        morph.deserializeNBT(tag);
                        menu.action(Icons.PASTE, IKey.lang((String)"mappet.gui.huds.context.paste"), () -> this.addMorph(morph));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.huds.context.remove"), this::removeMorph, 0xFF0033);
            }
            return menu.shadow();
        });
        this.morphs.flex().relative(this.content).wh(1.0f, 1.0f);
        this.morphs.setList(this.scene.morphs);
        this.morphs.scroll.scrollSpeed *= 2;
        this.content.add((IGuiElement)this.morphs);
    }

    private void addMorph() {
        this.addMorph(new HUDMorph());
    }

    private void addMorph(HUDMorph morph) {
        this.scene.morphs.add(morph);
        this.morphs.update();
        this.morphs.setCurrentScroll(morph);
        this.accept(morph);
    }

    private void copyMorph() {
        NBTTagCompound tag = ((HUDMorph)this.morphs.getCurrentFirst()).serializeNBT();
        tag.func_74757_a("_HUDMorphCopy", true);
        GuiScreen.func_146275_d((String)tag.toString());
    }

    private void removeMorph() {
        int index = this.morphs.getIndex();
        this.scene.morphs.remove(this.morphs.getIndex());
        this.morphs.update();
        this.morphs.setIndex(index < 1 ? 0 : index - 1);
        this.accept((HUDMorph)this.morphs.getCurrentFirst());
    }

    public GuiHUDMorphsOverlayPanel set(HUDMorph morph) {
        this.morphs.setCurrentScroll(morph);
        return this;
    }

    protected void accept(HUDMorph morph) {
        if (this.callback != null) {
            this.callback.accept(morph);
        }
    }

    @Override
    public void draw(GuiContext context) {
        super.draw(context);
        if (this.scene.morphs.size() <= 1) {
            GuiMappetUtils.drawRightClickHere(context, this.area);
        }
    }
}

