/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.crafting;

import mchorse.mappet.api.crafting.CraftingRecipe;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.client.gui.crafting.GuiCraftingRecipes;
import mchorse.mappet.client.gui.crafting.ICraftingScreen;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.crafting.PacketCraft;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;

public class GuiCrafting
extends GuiElement
implements ICraftingScreen {
    public static final IKey CRAFT_LABEL = IKey.lang((String)"mappet.gui.crafting.craft");
    public GuiCraftingRecipes recipes;
    public GuiButtonElement craft;
    private CraftingTable table;

    public GuiCrafting(Minecraft mc) {
        super(mc);
        this.craft = new GuiButtonElement(mc, CRAFT_LABEL, this::craft);
        this.craft.flex().relative((IResizer)this.area).x(1.0f, -10).y(1.0f, -10).wh(80, 20).anchor(1.0f, 1.0f);
        this.recipes = new GuiCraftingRecipes(mc, element -> this.pickRecipe(element.getRecipe()));
        this.recipes.flex().relative((IResizer)this.area).x(10).y(10).w(1.0f, -20).hTo((IResizer)this.craft.area, -5);
        this.add(new IGuiElement[]{this.craft, this.recipes});
    }

    public CraftingTable get() {
        return this.table;
    }

    public void set(CraftingTable table) {
        this.table = table;
        this.craft.label = table.action.trim().isEmpty() ? CRAFT_LABEL : IKey.str((String)TextUtils.processColoredText((String)table.action));
        this.recipes.setTable(this.table);
        this.pickRecipe(this.table.recipes.get(0));
        this.recipes.setRecipe(this.table.recipes.get(0));
        this.keys().keybinds.clear();
        for (CraftingRecipe recipe : this.table.recipes) {
            if (recipe.hotkey <= 0) continue;
            this.keys().register(IKey.format((String)"mappet.gui.crafting.keys.craft", (Object[])new Object[]{recipe.title}), recipe.hotkey, () -> {
                this.pickRecipe(recipe);
                this.recipes.setRecipe(recipe);
                this.craft(this.craft);
            });
        }
    }

    @Override
    public void refresh() {
        this.pickRecipe(this.recipes.getCurrent().getRecipe());
    }

    private void craft(GuiButtonElement button) {
        Dispatcher.sendToServer(new PacketCraft(this.recipes.getChildren().indexOf((Object)this.recipes.getCurrent())));
    }

    private void pickRecipe(CraftingRecipe recipe) {
        this.craft.setEnabled(recipe.isPlayerHasAllItems((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public void draw(GuiContext context) {
        super.draw(context);
        if (this.mc.field_71439_g.func_184812_l_() && this.table != null) {
            int w = this.font.func_78256_a(this.table.getId());
            GuiDraw.drawTextBackground((FontRenderer)this.font, (String)this.table.getId(), (int)this.area.mx(w), (int)this.craft.area.my(this.font.field_78288_b - 2), (int)0xFFFFFF, (int)-2013265920);
        }
    }
}

