/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.api.huds.HUDStage;
import mchorse.mappet.client.gui.GuiQuestTracker;
import mchorse.mappet.client.morphs.WorldMorph;
import mchorse.mclib.events.RenderOverlayEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderingHandler {
    public static HUDStage stage = new HUDStage(false);
    public static HUDStage currentStage;
    public static List<WorldMorph> worldMorphs;

    public static void update() {
        HUDStage stage = currentStage == null ? RenderingHandler.stage : currentStage;
        stage.update(stage == RenderingHandler.stage);
        worldMorphs.removeIf(WorldMorph::update);
    }

    public static void reset() {
        stage.reset();
        currentStage = null;
        worldMorphs.clear();
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            GuiQuestTracker.renderQuests(event.getResolution(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onRenderGuiOverlay(RenderOverlayEvent.Pre event) {
        HUDStage stage = currentStage != null ? currentStage : RenderingHandler.stage;
        stage.render(event.resolution, event.mc.func_184121_ak());
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        for (WorldMorph morph : worldMorphs) {
            morph.render(event.getPartialTicks());
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    static {
        worldMorphs = new ArrayList<WorldMorph>();
    }
}

