/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.misc.hotkeys.TriggerHotkey;
import mchorse.mappet.api.scripts.Script;
import mchorse.mappet.client.gui.GuiJournalScreen;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.scripts.scriptedItem.GuiScriptedItemScreen;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.events.PacketEventHotkey;
import mchorse.mappet.network.common.events.PacketPlayerJournal;
import mchorse.mclib.client.gui.framework.tooltips.styles.TooltipStyle;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class KeyboardHandler {
    public static final Set<TriggerHotkey> hotkeys = new HashSet<TriggerHotkey>();
    public static final List<TriggerHotkey> held = new ArrayList<TriggerHotkey>();
    public static boolean clientPlayerJournal;
    public KeyBinding openMappetDashboard;
    public KeyBinding openJournal;
    public KeyBinding runCurrentScript;
    private GuiButton button;
    private KeyBinding openScriptedItem;

    public static void openPlayerJournal() {
        if (clientPlayerJournal) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((GuiScreen)new GuiJournalScreen(mc));
        } else {
            Dispatcher.sendToServer(new PacketPlayerJournal());
        }
    }

    public static void updateHeldKeys() {
        if (held.isEmpty()) {
            return;
        }
        Iterator<TriggerHotkey> it = held.iterator();
        while (it.hasNext()) {
            int keycode = it.next().keycode;
            if (Keyboard.isKeyDown((int)keycode)) continue;
            it.remove();
            Dispatcher.sendToServer(new PacketEventHotkey(keycode, false));
        }
    }

    public KeyboardHandler() {
        String prefix = "mappet.keys.";
        this.openMappetDashboard = new KeyBinding(prefix + "dashboard", 13, prefix + "category");
        this.openJournal = new KeyBinding(prefix + "journal", 36, prefix + "category");
        this.runCurrentScript = new KeyBinding(prefix + "runCurrentScript", 64, prefix + "category");
        this.openScriptedItem = new KeyBinding(prefix + "scripted_item", 207, prefix + "category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.openMappetDashboard);
        ClientRegistry.registerKeyBinding((KeyBinding)this.openJournal);
        ClientRegistry.registerKeyBinding((KeyBinding)this.runCurrentScript);
        ClientRegistry.registerKeyBinding((KeyBinding)this.openScriptedItem);
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        ItemStack stack;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.openMappetDashboard.func_151468_f() && OpHelper.isPlayerOp()) {
            if (((Boolean)Mappet.dashboardOnlyCreative.get()).booleanValue()) {
                if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                    mc.func_147108_a((GuiScreen)GuiMappetDashboard.get(mc));
                }
            } else {
                mc.func_147108_a((GuiScreen)GuiMappetDashboard.get(mc));
            }
        }
        if (this.openJournal.func_151468_f()) {
            KeyboardHandler.openPlayerJournal();
        }
        if (this.runCurrentScript.func_151468_f()) {
            Script script = GuiMappetDashboard.get((Minecraft)mc).script.getData();
            if (script == null) {
                return;
            }
            mc.field_71439_g.func_71165_d("/mp script exec " + mc.field_71439_g.func_70005_c_() + " " + script.getId());
        }
        if (this.openScriptedItem.func_151468_f() && !(stack = mc.field_71439_g.func_184614_ca()).func_77973_b().equals(Items.field_190931_a)) {
            mc.func_147108_a((GuiScreen)new GuiScriptedItemScreen(mc, stack));
        }
        if (Keyboard.getEventKeyState()) {
            this.handleKeys();
        }
    }

    private void handleKeys() {
        int key = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        for (TriggerHotkey hotkey : hotkeys) {
            if (hotkey.keycode != key) continue;
            Dispatcher.sendToServer(new PacketEventHotkey(key, true));
            if (hotkey.toggle) {
                held.add(hotkey);
            }
            return;
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiInventory || event.getGui() instanceof GuiContainerCreative) {
            int x = (Integer)Mappet.journalButtonX.get();
            int y = event.getGui().field_146295_m - 20 - (Integer)Mappet.journalButtonY.get();
            event.getButtonList().add(new GuiJournalButton(-69420, x, y, ""));
        }
    }

    @SubscribeEvent
    public void onGuiAction(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof GuiJournalButton) {
            KeyboardHandler.openPlayerJournal();
        }
    }

    public static class GuiJournalButton
    extends GuiButton {
        private static final ResourceLocation ICON = new ResourceLocation("textures/items/book_writable.png");
        private static IKey TOOLTIP = IKey.lang((String)"mappet.gui.player_journal");
        private Area area = new Area();

        public GuiJournalButton(int buttonId, int x, int y, String buttonText) {
            super(buttonId, x, y, 20, 20, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            boolean hovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            float factor = hovered ? 0.8f : 1.0f;
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)factor, (float)factor, (float)factor, (float)1.0f);
            mc.field_71446_o.func_110577_a(ICON);
            Gui.func_146110_a((int)(this.field_146128_h + this.field_146120_f / 2 - 8), (int)(this.field_146129_i + this.field_146121_g / 2 - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            if (hovered) {
                String label = TOOLTIP.get();
                TooltipStyle style = TooltipStyle.get();
                int w = mc.field_71466_p.func_78256_a(label);
                this.area.set(this.field_146128_h + 20, this.field_146129_i + this.field_146121_g / 2 - 7, w + 6, 14);
                style.drawBackground(this.area);
                mc.field_71466_p.func_78276_b(label, this.area.x + 3, this.area.y + 3, style.getTextColor());
            }
        }
    }
}

