/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.capabilities.character;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.DialogueContext;
import mchorse.mappet.api.huds.HUDMorph;
import mchorse.mappet.api.huds.HUDScene;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.capabilities.character.CharacterProvider;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.huds.PacketHUDMorph;
import mchorse.mappet.network.common.huds.PacketHUDScene;
import mchorse.mappet.utils.CurrentSession;
import mchorse.mappet.utils.PositionCache;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Character
implements ICharacter {
    private EntityPlayer player;
    private Quests quests = new Quests();
    private States states = new States();
    private CraftingTable table;
    private Dialogue dialogue;
    private DialogueContext dialogueContext;
    private Instant lastClear = Instant.now();
    private PositionCache positionCache = new PositionCache();
    private CurrentSession session = new CurrentSession();
    private UIContext uiContext;
    private Map<String, List<HUDScene>> displayedHUDs = new HashMap<String, List<HUDScene>>();

    public static Character get(EntityPlayer player) {
        ICharacter characterCapability;
        ICharacter iCharacter = characterCapability = player == null ? null : (ICharacter)player.getCapability(CharacterProvider.CHARACTER, null);
        if (characterCapability instanceof Character) {
            Character character = (Character)characterCapability;
            character.player = player;
            return character;
        }
        return null;
    }

    @Override
    public States getStates() {
        return this.states;
    }

    @Override
    public Quests getQuests() {
        return this.quests;
    }

    @Override
    public void setCraftingTable(CraftingTable table) {
        this.table = table;
    }

    @Override
    public CraftingTable getCraftingTable() {
        return this.table;
    }

    @Override
    public void setDialogue(Dialogue dialogue, DialogueContext context) {
        if (dialogue == null && this.dialogue != null) {
            this.dialogue.onClose.trigger(this.dialogueContext.data);
        }
        this.dialogue = dialogue;
        this.dialogueContext = context;
    }

    @Override
    public Dialogue getDialogue() {
        return this.dialogue;
    }

    @Override
    public DialogueContext getDialogueContext() {
        return this.dialogueContext;
    }

    @Override
    public Instant getLastClear() {
        return this.lastClear;
    }

    @Override
    public void updateLastClear(Instant instant) {
        this.lastClear = instant;
    }

    @Override
    public PositionCache getPositionCache() {
        return this.positionCache;
    }

    @Override
    public CurrentSession getCurrentSession() {
        return this.session;
    }

    @Override
    public void copy(ICharacter character, EntityPlayer player) {
        this.quests.copy(character.getQuests());
        this.states.copy(character.getStates());
        this.lastClear = character.getLastClear();
        this.displayedHUDs = character.getDisplayedHUDs();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Quests", (NBTBase)this.quests.serializeNBT());
        tag.func_74782_a("States", (NBTBase)this.states.serializeNBT());
        tag.func_74778_a("LastClear", this.lastClear.toString());
        tag.func_74782_a("DisplayedHUDs", (NBTBase)this.serializeDisplayedHUDs());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Quests")) {
            this.quests.deserializeNBT(tag.func_74775_l("Quests"));
        }
        if (tag.func_74764_b("States")) {
            this.states.deserializeNBT(tag.func_74775_l("States"));
        }
        if (tag.func_74764_b("LastClear")) {
            try {
                this.lastClear = Instant.parse(tag.func_74779_i("LastClear"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag.func_74764_b("DisplayedHUDs")) {
            this.deserializeDisplayedHUDs(tag.func_74775_l("DisplayedHUDs"));
        }
    }

    @Override
    public UIContext getUIContext() {
        return this.uiContext;
    }

    @Override
    public void setUIContext(UIContext context) {
        this.uiContext = context;
    }

    @Override
    public boolean setupHUD(String id, boolean addToDisplayedList) {
        HUDScene scene = (HUDScene)Mappet.huds.load(id);
        if (scene != null) {
            Dispatcher.sendTo(new PacketHUDScene(scene.getId(), scene.serializeNBT()), (EntityPlayerMP)this.player);
            if (scene.global) {
                for (EntityPlayer player : this.player.field_70170_p.field_73010_i) {
                    if (player == this.player) continue;
                    Dispatcher.sendTo(new PacketHUDScene(scene.getId(), scene.serializeNBT()), (EntityPlayerMP)player);
                }
            }
            if (addToDisplayedList) {
                this.getDisplayedHUDs().put(id, Arrays.asList(scene));
            }
            return true;
        }
        return false;
    }

    @Override
    public void changeHUDMorph(String id, int index, NBTTagCompound tag) {
        Dispatcher.sendTo(new PacketHUDMorph(id, index, tag), (EntityPlayerMP)this.player);
        HUDScene scene = (HUDScene)Mappet.huds.load(id);
        if (scene.global) {
            for (EntityPlayer player : this.player.field_70170_p.field_73010_i) {
                if (player == this.player) continue;
                Dispatcher.sendTo(new PacketHUDMorph(id, index, tag), (EntityPlayerMP)player);
            }
        }
        for (Map.Entry<String, List<HUDScene>> entry : this.getDisplayedHUDs().entrySet()) {
            List<HUDScene> scenes;
            if (!entry.getKey().equals(id) || (scenes = entry.getValue()).isEmpty()) continue;
            scene = scenes.get(0);
            if (scene.morphs.size() <= index) continue;
            HUDMorph newMorph = scene.morphs.get(index).copy();
            newMorph.morph = new Morph(MorphManager.INSTANCE.morphFromNBT(tag));
            scene.morphs.set(index, newMorph);
        }
    }

    @Override
    public void closeHUD(String id) {
        Dispatcher.sendTo(new PacketHUDScene(id == null ? "" : id, null), (EntityPlayerMP)this.player);
        HUDScene scene = (HUDScene)Mappet.huds.load(id);
        if (scene.global) {
            for (EntityPlayer player : this.player.field_70170_p.field_73010_i) {
                if (player == this.player) continue;
                Dispatcher.sendTo(new PacketHUDScene(id == null ? "" : id, null), (EntityPlayerMP)player);
            }
        }
        this.getDisplayedHUDs().remove(id);
    }

    @Override
    public void closeAllHUD() {
        this.closeHUD(null);
        for (Map.Entry<String, List<HUDScene>> entry : this.getDisplayedHUDs().entrySet()) {
            if (!entry.getValue().get((int)0).global) continue;
            for (EntityPlayer player : this.player.field_70170_p.field_73010_i) {
                if (player == this.player) continue;
                Dispatcher.sendTo(new PacketHUDScene(entry.getKey(), null), (EntityPlayerMP)player);
            }
        }
        this.getDisplayedHUDs().clear();
    }

    @Override
    public Map<String, List<HUDScene>> getDisplayedHUDs() {
        return this.displayedHUDs;
    }

    private NBTTagCompound serializeDisplayedHUDs() {
        return this.getDisplayedHUDsTag();
    }

    private void deserializeDisplayedHUDs(NBTTagCompound tag) {
        this.displayedHUDs.clear();
        for (String key : tag.func_150296_c()) {
            NBTTagList sceneList = tag.func_150295_c(key, 10);
            ArrayList<HUDScene> scenes = new ArrayList<HUDScene>();
            for (int i = 0; i < sceneList.func_74745_c(); ++i) {
                NBTTagCompound sceneTag = sceneList.func_150305_b(i);
                HUDScene scene = new HUDScene();
                scene.deserializeNBT(sceneTag);
                scenes.add(scene);
            }
            this.displayedHUDs.put(key, scenes);
        }
    }

    public NBTTagCompound getDisplayedHUDsTag() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, List<HUDScene>> entry : this.displayedHUDs.entrySet()) {
            NBTTagList sceneList = new NBTTagList();
            for (HUDScene scene : entry.getValue()) {
                sceneList.func_74742_a((NBTBase)scene.serializeNBT());
            }
            tag.func_74782_a(entry.getKey(), (NBTBase)sceneList);
        }
        return tag;
    }

    public NBTTagCompound getGlobalDisplayedHUDsTag() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, List<HUDScene>> entry : this.displayedHUDs.entrySet()) {
            if (!entry.getValue().get((int)0).global) continue;
            NBTTagList sceneList = new NBTTagList();
            for (HUDScene scene : entry.getValue()) {
                sceneList.func_74742_a((NBTBase)scene.serializeNBT());
            }
            tag.func_74782_a(entry.getKey(), (NBTBase)sceneList);
        }
        return tag;
    }

    public void updateDisplayedHUDsList() {
        Iterator<Map.Entry<String, List<HUDScene>>> iterator = this.getDisplayedHUDs().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<HUDScene>> entry = iterator.next();
            List<HUDScene> scenes = entry.getValue();
            boolean removeScene = false;
            for (HUDScene scene : scenes) {
                List<HUDMorph> morphs = scene.morphs;
                boolean updated = false;
                for (int i = 0; i < morphs.size(); ++i) {
                    HUDMorph morph = morphs.get(i);
                    if (morph.expire <= 0) continue;
                    --morph.expire;
                    if (morph.expire != 0) continue;
                    morphs.remove(i);
                    --i;
                    updated = true;
                }
                if (!updated || !morphs.isEmpty()) continue;
                removeScene = true;
                break;
            }
            if (!removeScene) continue;
            iterator.remove();
        }
    }
}

