/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils.manager;

import java.io.File;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.manager.FolderManager;
import mchorse.mappet.api.utils.manager.ManagerCache;
import mchorse.mappet.utils.NBTToJsonLike;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class BaseManager<T extends AbstractData>
extends FolderManager<T> {
    public BaseManager(File folder) {
        super(folder);
    }

    @Override
    public final T create(String id, NBTTagCompound tag) {
        T data = this.createData(id, tag);
        ((AbstractData)data).setId(id);
        return data;
    }

    protected abstract T createData(String var1, NBTTagCompound var2);

    @Override
    public T load(String id) {
        try {
            NBTTagCompound tag = this.getCached(id);
            INBTSerializable data = this.create(id, tag);
            return (T)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected NBTTagCompound getCached(String id) throws Exception {
        ManagerCache cache;
        NBTTagCompound tag = null;
        File file = this.getFile(id);
        boolean isCaching = (Boolean)Mappet.generalDataCaching.get();
        long lastUpdated = file.lastModified();
        if (isCaching && (cache = (ManagerCache)this.cache.get(id)) != null) {
            if (cache.lastUpdated < lastUpdated) {
                this.cache.remove(id);
            } else {
                tag = cache.tag;
                cache.update();
            }
            this.doExpirationCheck();
        }
        if (tag == null) {
            tag = NBTToJsonLike.read(file);
            if (isCaching) {
                this.cache.put(id, new ManagerCache(tag, lastUpdated));
            }
        }
        return tag;
    }

    public boolean save(String id, T data) {
        return this.save(id, (NBTTagCompound)data.serializeNBT());
    }

    @Override
    public boolean save(String name, NBTTagCompound tag) {
        try {
            NBTToJsonLike.write(this.getFile(name), tag);
            this.cache.remove(name);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

