/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mappet.utils.EnumUtils;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class Target
implements INBTSerializable<NBTTagCompound> {
    public TargetMode mode;
    public String selector = "";
    private TargetMode defaultMode;

    public Target(TargetMode mode) {
        this.mode = this.defaultMode = mode;
    }

    public EntityPlayer getPlayer(DataContext context) {
        if (this.mode == TargetMode.SUBJECT && context.subject instanceof EntityPlayer) {
            return (EntityPlayer)context.subject;
        }
        if (this.mode == TargetMode.OBJECT && context.object instanceof EntityPlayer) {
            return (EntityPlayer)context.object;
        }
        if (this.mode == TargetMode.PLAYER) {
            return context.getPlayer();
        }
        if (this.mode == TargetMode.SELECTOR) {
            try {
                return EntitySelector.func_82386_a((ICommandSender)context.getSender(), (String)this.selector);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Entity getEntity(DataContext context) {
        if (this.mode == TargetMode.SUBJECT && context.subject != null) {
            return context.subject;
        }
        if (this.mode == TargetMode.OBJECT && context.object != null) {
            return context.object;
        }
        if (this.mode == TargetMode.PLAYER) {
            return context.getPlayer();
        }
        if (this.mode == TargetMode.NPC) {
            return context.getNpc();
        }
        if (this.mode == TargetMode.SELECTOR) {
            try {
                return EntitySelector.func_179652_a((ICommandSender)context.getSender(), (String)this.selector, Entity.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ICharacter getCharacter(DataContext context) {
        return Character.get(this.getPlayer(context));
    }

    public States getStates(DataContext context) {
        if (this.mode != TargetMode.GLOBAL) {
            return EntityUtils.getStates(this.getEntity(context));
        }
        return Mappet.states;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Target", this.mode.ordinal());
        tag.func_74778_a("Selector", this.selector);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.mode = EnumUtils.getValue(tag.func_74762_e("Target"), TargetMode.values(), this.defaultMode);
        this.selector = tag.func_74779_i("Selector");
    }
}

