/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.utils.TriggerSender;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.utils.ExpressionRewriter;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataContext {
    public static final ExpressionRewriter REWRITER = new ExpressionRewriter();
    public MinecraftServer server;
    public World world;
    public BlockPos pos;
    public Entity subject;
    public Entity object;
    private boolean canceled;
    private TriggerSender sender;
    private Map<String, Object> values = new HashMap<String, Object>();

    public DataContext(Entity subject, Entity object) {
        this(subject.field_70170_p);
        this.subject = subject;
        this.object = object;
        this.setup();
    }

    public DataContext(Entity subject) {
        this(subject.field_70170_p);
        this.subject = subject;
        this.setup();
    }

    public DataContext(World world) {
        this(world.func_73046_m());
        this.world = world;
    }

    public DataContext(World world, BlockPos pos) {
        this(world.func_73046_m());
        this.world = world;
        this.pos = pos;
    }

    public DataContext(MinecraftServer server) {
        this.server = server;
        this.setup();
    }

    public void cancel() {
        this.cancel(true);
    }

    public void cancel(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void setup() {
        EntityPlayer player = this.getPlayer();
        EntityNpc npc = this.getNpc();
        this.set("subject", this.subject == null ? "" : this.subject.func_189512_bd());
        this.set("subject_name", this.subject == null ? "" : this.subject.func_70005_c_());
        this.set("object", this.object == null ? "" : this.object.func_189512_bd());
        this.set("object_name", this.object == null ? "" : this.object.func_70005_c_());
        this.set("player", player == null ? "" : player.func_189512_bd());
        this.set("player_name", player == null ? "" : player.func_70005_c_());
        this.set("npc", npc == null ? "" : npc.func_189512_bd());
        this.set("npc_name", npc == null ? "" : npc.func_70005_c_());
    }

    public DataContext set(String key, double value) {
        this.values.put(key, value);
        return this;
    }

    public DataContext set(String key, String value) {
        this.values.put(key, value);
        return this;
    }

    public DataContext parse(String nbt) {
        try {
            this.parse(JsonToNBT.func_180713_a((String)nbt));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataContext parse(NBTTagCompound tag) {
        for (String key : tag.func_150296_c()) {
            NBTBase value = tag.func_74781_a(key);
            if (value instanceof NBTPrimitive) {
                this.set(key, ((NBTPrimitive)value).func_150286_g());
                continue;
            }
            if (!(value instanceof NBTTagString)) continue;
            this.set(key, ((NBTTagString)value).func_150285_a_());
        }
        return this;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public int execute(String command) {
        command = this.process(command);
        return this.server.func_71187_D().func_71556_a(this.getSender(), command);
    }

    public String process(String text) {
        if (text.startsWith("/")) {
            text = text.substring(1);
        }
        if (!text.contains("${")) {
            return text;
        }
        return REWRITER.set(this).rewrite(text);
    }

    public EntityPlayer getPlayer() {
        if (this.subject instanceof EntityPlayer) {
            return (EntityPlayer)this.subject;
        }
        if (this.object instanceof EntityPlayer) {
            return (EntityPlayer)this.object;
        }
        return null;
    }

    public EntityNpc getNpc() {
        if (this.subject instanceof EntityNpc) {
            return (EntityNpc)this.subject;
        }
        if (this.object instanceof EntityNpc) {
            return (EntityNpc)this.object;
        }
        return null;
    }

    public Set<String> getKeys() {
        return this.values.keySet();
    }

    public ICommandSender getSender() {
        if (((Boolean)Mappet.eventUseServerForCommands.get()).booleanValue()) {
            return this.server;
        }
        if (this.sender == null) {
            this.sender = new TriggerSender();
        }
        if (this.subject == null) {
            this.sender.set(this.server, this.world, this.pos);
        } else {
            this.sender.set(this.subject);
        }
        return this.sender;
    }

    public DataContext copy() {
        DataContext context = new DataContext(this.server);
        context.subject = this.subject;
        context.object = this.object;
        context.pos = this.pos;
        context.world = this.world;
        context.values.putAll(this.values);
        context.setup();
        return context;
    }
}

