/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.util.function.Consumer;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UITrackpadComponent
extends UIComponent {
    public Double value;
    public Double min;
    public Double max;
    public boolean integer;
    public Double normal;
    public Double weak;
    public Double strong;
    public Double increment;

    public UITrackpadComponent value(double value) {
        this.change("Value");
        this.value = value;
        return this;
    }

    public UITrackpadComponent min(double min) {
        this.change("Min");
        this.min = min;
        return this;
    }

    public UITrackpadComponent max(double max) {
        this.change("Max");
        this.max = max;
        return this;
    }

    public UITrackpadComponent integer() {
        return this.integer(true);
    }

    public UITrackpadComponent integer(boolean integer) {
        this.change("Integer");
        this.integer = integer;
        return this;
    }

    public UITrackpadComponent limit(double min, double max) {
        return this.min(min).max(max);
    }

    public UITrackpadComponent limit(double min, double max, boolean integer) {
        return this.min(min).max(max).integer(integer);
    }

    public UITrackpadComponent amplitudes(double normal) {
        return this.amplitudes(normal, normal / 5.0, normal * 5.0);
    }

    public UITrackpadComponent amplitudes(double normal, double weak, double strong) {
        this.change("Normal", "Weak", "Strong");
        this.normal = normal;
        this.weak = weak;
        this.strong = strong;
        return this;
    }

    public UITrackpadComponent increment(double increment) {
        this.change("Increment");
        this.increment = increment;
        return this;
    }

    @Override
    @DiscardMethod
    protected int getDefaultUpdateDelay() {
        return 200;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiTrackpadElement trackpad = (GuiTrackpadElement)element;
        if (key.equals("Value") && this.value != null) {
            trackpad.setValue(this.value.doubleValue());
        } else if (key.equals("Min") && this.min != null) {
            trackpad.min = this.min;
        } else if (key.equals("Max") && this.max != null) {
            trackpad.max = this.max;
        } else if (key.equals("Integer")) {
            trackpad.integer = this.integer;
        } else if (key.equals("Normal") && this.normal != null) {
            trackpad.normal = this.normal;
        } else if (key.equals("Weak") && this.weak != null) {
            trackpad.weak = this.weak;
        } else if (key.equals("Strong") && this.strong != null) {
            trackpad.strong = this.strong;
        } else if (key.equals("Increment") && this.increment != null) {
            trackpad.increment = this.increment;
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiTrackpadElement element = new GuiTrackpadElement(mc, (Consumer)null);
        element.callback = v -> {
            if (!this.id.isEmpty()) {
                if (element.integer) {
                    context.data.func_74768_a(this.id, v.intValue());
                } else {
                    context.data.func_74780_a(this.id, v.doubleValue());
                }
                context.dirty(this.id, this.updateDelay);
            }
        };
        if (this.value != null) {
            element.setValue(this.value.doubleValue());
        }
        if (this.min != null) {
            element.min = this.min;
        }
        if (this.max != null) {
            element.max = this.max;
        }
        element.integer = this.integer;
        if (this.normal != null) {
            element.normal = this.normal;
        }
        if (this.weak != null) {
            element.weak = this.weak;
        }
        if (this.strong != null) {
            element.strong = this.strong;
        }
        if (this.increment != null) {
            element.increment = this.increment;
        }
        return this.apply((GuiElement)element, context);
    }

    @Override
    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
        super.populateData(tag);
        if (!this.id.isEmpty()) {
            if (this.integer) {
                tag.func_74768_a(this.id, this.value == null ? 0 : this.value.intValue());
            } else {
                tag.func_74780_a(this.id, this.value == null ? 0.0 : this.value);
            }
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        if (this.value != null) {
            tag.func_74780_a("Value", this.value.doubleValue());
        }
        if (this.min != null) {
            tag.func_74780_a("Min", this.min.doubleValue());
        }
        if (this.max != null) {
            tag.func_74780_a("Max", this.max.doubleValue());
        }
        tag.func_74757_a("Integer", this.integer);
        if (this.normal != null) {
            tag.func_74780_a("Normal", this.normal.doubleValue());
        }
        if (this.weak != null) {
            tag.func_74780_a("Weak", this.weak.doubleValue());
        }
        if (this.strong != null) {
            tag.func_74780_a("Strong", this.strong.doubleValue());
        }
        if (this.increment != null) {
            tag.func_74780_a("Increment", this.increment.doubleValue());
        }
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Value")) {
            this.value = tag.func_74769_h("Value");
        }
        if (tag.func_74764_b("Min")) {
            this.min = tag.func_74769_h("Min");
        }
        if (tag.func_74764_b("Max")) {
            this.max = tag.func_74769_h("Max");
        }
        if (tag.func_74764_b("Integer")) {
            this.integer = tag.func_74767_n("Integer");
        }
        if (tag.func_74764_b("Normal")) {
            this.normal = tag.func_74769_h("Normal");
        }
        if (tag.func_74764_b("Weak")) {
            this.weak = tag.func_74769_h("Weak");
        }
        if (tag.func_74764_b("Strong")) {
            this.strong = tag.func_74769_h("Strong");
        }
        if (tag.func_74764_b("Increment")) {
            this.increment = tag.func_74769_h("Increment");
        }
    }
}

