/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UILabelBaseComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UIButtonComponent
extends UILabelBaseComponent {
    public Integer background;

    public UIButtonComponent background(int background) {
        this.change("Background");
        this.background = background;
        return this;
    }

    public UIButtonComponent noBackground() {
        this.hasBackground = false;
        return this;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected boolean isDataReserved() {
        return true;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiButtonElement button = (GuiButtonElement)element;
        if (key.equals("Label")) {
            button.label = IKey.str((String)this.getLabel());
        } else if (key.equals("Background")) {
            if (this.background != null && this.background >= 0) {
                button.color(this.background.intValue());
            } else {
                button.custom = false;
            }
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiButtonElement button = new GuiButtonElement(mc, IKey.str((String)this.getLabel()), b -> {
            if (!this.id.isEmpty()) {
                this.populateData(context.data);
                context.dirty(this.id, this.updateDelay);
            }
        });
        if (this.background != null && this.background >= 0) {
            button.color(this.background.intValue());
        }
        button.background(this.hasBackground);
        return this.apply((GuiElement)button, context);
    }

    @Override
    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
        super.populateData(tag);
        if (!this.id.isEmpty()) {
            tag.func_74768_a(this.id, tag.func_74762_e(this.id) + 1);
        }
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        if (this.background != null) {
            tag.func_74768_a("Background", this.background.intValue());
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Background")) {
            this.background = tag.func_74762_e("Background");
        }
    }
}

