/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers.blocks;

import mchorse.mappet.api.states.States;
import mchorse.mappet.api.triggers.blocks.StringTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.Target;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.utils.EnumUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StateTriggerBlock
extends StringTriggerBlock {
    public Target target = new Target(TargetMode.GLOBAL);
    public StateMode mode = StateMode.SET;
    public Object value = 0.0;

    @Override
    public void trigger(DataContext context) {
        States states = this.target.getStates(context);
        if (states == null) {
            return;
        }
        if (this.mode == StateMode.ADD && this.value instanceof Number) {
            states.add(this.string, ((Number)this.value).doubleValue());
        } else if (this.mode == StateMode.SET) {
            if (this.value instanceof Number) {
                states.setNumber(this.string, ((Number)this.value).doubleValue());
            } else if (this.value instanceof String) {
                states.setString(this.string, (String)this.value);
            }
        } else {
            states.resetMasked(this.string);
        }
    }

    @Override
    protected String getKey() {
        return "State";
    }

    @Override
    protected void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74782_a("Target", (NBTBase)this.target.serializeNBT());
        tag.func_74768_a("Mode", this.mode.ordinal());
        if (this.value instanceof Number) {
            tag.func_74780_a("Value", ((Number)this.value).doubleValue());
        } else if (this.value instanceof String) {
            tag.func_74778_a("Value", (String)this.value);
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.target.deserializeNBT(tag.func_74775_l("Target"));
        this.mode = EnumUtils.getValue(tag.func_74762_e("Mode"), StateMode.values(), StateMode.SET);
        if (tag.func_150297_b("Value", 99)) {
            this.value = tag.func_74769_h("Value");
        } else if (tag.func_150297_b("Value", 8)) {
            this.value = tag.func_74779_i("Value");
        }
    }

    public static enum StateMode {
        ADD,
        SET,
        REMOVE;

    }
}

