/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers.blocks;

import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.utils.AbstractBlock;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractTriggerBlock
extends AbstractBlock {
    public int frequency = 1;
    private int tick;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        return I18n.func_135052_a((String)("mappet.gui.trigger_types." + CommonProxy.getTriggerBlocks().getType(this)), (Object[])new Object[0]);
    }

    public void triggerWithFrequency(DataContext context) {
        ++this.tick;
        if (this.tick > 0 && this.tick % Math.max(this.frequency, 1) == 0) {
            this.trigger(context);
            this.tick = 0;
        }
    }

    public abstract void trigger(DataContext var1);

    public abstract boolean isEmpty();

    @Override
    protected void serializeNBT(NBTTagCompound tag) {
        tag.func_74768_a("Frequency", this.frequency);
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Delay")) {
            tag.func_74782_a("Frequency", tag.func_74781_a("Delay"));
        }
        this.frequency = tag.func_74762_e("Frequency");
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.serializeNBT(tag);
        return tag;
    }
}

