/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.triggers.blocks.AbstractTriggerBlock;
import mchorse.mappet.api.triggers.blocks.CommandTriggerBlock;
import mchorse.mappet.api.triggers.blocks.DialogueTriggerBlock;
import mchorse.mappet.api.triggers.blocks.EventTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ScriptTriggerBlock;
import mchorse.mappet.api.triggers.blocks.SoundTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class Trigger
implements INBTSerializable<NBTTagCompound> {
    public final List<AbstractTriggerBlock> blocks = new ArrayList<AbstractTriggerBlock>();
    private boolean empty;

    public Trigger() {
    }

    public Trigger(List<AbstractTriggerBlock> blocks) {
        this.blocks.addAll(blocks);
    }

    public void copy(Trigger trigger) {
        this.blocks.clear();
        for (AbstractTriggerBlock block : trigger.blocks) {
            String type = CommonProxy.getTriggerBlocks().getType(block);
            AbstractTriggerBlock newBlock = CommonProxy.getTriggerBlocks().create(type);
            newBlock.deserializeNBT(block.serializeNBT());
            this.blocks.add(newBlock);
        }
        this.recalculateEmpty();
    }

    public void recalculateEmpty() {
        this.empty = true;
        for (AbstractTriggerBlock block : this.blocks) {
            if (block.isEmpty()) continue;
            this.empty = false;
        }
    }

    public void trigger(EntityLivingBase target) {
        this.trigger(new DataContext((Entity)target));
    }

    public void trigger(EntityLivingBase target, Entity entity) {
        this.trigger(new DataContext((Entity)target, entity));
    }

    public void trigger(DataContext context) {
        for (AbstractTriggerBlock block : this.blocks) {
            if (context.isCanceled()) {
                return;
            }
            block.triggerWithFrequency(context);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList blocks = new NBTTagList();
        for (AbstractTriggerBlock block : this.blocks) {
            NBTTagCompound blockTag = block.serializeNBT();
            blockTag.func_74778_a("Type", CommonProxy.getTriggerBlocks().getType(block));
            blocks.func_74742_a((NBTBase)blockTag);
        }
        tag.func_74782_a("Blocks", (NBTBase)blocks);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.blocks.clear();
        if (tag.func_74764_b("Sound")) {
            this.blocks.add(new SoundTriggerBlock(tag.func_74779_i("Sound")));
        }
        if (tag.func_74764_b("Trigger")) {
            this.blocks.add(new EventTriggerBlock(tag.func_74779_i("Trigger")));
        }
        if (tag.func_74764_b("Command")) {
            this.blocks.add(new CommandTriggerBlock(tag.func_74779_i("Command")));
        }
        if (tag.func_74764_b("Dialogue")) {
            this.blocks.add(new DialogueTriggerBlock(tag.func_74779_i("Dialogue")));
        }
        if (tag.func_74764_b("Script")) {
            this.blocks.add(new ScriptTriggerBlock(tag.func_74779_i("Script"), tag.func_74779_i("ScriptFunction")));
        }
        if (tag.func_74764_b("Blocks")) {
            NBTTagList blocks = tag.func_150295_c("Blocks", 10);
            for (int i = 0; i < blocks.func_74745_c(); ++i) {
                NBTTagCompound blockTag = blocks.func_150305_b(i);
                AbstractTriggerBlock block = CommonProxy.getTriggerBlocks().create(blockTag.func_74779_i("Type"));
                if (block == null) continue;
                block.deserializeNBT(blockTag);
                this.blocks.add(block);
            }
        }
        this.recalculateEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

