/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.user.entities;

import java.util.List;
import mchorse.mappet.api.scripts.code.entities.ScriptEntityItem;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.user.IScriptRayTrace;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.data.ScriptBox;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetStates;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Potion;

public interface IScriptEntity {
    public Entity getMinecraftEntity();

    public IScriptWorld getWorld();

    public ScriptVector getPosition();

    public void setPosition(double var1, double var3, double var5);

    public int getDimension();

    public void setDimension(int var1);

    public ScriptVector getMotion();

    public void setMotion(double var1, double var3, double var5);

    public void addMotion(double var1, double var3, double var5);

    public ScriptVector getRotations();

    public void setRotations(float var1, float var2, float var3);

    public float getPitch();

    public float getYaw();

    public float getYawHead();

    public ScriptVector getLook();

    public float getEyeHeight();

    public float getWidth();

    public float getHeight();

    public float getHp();

    public void setHp(float var1);

    public float getMaxHp();

    public void setMaxHp(float var1);

    public boolean isInWater();

    public boolean isInLava();

    public boolean isBurning();

    public void setBurning(int var1);

    public boolean isSneaking();

    public boolean isSprinting();

    public boolean isOnGround();

    public IScriptRayTrace rayTrace(double var1);

    public IScriptRayTrace rayTraceBlock(double var1);

    public IScriptItemStack getMainItem();

    public void setMainItem(IScriptItemStack var1);

    public IScriptItemStack getOffItem();

    public void setOffItem(IScriptItemStack var1);

    public void giveItem(IScriptItemStack var1);

    public void giveItem(IScriptItemStack var1, boolean var2, boolean var3);

    public IScriptItemStack getHelmet();

    public IScriptItemStack getChestplate();

    public IScriptItemStack getLeggings();

    public IScriptItemStack getBoots();

    public void setHelmet(IScriptItemStack var1);

    public void setChestplate(IScriptItemStack var1);

    public void setLeggings(IScriptItemStack var1);

    public void setBoots(IScriptItemStack var1);

    default public void setArmor(IScriptItemStack helmet, IScriptItemStack chestplate, IScriptItemStack leggings, IScriptItemStack boots) {
        this.setHelmet(helmet);
        this.setChestplate(chestplate);
        this.setLeggings(leggings);
        this.setBoots(boots);
    }

    default public void clearArmor() {
        this.setArmor(ScriptItemStack.EMPTY, ScriptItemStack.EMPTY, ScriptItemStack.EMPTY, ScriptItemStack.EMPTY);
    }

    public void setSpeed(float var1);

    public IScriptEntity getTarget();

    public void setTarget(IScriptEntity var1);

    public boolean isAIEnabled();

    public void setAIEnabled(boolean var1);

    public String getUniqueId();

    public String getEntityId();

    public int getTicks();

    public int getCombinedLight();

    public String getName();

    public void setName(String var1);

    public void setInvisible(boolean var1);

    public INBTCompound getFullData();

    public void setFullData(INBTCompound var1);

    public INBTCompound getEntityData();

    public boolean isPlayer();

    @Deprecated
    public boolean isNpc();

    public boolean isNPC();

    public boolean isItem();

    public boolean isLivingBase();

    public boolean isSame(IScriptEntity var1);

    public boolean isEntityInRadius(IScriptEntity var1, double var2);

    default public boolean isInBlock(int x, int y, int z) {
        return this.isInArea(x, y, z, x + 1, y + 1, z + 1);
    }

    public boolean isInArea(double var1, double var3, double var5, double var7, double var9, double var11);

    public void damage(float var1);

    public void damageAs(IScriptEntity var1, float var2);

    public void damageWithItemsAs(IScriptPlayer var1);

    public void mount(IScriptEntity var1);

    public void dismount();

    public IScriptEntity getMount();

    public ScriptBox getBoundingBox();

    public ScriptEntityItem dropItem(int var1);

    public ScriptEntityItem dropItem();

    public ScriptEntityItem dropItem(IScriptItemStack var1);

    public float getFallDistance();

    public void setFallDistance(float var1);

    public void remove();

    public void kill();

    default public void swingArm() {
        this.swingArm(0);
    }

    public void swingArm(int var1);

    public List<IScriptEntity> getLeashedEntities();

    public boolean setLeashHolder(IScriptEntity var1);

    public IScriptEntity getLeashHolder();

    public boolean clearLeashHolder(boolean var1);

    public void setModifier(String var1, double var2);

    public double getModifier(String var1);

    public void removeModifier(String var1);

    public void removeAllModifiers();

    public void applyPotion(Potion var1, int var2, int var3, boolean var4);

    public boolean hasPotion(Potion var1);

    public boolean removePotion(Potion var1);

    public void clearPotions();

    public IMappetStates getStates();

    public AbstractMorph getMorph();

    public boolean setMorph(AbstractMorph var1);

    default public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z) {
        this.displayMorph(morph, expiration, x, y, z, true);
    }

    default public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, boolean rotate) {
        this.displayMorph(morph, expiration, x, y, z, 0.0f, 0.0f, rotate);
    }

    default public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, float yaw, float pitch, boolean rotate) {
        this.displayMorph(morph, expiration, x, y, z, yaw, pitch, rotate, null);
    }

    public void displayMorph(AbstractMorph var1, int var2, double var3, double var5, double var7, float var9, float var10, boolean var11, IScriptPlayer var12);

    public IScriptEntity shootBBGunProjectile(String var1);

    public void executeCommand(String var1);

    public void executeScript(String var1);

    public void executeScript(String var1, String var2);

    public void executeScript(String var1, String var2, Object ... var3);

    public void lockPosition(double var1, double var3, double var5);

    public void unlockPosition();

    public boolean isPositionLocked();

    public void lockRotation(float var1, float var2, float var3);

    public void unlockRotation();

    public boolean isRotationLocked();

    public void moveTo(String var1, int var2, double var3, double var5, double var7, boolean var9);

    public void observe(IScriptEntity var1);

    public void addEntityPatrol(double var1, double var3, double var5, double var7, boolean var9, String var10);

    public void clearEntityPatrols();

    public void setRotationsAI(float var1, float var2, float var3);

    public void clearRotationsAI();

    public void executeRepeatingCommand(String var1, int var2);

    public void removeRepeatingCommand(String var1);

    public void clearAllRepeatingCommands();
}

