/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mchorse.mappet.api.scripts.code.items.ScriptItem;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.items.IScriptItem;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ScriptItemStack
implements IScriptItemStack {
    public static final ScriptItemStack EMPTY = new ScriptItemStack(ItemStack.field_190927_a);
    private static final String CAN_DESTROY = "CanDestroy";
    private static final String CAN_PLACE_ON = "CanPlaceOn";
    private ItemStack stack;
    private IScriptItem item;

    public static IScriptItemStack create(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return EMPTY;
        }
        return new ScriptItemStack(stack);
    }

    private ScriptItemStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getMinecraftItemStack() {
        return this.stack;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    public IScriptItemStack copy() {
        return new ScriptItemStack(this.getMinecraftItemStack().func_77946_l());
    }

    @Override
    public IScriptItem getItem() {
        if (this.item == null) {
            this.item = new ScriptItem(this.stack.func_77973_b());
        }
        return this.item;
    }

    @Override
    public int getMaxCount() {
        return this.stack.func_77976_d();
    }

    @Override
    public int getCount() {
        return this.stack.func_190916_E();
    }

    @Override
    public void setCount(int count) {
        this.stack.func_190920_e(count);
    }

    @Override
    public int getMeta() {
        return this.stack.func_77960_j();
    }

    @Override
    public void setMeta(int meta) {
        this.stack.func_77964_b(meta);
    }

    @Override
    public boolean hasData() {
        return this.stack.func_77942_o();
    }

    @Override
    public INBTCompound getData() {
        return new ScriptNBTCompound(this.stack.func_77978_p());
    }

    @Override
    public void setData(INBTCompound tag) {
        this.stack.func_77982_d(tag.getNBTTagCompound());
    }

    @Override
    public INBTCompound serialize() {
        return new ScriptNBTCompound(this.stack.serializeNBT());
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    @Override
    public void setDisplayName(String name) {
        this.stack.func_151001_c(name);
    }

    private NBTTagList getLoreNBTList() {
        NBTTagCompound display;
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            display.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        return display.func_150295_c("Lore", 8);
    }

    @Override
    public String getLore(int index) {
        NBTTagList list = this.getLoreNBTList();
        if (list != null && index < list.func_74745_c()) {
            return list.func_150307_f(index);
        }
        throw new IllegalStateException("Lore index out of bounds, or no lore exists.");
    }

    @Override
    public List<String> getLoreList() {
        NBTTagList lore = this.getLoreNBTList();
        if (lore == null) {
            return Collections.emptyList();
        }
        ArrayList<String> loreList = new ArrayList<String>();
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            loreList.add(lore.func_150307_f(i));
        }
        return loreList;
    }

    @Override
    public void setLore(int index, String string) {
        NBTTagList lore = this.getLoreNBTList();
        if (lore == null || index < 0 || index >= lore.func_74745_c()) {
            throw new IllegalStateException("Lore index out of bounds, or no lore exists.");
        }
        lore.func_150304_a(index, (NBTBase)new NBTTagString(string));
    }

    @Override
    public void addLore(String string) {
        NBTTagList lore = this.getLoreNBTList();
        if (lore != null) {
            lore.func_74742_a((NBTBase)new NBTTagString(string));
        }
    }

    @Override
    public void clearAllLores() {
        NBTTagList lore = this.getLoreNBTList();
        if (lore != null) {
            while (lore.func_74745_c() > 0) {
                lore.func_74744_a(lore.func_74745_c() - 1);
            }
        }
    }

    @Override
    public void clearLore(int index) {
        NBTTagList lore = this.getLoreNBTList();
        if (lore == null || index < 0 || index >= lore.func_74745_c()) {
            throw new IllegalStateException("Lore index out of bounds, or no lore exists.");
        }
        lore.func_74744_a(index);
    }

    @Override
    public void clearAllEnchantments() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o("ench");
        }
    }

    @Override
    public List<String> getCanDestroyBlocks() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(CAN_DESTROY, 9)) {
            return Collections.emptyList();
        }
        ArrayList<String> canDestroyBlocks = new ArrayList<String>();
        NBTTagList list = tag.func_150295_c(CAN_DESTROY, 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            canDestroyBlocks.add(list.func_150307_f(i));
        }
        return canDestroyBlocks;
    }

    @Override
    public void addCanDestroyBlock(String block) {
        NBTTagList canDestroyList;
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.stack.func_77982_d(tag);
        }
        if (!tag.func_150297_b(CAN_DESTROY, 9)) {
            canDestroyList = new NBTTagList();
            tag.func_74782_a(CAN_DESTROY, (NBTBase)canDestroyList);
        } else {
            canDestroyList = tag.func_150295_c(CAN_DESTROY, 8);
        }
        for (int i = 0; i < canDestroyList.func_74745_c(); ++i) {
            if (!canDestroyList.func_150307_f(i).equals(block)) continue;
            return;
        }
        canDestroyList.func_74742_a((NBTBase)new NBTTagString(block));
    }

    @Override
    public void clearAllCanDestroyBlocks() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(CAN_DESTROY);
        }
    }

    @Override
    public void clearCanDestroyBlock(String block) {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            NBTTagList canPlaceOn = tag.func_150295_c(CAN_DESTROY, 8);
            NBTTagList newCanPlaceOn = new NBTTagList();
            for (int i = 0; i < canPlaceOn.func_74745_c(); ++i) {
                if (canPlaceOn.func_150307_f(i).equals(block)) continue;
                newCanPlaceOn.func_74742_a(canPlaceOn.func_179238_g(i));
            }
            tag.func_74782_a(CAN_DESTROY, (NBTBase)newCanPlaceOn);
        }
    }

    @Override
    public List<String> getCanPlaceOnBlocks() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(CAN_PLACE_ON, 9)) {
            return Collections.emptyList();
        }
        ArrayList<String> canPlaceOn = new ArrayList<String>();
        NBTTagList list = tag.func_150295_c(CAN_PLACE_ON, 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            canPlaceOn.add(list.func_150307_f(i));
        }
        return canPlaceOn;
    }

    @Override
    public void addCanPlaceOnBlock(String block) {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        if (!tag.func_150297_b(CAN_PLACE_ON, 9)) {
            tag.func_74782_a(CAN_PLACE_ON, (NBTBase)new NBTTagList());
        }
        tag.func_150295_c(CAN_PLACE_ON, 8).func_74742_a((NBTBase)new NBTTagString(block));
    }

    @Override
    public void clearAllCanPlaceOnBlocks() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(CAN_PLACE_ON);
        }
    }

    @Override
    public void clearCanPlaceOnBlock(String block) {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            NBTTagList canPlaceOn = tag.func_150295_c(CAN_PLACE_ON, 8);
            NBTTagList newCanPlaceOn = new NBTTagList();
            for (int i = 0; i < canPlaceOn.func_74745_c(); ++i) {
                if (canPlaceOn.func_150307_f(i).equals(block)) continue;
                newCanPlaceOn.func_74742_a(canPlaceOn.func_179238_g(i));
            }
            tag.func_74782_a(CAN_PLACE_ON, (NBTBase)newCanPlaceOn);
        }
    }

    @Override
    public int getRepairCost() {
        return this.stack.func_82838_A();
    }

    @Override
    public void setRepairCost(int cost) {
        this.stack.func_82841_c(cost);
    }

    @Override
    public boolean isUnbreakable() {
        return !this.stack.func_77984_f();
    }

    @Override
    public void setUnbreakable(boolean unbreakable) {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null) {
            tag.func_74757_a("Unbreakable", unbreakable);
        }
    }

    @Override
    public void add(int amount) {
        int newCount = this.stack.func_190916_E() + amount;
        if (newCount <= 0) {
            this.stack.func_190918_g(this.stack.func_190916_E());
        } else {
            this.stack.func_190920_e(newCount);
        }
    }

    @Override
    public boolean equals(ScriptItemStack other) {
        return this.stack.func_77969_a(other.stack) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.stack);
    }
}

