/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities.ai.repeatingCommand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class RepeatingCommandDataStorage
extends WorldSavedData {
    public static final String REPEATING_COMMAND_DATA_KEY = "mappet_repeating_command_data";
    private Map<UUID, List<RepeatingCommandData>> repeatingCommandDataMap = new HashMap<UUID, List<RepeatingCommandData>>();

    public RepeatingCommandDataStorage() {
        super(REPEATING_COMMAND_DATA_KEY);
    }

    public RepeatingCommandDataStorage(String name) {
        super(name);
    }

    public static RepeatingCommandDataStorage getRepeatingCommandDataStorage(World world) {
        MapStorage storage = world.func_175693_T();
        RepeatingCommandDataStorage repeatingCommandDataStorage = (RepeatingCommandDataStorage)storage.func_75742_a(RepeatingCommandDataStorage.class, REPEATING_COMMAND_DATA_KEY);
        if (repeatingCommandDataStorage == null) {
            repeatingCommandDataStorage = new RepeatingCommandDataStorage();
            storage.func_75745_a(REPEATING_COMMAND_DATA_KEY, (WorldSavedData)repeatingCommandDataStorage);
        }
        return repeatingCommandDataStorage;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.repeatingCommandDataMap.clear();
        NBTTagList repeatingCommandDataList = nbt.func_150295_c("repeatingCommandDataList", 10);
        for (int i = 0; i < repeatingCommandDataList.func_74745_c(); ++i) {
            NBTTagCompound repeatingCommandDataCompound = repeatingCommandDataList.func_150305_b(i);
            UUID entityId = UUID.fromString(repeatingCommandDataCompound.func_74779_i("entityId"));
            String command = repeatingCommandDataCompound.func_74779_i("command");
            int frequency = repeatingCommandDataCompound.func_74762_e("frequency");
            this.repeatingCommandDataMap.computeIfAbsent(entityId, k -> new ArrayList()).add(new RepeatingCommandData(command, frequency));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList repeatingCommandDataList = new NBTTagList();
        for (Map.Entry<UUID, List<RepeatingCommandData>> entry : this.repeatingCommandDataMap.entrySet()) {
            for (RepeatingCommandData data : entry.getValue()) {
                NBTTagCompound repeatingCommandDataCompound = new NBTTagCompound();
                repeatingCommandDataCompound.func_74778_a("entityId", entry.getKey().toString());
                repeatingCommandDataCompound.func_74778_a("command", data.command);
                repeatingCommandDataCompound.func_74768_a("frequency", data.frequency);
                repeatingCommandDataList.func_74742_a((NBTBase)repeatingCommandDataCompound);
            }
        }
        nbt.func_74782_a("repeatingCommandDataList", (NBTBase)repeatingCommandDataList);
        return nbt;
    }

    public void addRepeatingCommandData(UUID entityId, String command, int frequency) {
        this.repeatingCommandDataMap.computeIfAbsent(entityId, k -> new ArrayList()).add(new RepeatingCommandData(command, frequency));
        this.func_76185_a();
    }

    public void removeRepeatingCommandData(UUID entityId) {
        this.repeatingCommandDataMap.remove(entityId);
        this.func_76185_a();
    }

    public List<RepeatingCommandData> getRepeatingCommandData(UUID entityId) {
        return this.repeatingCommandDataMap.get(entityId);
    }

    public void removeSpecificRepeatingCommandData(UUID entityId, String command) {
        List<RepeatingCommandData> commandDataList = this.repeatingCommandDataMap.get(entityId);
        if (commandDataList != null) {
            commandDataList.removeIf(data -> data.command.equals(command));
            if (commandDataList.isEmpty()) {
                this.repeatingCommandDataMap.remove(entityId);
            }
            this.func_76185_a();
        }
    }

    public static class RepeatingCommandData {
        public final String command;
        public final int frequency;

        public RepeatingCommandData(String command, int frequency) {
            this.command = command;
            this.frequency = frequency;
        }
    }
}

