/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities.ai;

import mchorse.mclib.utils.MathUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.ArrayUtils;

public class EntitiesAIPatrol
extends EntityAIBase {
    private final EntityLiving target;
    private final double speed;
    private int timer;
    private float prevWaterFactor;
    private int index;
    private int direction = 1;
    private BlockPos[] patrolPoints;
    private boolean[] shouldCirculate;
    private String[] executeCommandOnArrival;

    public EntitiesAIPatrol(EntityLiving target, double speed, BlockPos[] patrolPoints, boolean[] shouldCirculate, String[] executeCommandOnArrival) {
        this.target = target;
        this.speed = speed;
        this.patrolPoints = patrolPoints;
        this.shouldCirculate = shouldCirculate;
        this.executeCommandOnArrival = executeCommandOnArrival;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.target.func_94060_bK();
        return target == null && this.patrolPoints.length > 0;
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.target.func_94060_bK();
        return target == null && this.patrolPoints.length > 0;
    }

    public void func_75249_e() {
        this.timer = 0;
        this.prevWaterFactor = this.target.func_184643_a(PathNodeType.WATER);
        this.target.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.target.func_70661_as().func_75499_g();
        this.target.func_184644_a(PathNodeType.WATER, this.prevWaterFactor);
        this.target.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        if (this.index < 0 || this.index >= this.patrolPoints.length) {
            return;
        }
        BlockPos pos = this.patrolPoints[this.index];
        if (this.target.func_174818_b(pos) < 2.0) {
            int next = this.index + this.direction;
            if (this.shouldCirculate[this.index]) {
                this.index = MathUtils.cycler((int)(this.index + this.direction), (int)0, (int)(this.patrolPoints.length - 1));
            } else {
                if (next < 0 || next >= this.patrolPoints.length) {
                    this.direction *= -1;
                }
                this.index += this.direction;
            }
            if (this.executeCommandOnArrival[this.index] != null) {
                this.target.func_184102_h().func_71187_D().func_71556_a((ICommandSender)this.target, this.executeCommandOnArrival[this.index]);
            }
            this.timer = 0;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.target.func_70671_ap().func_75650_a((double)x, (double)((float)y + this.target.field_70131_O), (double)z, 10.0f, (float)this.target.func_70646_bf());
        if (--this.timer <= 0) {
            this.timer = 10;
            Path path = this.target.func_70661_as().func_75488_a((double)x, (double)y, (double)z);
            if (path != null) {
                this.target.func_70661_as().func_75484_a(path, this.speed);
            }
        }
    }

    public BlockPos[] getPatrolPoints() {
        return this.patrolPoints;
    }

    public boolean[] getShouldCirculate() {
        return this.shouldCirculate;
    }

    public String[] getExecuteCommandOnArrival() {
        return this.executeCommandOnArrival;
    }

    public void addPatrolPoint(BlockPos point, boolean shouldCirculate, String executeCommandOnArrival) {
        this.patrolPoints = (BlockPos[])ArrayUtils.add((Object[])this.patrolPoints, (Object)point);
        this.shouldCirculate = ArrayUtils.add((boolean[])this.shouldCirculate, (boolean)shouldCirculate);
        this.executeCommandOnArrival = (String[])ArrayUtils.add((Object[])this.executeCommandOnArrival, (Object)executeCommandOnArrival);
    }
}

