/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptNpc;
import mchorse.mappet.entities.EntityNpc;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.util.math.BlockPos;

public class ScriptNpc
extends ScriptEntity<EntityNpc>
implements IScriptNpc {
    public ScriptNpc(EntityNpc entity) {
        super(entity);
    }

    @Override
    public EntityNpc getMappetNpc() {
        return (EntityNpc)this.entity;
    }

    @Override
    public String getNpcId() {
        return ((EntityNpc)this.entity).getId();
    }

    @Override
    public boolean setMorph(AbstractMorph morph) {
        ((EntityNpc)this.entity).getState().morph = MorphUtils.copy((AbstractMorph)morph);
        ((EntityNpc)this.entity).setMorph(((EntityNpc)this.entity).getState().morph);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
        return true;
    }

    @Override
    public String getNpcState() {
        return (String)((EntityNpc)this.entity).getState().stateName.get();
    }

    @Override
    public void setNpcState(String stateId) {
        NpcState state;
        String npcId = ((EntityNpc)this.entity).getId();
        Npc npc = (Npc)Mappet.npcs.load(npcId);
        NpcState npcState = state = npc == null ? null : npc.states.get(stateId);
        if (npc != null && state == null && npc.states.containsKey("default")) {
            state = npc.states.get("default");
        }
        if (state != null) {
            ((EntityNpc)this.entity).setNpc(npc, state);
            if (!npc.serializeNBT().func_74779_i("StateName").equals("default")) {
                ((EntityNpc)this.entity).setStringInData("StateName", stateId);
            }
        }
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public void canPickUpLoot(boolean canPickUpLoot) {
        ((EntityNpc)this.entity).func_98053_h(canPickUpLoot);
    }

    @Override
    public void follow(String target) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.follow.set((Object)target);
        ((EntityNpc)this.entity).setState(state, false);
    }

    @Override
    public String getFaction() {
        return (String)((EntityNpc)this.entity).getState().faction.get();
    }

    @Override
    public void setCanBeSteered(boolean enabled) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.canBeSteered.set((Object)enabled);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean canBeSteered() {
        return (Boolean)((EntityNpc)this.entity).getState().canBeSteered.get();
    }

    @Override
    public void setSteeringOffset(int index, float x, float y, float z) {
        NpcState state = ((EntityNpc)this.entity).getState();
        if (index < 0 || index >= state.steeringOffset.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        state.steeringOffset.set(index, new BlockPos((double)x, (double)y, (double)z));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public void addSteeringOffset(float x, float y, float z) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.steeringOffset.add(new BlockPos((double)x, (double)y, (double)z));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public List<ScriptVector> getSteeringOffsets() {
        NpcState state = ((EntityNpc)this.entity).getState();
        ArrayList<ScriptVector> steeringOffsets = new ArrayList<ScriptVector>();
        for (BlockPos pos : state.steeringOffset) {
            steeringOffsets.add(new ScriptVector(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
        return steeringOffsets;
    }

    @Override
    public void setNpcSpeed(float speed) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.speed.set((Number)Float.valueOf(speed));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public float getNpcSpeed() {
        return ((Float)((EntityNpc)this.entity).getState().speed.get()).floatValue();
    }

    @Override
    public void setJumpPower(float jumpHeight) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.jumpPower.set((Number)Float.valueOf(jumpHeight));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public float getJumpPower() {
        return ((Float)((EntityNpc)this.entity).getState().jumpPower.get()).floatValue();
    }

    @Override
    public void setInvincible(boolean invincible) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.invincible.set((Object)invincible);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean isInvincible() {
        return (Boolean)((EntityNpc)this.entity).getState().invincible.get();
    }

    @Override
    public void setCanSwim(boolean canSwim) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.canSwim.set((Object)canSwim);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean canSwim() {
        return (Boolean)((EntityNpc)this.entity).getState().canSwim.get();
    }

    @Override
    public void setImmovable(boolean immovable) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.immovable.set((Object)immovable);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean isImmovable() {
        return (Boolean)((EntityNpc)this.entity).getState().immovable.get();
    }

    @Override
    public void setShadowSize(float size) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.shadowSize.set((Number)Float.valueOf(size));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public float getShadowSize() {
        return ((Float)((EntityNpc)this.entity).getState().shadowSize.get()).floatValue();
    }

    @Override
    public float setXpValue(int xp) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.xp.set((Number)xp);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
        return xp;
    }

    @Override
    public int getXpValue() {
        return (Integer)((EntityNpc)this.entity).getState().xp.get();
    }

    @Override
    public float getPathDistance() {
        NpcState state = ((EntityNpc)this.entity).getState();
        return ((Float)state.pathDistance.get()).floatValue();
    }

    @Override
    public void setPathDistance(float sightRadius) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.pathDistance.set((Number)Float.valueOf(sightRadius));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public void setAttackRange(float sightDistance) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.sightDistance.set((Number)Float.valueOf(sightDistance));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public float getAttackRange() {
        return ((Float)((EntityNpc)this.entity).getState().sightDistance.get()).floatValue();
    }

    @Override
    public void setKillable(boolean killable) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.killable.set((Object)killable);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean isKillable() {
        return (Boolean)((EntityNpc)this.entity).getState().killable.get();
    }

    @Override
    public boolean canGetBurned() {
        return (Boolean)((EntityNpc)this.entity).getState().canGetBurned.get();
    }

    @Override
    public void canGetBurned(boolean canGetBurned) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.canGetBurned.set((Object)canGetBurned);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean canFallDamage() {
        return (Boolean)((EntityNpc)this.entity).getState().canFallDamage.get();
    }

    @Override
    public void canFallDamage(boolean canFallDamage) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.canFallDamage.set((Object)canFallDamage);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public float getDamage() {
        return ((Float)((EntityNpc)this.entity).getState().damage.get()).floatValue();
    }

    @Override
    public void setDamage(float damage) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.damage.set((Number)Float.valueOf(damage));
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public int getDamageDelay() {
        return (Integer)((EntityNpc)this.entity).getState().damageDelay.get();
    }

    @Override
    public void setDamageDelay(int damageDelay) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.damageDelay.set((Number)damageDelay);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean doesWander() {
        return (Boolean)((EntityNpc)this.entity).getState().wander.get();
    }

    @Override
    public void setWander(boolean wander) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.wander.set((Object)wander);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean doesLookAround() {
        return (Boolean)((EntityNpc)this.entity).getState().lookAround.get();
    }

    @Override
    public void setLookAround(boolean lookAround) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.lookAround.set((Object)lookAround);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public boolean doesLookAtPlayer() {
        return (Boolean)((EntityNpc)this.entity).getState().lookAtPlayer.get();
    }

    @Override
    public void setLookAtPlayer(boolean lookAtPlayer) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.lookAtPlayer.set((Object)lookAtPlayer);
        ((EntityNpc)this.entity).sendNpcStateChangePacket();
    }

    @Override
    public void clearPatrolPoints() {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.patrol.clear();
        ((EntityNpc)this.entity).setState(state, false);
    }

    @Override
    public void removePatrolPoint(int index) {
        NpcState state = ((EntityNpc)this.entity).getState();
        if (index < state.patrol.size()) {
            state.patrol.remove(index);
            state.patrolTriggers.remove(index);
        }
        ((EntityNpc)this.entity).setState(state, false);
    }

    @Override
    public void removePatrolPoint(int x, int y, int z) {
        NpcState state = ((EntityNpc)this.entity).getState();
        state.patrol.stream().filter(p -> p.func_177958_n() == x && p.func_177956_o() == y && p.func_177952_p() == z).forEach(p -> {
            int index = state.patrol.indexOf(p);
            state.patrol.remove(index);
            state.patrolTriggers.remove(index);
        });
        ((EntityNpc)this.entity).setState(state, false);
    }
}

