/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.scripts.code.ScriptFactory;
import mchorse.mappet.api.scripts.code.ScriptRayTrace;
import mchorse.mappet.api.scripts.code.blocks.ScriptBlockState;
import mchorse.mappet.api.scripts.code.blocks.ScriptTileEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptNpc;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.code.mappet.MappetSchematic;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.IScriptRayTrace;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.blocks.IScriptBlockState;
import mchorse.mappet.api.scripts.user.blocks.IScriptTileEntity;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptEntityItem;
import mchorse.mappet.api.scripts.user.entities.IScriptNpc;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptInventory;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.utils.RayTracing;
import mchorse.mappet.client.morphs.WorldMorph;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.scripts.PacketWorldMorph;
import mchorse.mappet.utils.WorldUtils;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ScriptWorld
implements IScriptWorld {
    public static final int MAX_VOLUME = 100;
    private World world;
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public ScriptWorld(World world) {
        this.world = world;
    }

    @Override
    public World getMinecraftWorld() {
        return this.world;
    }

    @Override
    public void setGameRule(String gameRule, Object value) {
        if (!(value instanceof Boolean || value instanceof String || value instanceof Integer)) {
            throw new IllegalArgumentException("Unsupported game rule value type: " + value.getClass());
        }
        this.world.func_82736_K().func_82764_b(gameRule, String.valueOf(value));
    }

    @Override
    public Object getGameRule(String gameRule) {
        if (this.world.func_82736_K().func_82765_e(gameRule)) {
            String value = this.world.func_82736_K().func_82767_a(gameRule);
            if (value.equals("true") || value.equals("false")) {
                return Boolean.valueOf(value);
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        throw new IllegalArgumentException("No such game rule: " + gameRule);
    }

    @Override
    public void setBlock(IScriptBlockState state, int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return;
        }
        this.world.func_180501_a((BlockPos)this.pos, state.getMinecraftBlockState(), 6);
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return;
        }
        this.world.func_175698_g((BlockPos)this.pos);
    }

    @Override
    public IScriptBlockState getBlock(int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return ScriptBlockState.AIR;
        }
        IBlockState blockState = this.world.func_180495_p((BlockPos)this.pos);
        return ScriptBlockState.create(blockState.func_185899_b((IBlockAccess)this.world, (BlockPos)this.pos));
    }

    @Override
    public IScriptBlockState getBlock(ScriptVector pos) {
        return this.getBlock((int)pos.x, (int)pos.y, (int)pos.z);
    }

    @Override
    public boolean hasTileEntity(int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return false;
        }
        return this.world.func_175625_s((BlockPos)this.pos) != null;
    }

    public void replaceBlocks(IScriptBlockState blockToBeReplaced, IScriptBlockState newBlock, Vector3d pos, int radius) {
        this.processBlocksInRegion(pos, radius, (int x, int y, int z) -> {
            IScriptBlockState currentBlock = this.getBlock(x, y, z);
            if (currentBlock.isSame(blockToBeReplaced)) {
                this.setBlock(newBlock, x, y, z);
            }
        });
    }

    public void replaceBlocks(IScriptBlockState blockToBeReplaced, IScriptBlockState newBlock, INBTCompound tileData, Vector3d pos, int radius) {
        this.processBlocksInRegion(pos, radius, (int x, int y, int z) -> {
            IScriptBlockState currentBlock = this.getBlock(x, y, z);
            if (currentBlock.isSame(blockToBeReplaced)) {
                this.setTileEntity(x, y, z, newBlock, tileData);
            }
        });
    }

    private void processBlocksInRegion(Vector3d pos, int radius, BlockPosConsumer consumer) {
        int minX = (int)Math.floor(pos.x - (double)radius);
        int maxX = (int)Math.ceil(pos.x + (double)radius);
        int minY = (int)Math.floor(pos.y - (double)radius);
        int maxY = (int)Math.ceil(pos.y + (double)radius);
        int minZ = (int)Math.floor(pos.z - (double)radius);
        int maxZ = (int)Math.ceil(pos.z + (double)radius);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double dz;
                    double dy;
                    double dx;
                    double distanceSquared;
                    if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z)) || !((distanceSquared = (dx = pos.x - ((double)x + 0.5)) * dx + (dy = pos.y - ((double)y + 0.5)) * dy + (dz = pos.z - ((double)z + 0.5)) * dz) <= (double)(radius * radius))) continue;
                    consumer.accept(x, y, z);
                }
            }
        }
    }

    @Override
    public void replaceBlocks(IScriptBlockState blockToBeReplaced, IScriptBlockState newBlock, Vector3d pos1, Vector3d pos2) {
        this.processBlocksInRegion(pos1, pos2, (int x, int y, int z) -> {
            IScriptBlockState currentBlock = this.getBlock(x, y, z);
            if (currentBlock.isSame(blockToBeReplaced)) {
                this.setBlock(newBlock, x, y, z);
            }
        });
    }

    @Override
    public void replaceBlocks(IScriptBlockState blockToBeReplaced, IScriptBlockState newBlock, INBTCompound tileData, Vector3d pos1, Vector3d pos2) {
        this.processBlocksInRegion(pos1, pos2, (int x, int y, int z) -> {
            IScriptBlockState currentBlock = this.getBlock(x, y, z);
            if (currentBlock.isSame(blockToBeReplaced)) {
                this.setTileEntity(x, y, z, newBlock, tileData);
            }
        });
    }

    private void processBlocksInRegion(Vector3d pos1, Vector3d pos2, BlockPosConsumer consumer) {
        int x = (int)Math.min(pos1.x, pos2.x);
        while ((double)x <= Math.max(pos1.x, pos2.x)) {
            int y = (int)Math.min(pos1.y, pos2.y);
            while ((double)y <= Math.max(pos1.y, pos2.y)) {
                int z = (int)Math.min(pos1.z, pos2.z);
                while ((double)z <= Math.max(pos1.z, pos2.z)) {
                    if (this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
                        consumer.accept(x, y, z);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public IScriptTileEntity getTileEntity(int x, int y, int z) {
        if (!this.hasTileEntity(x, y, z)) {
            return null;
        }
        return new ScriptTileEntity(this.world.func_175625_s((BlockPos)this.pos.func_181079_c(x, y, z)));
    }

    @Override
    public boolean hasInventory(int x, int y, int z) {
        this.pos.func_181079_c(x, y, z);
        return this.world.func_175667_e((BlockPos)this.pos) && this.world.func_175625_s((BlockPos)this.pos) instanceof IInventory;
    }

    @Override
    public IScriptInventory getInventory(int x, int y, int z) {
        TileEntity tile;
        if (this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z)) && (tile = this.world.func_175625_s((BlockPos)this.pos)) instanceof IInventory) {
            return new ScriptInventory((IInventory)tile);
        }
        return null;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean raining) {
        this.world.func_72912_H().func_76084_b(raining);
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public int getDimensionId() {
        Integer[] ids;
        Integer[] integerArray = ids = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int id = integerArray[i];
            WorldServer world = this.world.func_73046_m().func_71218_a(id);
            if (world != this.world) continue;
            return id;
        }
        return 0;
    }

    @Override
    public void spawnParticles(EnumParticleTypes type, boolean longDistance, double x, double y, double z, int n, double dx, double dy, double dz, double speed, int ... args) {
        ((WorldServer)this.world).func_180505_a(type, longDistance, x, y, z, n, dx, dy, dz, speed, args);
    }

    @Override
    public void spawnParticles(IScriptPlayer entity, EnumParticleTypes type, boolean longDistance, double x, double y, double z, int n, double dx, double dy, double dz, double speed, int ... args) {
        if (entity == null) {
            return;
        }
        ((WorldServer)this.world).func_184161_a(entity.getMinecraftPlayer(), type, longDistance, x, y, z, n, dx, dy, dz, speed, args);
    }

    @Override
    public IScriptEntity spawnEntity(String id, double x, double y, double z, INBTCompound compound) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_189532_c(x, y, z))) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (compound != null) {
            tag.func_179237_a(compound.getNBTTagCompound());
        }
        tag.func_74778_a("id", id);
        Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)tag, (World)this.world, (double)x, (double)y, (double)z, (boolean)true);
        return entity == null ? null : ScriptEntity.create(entity);
    }

    @Override
    public IScriptNpc spawnNpc(String id, String state, double x, double y, double z) {
        Npc npc = (Npc)Mappet.npcs.load(id);
        if (npc == null) {
            return null;
        }
        NpcState npcState = npc.states.get(state);
        if (npcState == null) {
            return null;
        }
        EntityNpc entity = new EntityNpc(this.world);
        entity.func_70107_b(x, y, z);
        entity.setNpc(npc, npcState);
        entity.field_70170_p.func_72838_d((Entity)entity);
        entity.initialize();
        if (!npc.serializeNBT().func_74779_i("StateName").equals("default")) {
            entity.setStringInData("StateName", state);
        }
        return new ScriptNpc(entity);
    }

    @Override
    public IScriptNpc spawnNpc(String id, String state, double x, double y, double z, float yaw, float pitch, float headYaw) {
        Npc npc = (Npc)Mappet.npcs.load(id);
        if (npc == null) {
            return null;
        }
        NpcState npcState = npc.states.get(state);
        if (npcState == null) {
            return null;
        }
        EntityNpc entity = new EntityNpc(this.world);
        entity.func_70080_a(x, y, z, yaw, pitch);
        entity.func_70034_d(headYaw);
        entity.setNpc(npc, npcState);
        entity.field_70170_p.func_72838_d((Entity)entity);
        entity.initialize();
        if (!npc.serializeNBT().func_74779_i("StateName").equals("default")) {
            entity.setStringInData("StateName", state);
        }
        return new ScriptNpc(entity);
    }

    @Override
    public List<IScriptEntity> getEntities(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.getEntities(x1, y1, z1, x2, y2, z2, false);
    }

    @Override
    public List<IScriptEntity> getEntities(double x1, double y1, double z1, double x2, double y2, double z2, boolean ignoreVolumeLimit) {
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double maxZ = Math.max(z1, z2);
        if (!ignoreVolumeLimit && (maxX - minX > 100.0 || maxY - minY > 100.0 || maxZ - minZ > 100.0)) {
            return entities;
        }
        int minChunkX = (int)minX >> 4;
        int minChunkZ = (int)minZ >> 4;
        int maxChunkX = (int)maxX >> 4;
        int maxChunkZ = (int)maxZ >> 4;
        Predicate filter = entity -> entity != null;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (!this.world.func_190526_b(chunkX, chunkZ)) continue;
                Chunk chunk = this.world.func_72964_e(chunkX, chunkZ);
                AxisAlignedBB chunkAABB = new AxisAlignedBB(Math.max((double)chunk.func_76632_l().func_180334_c(), minX), minY, Math.max((double)chunk.func_76632_l().func_180333_d(), minZ), Math.min((double)chunk.func_76632_l().func_180332_e(), maxX), maxY, Math.min((double)chunk.func_76632_l().func_180330_f(), maxZ));
                ArrayList chunkEntities = new ArrayList();
                chunk.func_177414_a(null, chunkAABB, chunkEntities, filter);
                for (Entity entity2 : chunkEntities) {
                    entities.add(ScriptEntity.create(entity2));
                }
            }
        }
        return entities;
    }

    @Override
    public List<IScriptEntity> getEntities(double x, double y, double z, double radius) {
        radius = Math.abs(radius);
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        if (radius > 50.0) {
            return entities;
        }
        double minX = x - radius;
        double minY = y - radius;
        double minZ = z - radius;
        double maxX = x + radius;
        double maxY = y + radius;
        double maxZ = z + radius;
        if (!this.world.func_175667_e((BlockPos)this.pos.func_189532_c(minX, minY, minZ)) || !this.world.func_175667_e((BlockPos)this.pos.func_189532_c(maxX, maxY, maxZ))) {
            return entities;
        }
        for (Entity entity : this.world.func_72872_a(Entity.class, new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ))) {
            AxisAlignedBB box = entity.func_174813_aQ();
            double eX = (box.field_72340_a + box.field_72336_d) / 2.0;
            double dX = x - eX;
            double eY = (box.field_72338_b + box.field_72337_e) / 2.0;
            double dY = y - eY;
            double eZ = (box.field_72339_c + box.field_72334_f) / 2.0;
            double dZ = z - eZ;
            if (!(dX * dX + dY * dY + dZ * dZ < radius * radius)) continue;
            entities.add(ScriptEntity.create(entity));
        }
        return entities;
    }

    @Override
    public void playSound(String event, double x, double y, double z, float volume, float pitch) {
        for (EntityPlayerMP player : this.world.func_73046_m().func_184103_al().func_181057_v()) {
            WorldUtils.playSound(player, event, x, y, z, volume, pitch);
        }
    }

    @Override
    public void stopSound(String event, String category) {
        PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
        packetbuffer.func_180714_a(category);
        packetbuffer.func_180714_a(event);
        for (EntityPlayerMP player : this.world.func_73046_m().func_184103_al().func_181057_v()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketCustomPayload("MC|StopSound", packetbuffer));
        }
    }

    @Override
    public IScriptEntityItem dropItemStack(IScriptItemStack stack, double x, double y, double z, double mx, double my, double mz) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        EntityItem item = new EntityItem(this.world, x, y, z, stack.getMinecraftItemStack().func_77946_l());
        item.field_70159_w = mx;
        item.field_70181_x = my;
        item.field_70179_y = mz;
        this.world.func_72838_d((Entity)item);
        return (IScriptEntityItem)ScriptEntity.create((Entity)item);
    }

    @Override
    public void explode(IScriptEntity exploder, double x, double y, double z, float distance, boolean blazeGround, boolean destroyTerrain) {
        this.world.func_72885_a(exploder == null ? null : exploder.getMinecraftEntity(), x, y, z, distance, blazeGround, destroyTerrain);
    }

    @Override
    public IScriptRayTrace rayTrace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ScriptRayTrace(RayTracing.rayTraceWithEntity(this.world, x1, y1, z1, x2, y2, z2));
    }

    @Override
    public IScriptRayTrace rayTraceBlock(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new ScriptRayTrace(RayTracing.rayTrace(this.world, x1, y1, z1, x2, y2, z2));
    }

    @Override
    public boolean isActive(int x, int y, int z) {
        return this.world.func_175651_c(new BlockPos(x, y, z), EnumFacing.UP) > 0;
    }

    @Override
    public boolean testForBlock(int x, int y, int z, String blockId, int meta) {
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        ImmutableList validStates = value.func_176194_O().func_177619_a();
        IBlockState state = meta >= 0 && meta < validStates.size() ? (IBlockState)validStates.get(meta) : value.func_176223_P();
        return this.getBlock(x, y, z).isSame(ScriptBlockState.create(state));
    }

    @Override
    public void fill(IScriptBlockState state, int x1, int y1, int z1, int x2, int y2, int z2) {
        int xMin = Math.min(x1, x2);
        int xMax = Math.max(x1, x2);
        int yMin = Math.min(y1, y2);
        int yMax = Math.max(y1, y2);
        int zMin = Math.min(z1, z2);
        int zMax = Math.max(z1, z2);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.setBlock(state, x, y, z);
                }
            }
        }
    }

    @Override
    public IScriptEntity summonFallingBlock(double x, double y, double z, String blockId, int meta) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Block", blockId);
        nbt.func_74768_a("Data", meta);
        nbt.func_74768_a("Time", 1);
        return this.spawnEntity("minecraft:falling_block", x, y, z, new ScriptNBTCompound(nbt));
    }

    @Override
    public IScriptEntity setFallingBlock(int x, int y, int z) {
        IScriptBlockState state = this.getBlock(x, y, z);
        if (state.isAir()) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Block", state.getBlockId());
        nbt.func_74768_a("Data", state.getMeta());
        nbt.func_74768_a("Time", 1);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(state.getBlockId()));
        if (block != null) {
            IBlockState blockState = block.func_176203_a(state.getMeta());
            for (IProperty property : blockState.func_177228_b().keySet()) {
                nbt.func_74778_a(property.func_177701_a(), blockState.func_177229_b(property).toString());
            }
        }
        if (this.hasTileEntity(x, y, z)) {
            nbt.func_74782_a("TileEntityData", (NBTBase)this.getTileEntity(x, y, z).getData().getNBTTagCompound());
        }
        this.world.func_175713_t((BlockPos)this.pos.func_181079_c(x, y, z));
        this.world.func_180501_a((BlockPos)this.pos.func_181079_c(x, y, z), Blocks.field_150350_a.func_176223_P(), 3);
        return this.spawnEntity("minecraft:falling_block", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ScriptNBTCompound(nbt));
    }

    @Override
    public void setTileEntity(int x, int y, int z, IScriptBlockState blockState, INBTCompound tileData) {
        this.setBlock(blockState, x, y, z);
        tileData.setInt("x", x);
        tileData.setInt("y", y);
        tileData.setInt("z", z);
        this.getTileEntity(x, y, z).setData(tileData);
    }

    @Override
    public void fillTileEntities(int x1, int y1, int z1, int x2, int y2, int z2, IScriptBlockState blockState, INBTCompound tileData) {
        int xMin = Math.min(x1, x2);
        int xMax = Math.max(x1, x2);
        int yMin = Math.min(y1, y2);
        int yMax = Math.max(y1, y2);
        int zMin = Math.min(z1, z2);
        int zMax = Math.max(z1, z2);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.setTileEntity(x, y, z, blockState, tileData);
                }
            }
        }
    }

    @Override
    public void clone(int x, int y, int z, int xNew, int yNew, int zNew) {
        IScriptBlockState state = this.getBlock(x, y, z);
        if (!state.getBlockId().equals("minecraft:air")) {
            this.setBlock(state, xNew, yNew, zNew);
            if (this.getTileEntity(x, y, z) != null) {
                INBTCompound tile = this.getTileEntity(x, y, z).getData();
                tile.setInt("x", xNew);
                tile.setInt("y", yNew);
                tile.setInt("z", zNew);
                this.setBlock(state, x, y, z);
                this.getTileEntity(xNew, yNew, zNew).setData(tile);
            }
        }
    }

    @Override
    public void clone(int x1, int y1, int z1, int x2, int y2, int z2, int xNew, int yNew, int zNew) {
        int xMin = Math.min(x1, x2);
        int xMax = Math.max(x1, x2);
        int yMin = Math.min(y1, y2);
        int yMax = Math.max(y1, y2);
        int zMin = Math.min(z1, z2);
        int zMax = Math.max(z1, z2);
        int xCentre = (xMin + xMax) / 2;
        int yCentre = (yMin + yMax) / 2;
        int zCentre = (zMin + zMax) / 2;
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.clone(x, y, z, xNew + x - xCentre, yNew + y - yCentre, zNew + z - zCentre);
                }
            }
        }
    }

    @Override
    public IScriptItemStack getBlockStackWithTile(int x, int y, int z) {
        TileEntity tileEntity;
        ItemStack itemStack;
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return ScriptItemStack.EMPTY;
        }
        IBlockState blockState = this.world.func_180495_p((BlockPos)this.pos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return ScriptItemStack.EMPTY;
        }
        Item itemFromBlock = Item.func_150898_a((Block)block);
        if (itemFromBlock == Items.field_190931_a) {
            RayTraceResult rayTraceResult = new RayTraceResult(new Vec3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), EnumFacing.UP, (BlockPos)this.pos);
            itemStack = block.getPickBlock(blockState, rayTraceResult, this.world, (BlockPos)this.pos, null);
            if (itemStack.func_190926_b()) {
                return ScriptItemStack.EMPTY;
            }
        } else {
            itemStack = new ItemStack(itemFromBlock, 1, block.func_176201_c(blockState));
        }
        if ((tileEntity = this.world.func_175625_s((BlockPos)this.pos)) != null) {
            NBTTagCompound tileEntityNBT = new NBTTagCompound();
            tileEntity.func_189515_b(tileEntityNBT);
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.func_74782_a("BlockEntityTag", (NBTBase)tileEntityNBT);
            itemStack.func_77982_d(itemStackNBT);
        }
        return ScriptItemStack.create(itemStack);
    }

    @Override
    public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, float yaw, float pitch, int range, IScriptPlayer player) {
        if (morph == null) {
            return;
        }
        WorldMorph worldMorph = new WorldMorph();
        worldMorph.morph = morph;
        worldMorph.expiration = expiration;
        worldMorph.x = x;
        worldMorph.y = y;
        worldMorph.z = z;
        worldMorph.yaw = yaw;
        worldMorph.pitch = pitch;
        int dimension = this.world.field_73011_w.getDimension();
        if (player == null) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dimension, x, y, z, (double)MathUtils.clamp((int)range, (int)1, (int)256));
            Dispatcher.DISPATCHER.get().sendToAllAround((IMessage)new PacketWorldMorph(worldMorph), point);
        } else {
            Dispatcher.sendTo(new PacketWorldMorph(worldMorph), player.getMinecraftPlayer());
        }
    }

    @Override
    public MappetSchematic createSchematic() {
        return MappetSchematic.create(this);
    }

    @Override
    public IScriptEntity shootBBGunProjectile(IScriptEntity shooter, double x, double y, double z, double yaw, double pitch, String gunPropsNbtString) {
        if (shooter.getMinecraftEntity() instanceof EntityLivingBase && Loader.isModLoaded((String)"blockbuster")) {
            try {
                return this.shootBBGunProjectileMethod(shooter, x, y, z, yaw, pitch, gunPropsNbtString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Optional.Method(modid="blockbuster")
    private IScriptEntity shootBBGunProjectileMethod(IScriptEntity shooter, double x, double y, double z, double yaw, double pitch, String gunPropsNbtString) throws NBTException {
        ScriptFactory factory = new ScriptFactory();
        EntityLivingBase entityLivingBase = (EntityLivingBase)shooter.getMinecraftEntity();
        GunProps gunProps = new GunProps(factory.createCompound(gunPropsNbtString).getCompound("Gun").getCompound("Projectile").getNBTTagCompound());
        gunProps.fromNBT(factory.createCompound(gunPropsNbtString).getCompound("Gun").getNBTTagCompound());
        EntityGunProjectile projectile = new EntityGunProjectile(entityLivingBase.field_70170_p, gunProps, gunProps.projectileMorph);
        projectile.func_70107_b(x, y, z);
        projectile.func_184538_a((Entity)entityLivingBase, (float)pitch, (float)yaw, 0.0f, gunProps.speed, 0.0f);
        projectile.setInitialMotion();
        entityLivingBase.field_70170_p.func_72838_d((Entity)projectile);
        IScriptEntity spawnedEntity = ScriptEntity.create((Entity)projectile);
        return spawnedEntity;
    }

    @FunctionalInterface
    private static interface BlockPosConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

