/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.code.blocks.ScriptBlockState;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.code.mappet.MappetUIBuilder;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTList;
import mchorse.mappet.api.scripts.user.IScriptFactory;
import mchorse.mappet.api.scripts.user.blocks.IScriptBlockState;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIBuilder;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.scripts.user.nbt.INBTList;
import mchorse.mappet.api.ui.UI;
import mchorse.mappet.api.utils.logs.MappetLogger;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ScriptFactory
implements IScriptFactory {
    private static final Map<String, String> formattingCodes = new HashMap<String, String>();
    private Random random = new Random();

    @Override
    public IScriptBlockState createBlockState(String blockId, int meta) {
        ResourceLocation location = new ResourceLocation(blockId);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            IBlockState state = block.func_176203_a(meta);
            return ScriptBlockState.create(state);
        }
        return ScriptBlockState.create(null);
    }

    @Override
    public IScriptBlockState createBlockState(String blockId) {
        return this.createBlockState(blockId, 0);
    }

    @Override
    public INBTCompound createCompound(String nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        if (nbt != null) {
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptNBTCompound(tag);
    }

    @Override
    public INBTCompound createCompoundFromJS(Object jsObject) {
        NBTBase base = this.convertToNBT(jsObject);
        return base instanceof NBTTagCompound ? new ScriptNBTCompound((NBTTagCompound)base) : null;
    }

    @Override
    public INBTList createList(String nbt) {
        NBTTagList list = new NBTTagList();
        if (nbt != null) {
            try {
                list = (NBTTagList)JsonToNBT.func_180713_a((String)("{List:" + nbt + "}")).func_74781_a("List");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptNBTList(list);
    }

    @Override
    public INBTList createListFromJS(Object jsObject) {
        NBTBase base = this.convertToNBT(jsObject);
        return base instanceof NBTTagList ? new ScriptNBTList((NBTTagList)base) : null;
    }

    private NBTBase convertToNBT(Object object) {
        if (object instanceof String) {
            return new NBTTagString((String)object);
        }
        if (object instanceof Double) {
            return new NBTTagDouble(((Double)object).doubleValue());
        }
        if (object instanceof Integer) {
            return new NBTTagInt(((Integer)object).intValue());
        }
        if (object instanceof Boolean) {
            return new NBTTagByte(((Boolean)object != false ? Byte.valueOf("1") : Byte.valueOf("0")).byteValue());
        }
        if (object instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)object;
            if (mirror.isArray()) {
                NBTTagList list = new NBTTagList();
                int c = mirror.size();
                for (int i = 0; i < c; ++i) {
                    NBTBase base = this.convertToNBT(mirror.getSlot(i));
                    if (base == null) continue;
                    list.func_74742_a(base);
                }
                return list;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (String key : mirror.keySet()) {
                NBTBase base = this.convertToNBT(mirror.get((Object)key));
                if (base == null) continue;
                tag.func_74782_a(key, base);
            }
            return tag;
        }
        return null;
    }

    @Override
    public IScriptItemStack createItem(INBTCompound compound) {
        if (compound != null) {
            return ScriptItemStack.create(new ItemStack(compound.getNBTTagCompound()));
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public IScriptItemStack createItem(String itemId, int count, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        return ScriptItemStack.create(new ItemStack(item, count, meta));
    }

    @Override
    public IScriptItemStack createBlockItem(String blockId, int count, int meta) {
        Block item = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        return ScriptItemStack.create(new ItemStack(item, count, meta));
    }

    @Override
    public EnumParticleTypes getParticleType(String type) {
        return EnumParticleTypes.func_186831_a((String)type);
    }

    @Override
    public Potion getPotion(String type) {
        return Potion.func_180142_b((String)type);
    }

    @Override
    public AbstractMorph createMorph(INBTCompound compound) {
        if (compound == null) {
            return null;
        }
        return MorphManager.INSTANCE.morphFromNBT(compound.getNBTTagCompound());
    }

    @Override
    public IMappetUIBuilder createUI(String script, String function) {
        script = script == null ? "" : script;
        function = function == null ? "" : function;
        return new MappetUIBuilder(new UI(), script, function);
    }

    @Override
    public Object get(String key) {
        return Mappet.scripts.objects.get(key);
    }

    @Override
    public void set(String key, Object object) {
        Mappet.scripts.objects.put(key, object);
    }

    @Override
    public String dump(Object object, boolean simple) {
        if (object instanceof ScriptObjectMirror) {
            return object.toString();
        }
        Class<?> clazz = object.getClass();
        StringBuilder output = new StringBuilder(simple ? clazz.getSimpleName() : clazz.getTypeName());
        output.append(" {\n");
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            output.append("    ");
            if (!simple) {
                output.append(this.getModifier(field.getModifiers()));
            }
            output.append(field.getName());
            if (!simple) {
                output.append(" (");
                output.append(simple ? field.getType().getSimpleName() : field.getType().getTypeName());
                output.append(")");
            }
            String value = "";
            try {
                field.setAccessible(true);
                Object o = field.get(object);
                value = o == null ? "null" : o.toString();
            }
            catch (Exception o) {
                // empty catch block
            }
            output.append(": ").append(value).append("\n");
        }
        output.append("\n");
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            output.append("    ");
            if (!simple) {
                output.append(this.getModifier(((Method)accessibleObject).getModifiers()));
            }
            output.append(simple ? ((Method)accessibleObject).getReturnType().getSimpleName() : ((Method)accessibleObject).getReturnType().getTypeName());
            output.append(" ");
            output.append(((Method)accessibleObject).getName()).append("(");
            int size = ((Method)accessibleObject).getParameterCount();
            for (int i = 0; i < size; ++i) {
                Class<?> arg = ((Method)accessibleObject).getParameterTypes()[i];
                output.append(simple ? arg.getSimpleName() : arg.getTypeName());
                if (i >= size - 1) continue;
                output.append(", ");
            }
            output.append(")").append("\n");
        }
        output.append("}");
        return output.toString();
    }

    private String getModifier(int m) {
        String modifier;
        String string = modifier = Modifier.isFinal(m) ? "final " : "";
        if (Modifier.isPublic(m)) {
            modifier = modifier + "public ";
        } else if (Modifier.isProtected(m)) {
            modifier = modifier + "protected ";
        } else if (Modifier.isPrivate(m)) {
            modifier = modifier + "private ";
        }
        return modifier;
    }

    @Override
    public double random(double max) {
        return Math.random() * max;
    }

    @Override
    public double random(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    public double random(double min, double max, long seed) {
        this.random.setSeed(seed);
        return min + this.random.nextDouble() * (max - min);
    }

    @Override
    public String style(String ... styles) {
        StringBuilder builder = new StringBuilder();
        for (String style : styles) {
            String code = formattingCodes.get(style);
            if (code == null) continue;
            builder.append('\u00a7');
            builder.append(code);
        }
        return builder.toString();
    }

    @Override
    public boolean isPointInBounds(Object point, Object bound1, Object bound2) {
        if (point instanceof Vector2d) {
            return this.isPointInBounds2D((Vector2d)point, (Vector2d)bound1, (Vector2d)bound2);
        }
        if (point instanceof Vector3d) {
            return this.isPointInBounds3D((Vector3d)point, (Vector3d)bound1, (Vector3d)bound2);
        }
        if (point instanceof Vector4d) {
            return this.isPointInBounds4D((Vector4d)point, (Vector4d)bound1, (Vector4d)bound2);
        }
        throw new IllegalArgumentException("Invalid vector type: " + point.getClass().getName());
    }

    private boolean isPointInBounds2D(Vector2d point, Vector2d bound1, Vector2d bound2) {
        return point.x >= Math.min(bound1.x, bound2.x) && point.x <= Math.max(bound1.x, bound2.x) && point.y >= Math.min(bound1.y, bound2.y) && point.y <= Math.max(bound1.y, bound2.y);
    }

    private boolean isPointInBounds3D(Vector3d point, Vector3d bound1, Vector3d bound2) {
        return point.field_181059_a >= Math.min(bound1.field_181059_a, bound2.field_181059_a) && point.field_181059_a <= Math.max(bound1.field_181059_a, bound2.field_181059_a) && point.field_181060_b >= Math.min(bound1.field_181060_b, bound2.field_181060_b) && point.field_181060_b <= Math.max(bound1.field_181060_b, bound2.field_181060_b) && point.field_181061_c >= Math.min(bound1.field_181061_c, bound2.field_181061_c) && point.field_181061_c <= Math.max(bound1.field_181061_c, bound2.field_181061_c);
    }

    private boolean isPointInBounds4D(Vector4d point, Vector4d bound1, Vector4d bound2) {
        return point.x >= Math.min(bound1.x, bound2.x) && point.x <= Math.max(bound1.x, bound2.x) && point.y >= Math.min(bound1.y, bound2.y) && point.y <= Math.max(bound1.y, bound2.y) && point.z >= Math.min(bound1.z, bound2.z) && point.z <= Math.max(bound1.z, bound2.z) && point.w >= Math.min(bound1.w, bound2.w) && point.w <= Math.max(bound1.w, bound2.w);
    }

    @Override
    public INBTCompound toNBT(Object object) {
        if (object instanceof INBTCompound) {
            return (INBTCompound)object;
        }
        if (object instanceof NBTTagCompound) {
            return new ScriptNBTCompound((NBTTagCompound)object);
        }
        if (object instanceof AbstractMorph) {
            return new ScriptNBTCompound(((AbstractMorph)object).toNBT());
        }
        return null;
    }

    @Override
    public MappetLogger getLogger() {
        return Mappet.logger;
    }

    @Override
    public IScriptEntity getMappetEntity(Entity minecraftEntity) {
        return ScriptEntity.create(minecraftEntity);
    }

    @Override
    public String format(String format, Object ... args) {
        return String.format(format, args);
    }

    static {
        formattingCodes.put("black", "0");
        formattingCodes.put("dark_blue", "1");
        formattingCodes.put("dark_green", "2");
        formattingCodes.put("dark_aqua", "3");
        formattingCodes.put("dark_red", "4");
        formattingCodes.put("dark_purple", "5");
        formattingCodes.put("gold", "6");
        formattingCodes.put("gray", "7");
        formattingCodes.put("dark_gray", "8");
        formattingCodes.put("blue", "9");
        formattingCodes.put("green", "a");
        formattingCodes.put("aqua", "b");
        formattingCodes.put("red", "c");
        formattingCodes.put("light_purple", "d");
        formattingCodes.put("yellow", "e");
        formattingCodes.put("white", "f");
        formattingCodes.put("obfuscated", "k");
        formattingCodes.put("bold", "l");
        formattingCodes.put("strikethrough", "m");
        formattingCodes.put("underline", "n");
        formattingCodes.put("italic", "o");
        formattingCodes.put("reset", "r");
    }
}

