/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.schematics;

import java.io.File;
import java.io.IOException;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.schematics.Schematic;
import mchorse.mappet.api.utils.manager.BaseManager;
import mchorse.mappet.api.utils.manager.ManagerCache;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicManager
extends BaseManager<Schematic> {
    public SchematicManager(File folder) {
        super(folder);
    }

    @Override
    protected Schematic createData(String id, NBTTagCompound tag) {
        Schematic schematic = new Schematic(0, 0, 0);
        schematic.deserializeNBT(tag);
        return schematic;
    }

    @Override
    public boolean save(String id, Schematic data) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)data.serializeNBT(), (File)this.getFile(id));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected NBTTagCompound getCached(String id) throws Exception {
        ManagerCache cache;
        NBTTagCompound tag = null;
        File file = this.getFile(id);
        boolean isCaching = (Boolean)Mappet.generalDataCaching.get();
        long lastUpdated = file.lastModified();
        if (isCaching && (cache = (ManagerCache)this.cache.get(id)) != null) {
            if (cache.lastUpdated < lastUpdated) {
                this.cache.remove(id);
            } else {
                tag = cache.tag;
                cache.update();
            }
            this.doExpirationCheck();
        }
        if (tag == null) {
            tag = CompressedStreamTools.func_74797_a((File)file);
            if (isCaching) {
                this.cache.put(id, new ManagerCache(tag, lastUpdated));
            }
        }
        return tag;
    }

    @Override
    protected String getExtension() {
        return ".schematic";
    }
}

