/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.schematics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mchorse.mappet.api.utils.AbstractData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Schematic
extends AbstractData {
    private IBlockState[][][] blockStates;
    private byte[][][] metadata;
    private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
    private final List<Entity> entities = new ArrayList<Entity>();
    private int width;
    private int height;
    private int length;

    public Schematic() {
        this(1, 1, 1);
    }

    public Schematic(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.init();
    }

    public void init() {
        this.blockStates = new IBlockState[this.width][this.height][this.length];
        this.tileEntities.clear();
        this.entities.clear();
    }

    public boolean setBlockState(BlockPos pos, IBlockState blockState) {
        if (this.isInvalid(pos)) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.blockStates[x][y][z] = blockState;
        return true;
    }

    public IBlockState getBlockState(BlockPos pos) {
        if (this.isInvalid(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return this.blockStates[x][y][z];
    }

    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
        if (this.isInvalid(pos)) {
            return;
        }
        this.removeTileEntity(pos);
        if (tileEntity != null) {
            this.tileEntities.add(tileEntity);
        }
    }

    public TileEntity getTileEntity(BlockPos pos) {
        for (TileEntity tileEntity : this.tileEntities) {
            if (!tileEntity.func_174877_v().equals((Object)pos)) continue;
            return tileEntity;
        }
        return null;
    }

    public void removeTileEntity(BlockPos pos) {
        this.tileEntities.removeIf(tileEntity -> tileEntity.func_174877_v().equals((Object)pos));
    }

    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    private boolean isInvalid(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length;
    }

    public void loadFromWorld(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        this.width = maxX - minX + 1;
        this.height = maxY - minY + 1;
        this.length = maxZ - minZ + 1;
        this.init();
        this.copyBlocks(world, minX, minY, minZ);
        this.copyEntities(world, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void place(World world, int x, int y, int z, boolean replaceBlocks, boolean placeAir) {
        for (int localX = 0; localX < this.width; ++localX) {
            for (int localY = 0; localY < this.height; ++localY) {
                for (int localZ = 0; localZ < this.length; ++localZ) {
                    BlockPos blockPos = new BlockPos(x + localX, y + localY, z + localZ);
                    BlockPos localPos = new BlockPos(localX, localY, localZ);
                    IBlockState blockState = this.getBlockState(localPos);
                    if (!replaceBlocks && !world.func_175623_d(blockPos) || !placeAir && blockState.equals(Blocks.field_150350_a.func_176223_P())) continue;
                    world.func_175656_a(blockPos, blockState);
                    TileEntity tileEntity = world.func_175625_s(blockPos);
                    if (tileEntity == null) continue;
                    tileEntity.deserializeNBT(this.getTileEntity(localPos).serializeNBT());
                }
            }
        }
        world.func_175650_b(this.entities);
        for (Entity entity : this.entities) {
            entity.func_184221_a(UUID.randomUUID());
            world.func_72838_d(entity);
        }
    }

    private void copyBlocks(World world, int minX, int minY, int minZ) {
        this.init();
        for (int localX = 0; localX <= this.width; ++localX) {
            for (int localY = 0; localY <= this.height; ++localY) {
                for (int localZ = 0; localZ <= this.length; ++localZ) {
                    BlockPos blockPos = new BlockPos(minX + localX, minY + localY, minZ + localZ);
                    BlockPos localPos = new BlockPos(localX, localY, localZ);
                    IBlockState blockState = world.func_180495_p(blockPos);
                    Block block = blockState.func_177230_c();
                    boolean success = this.setBlockState(localPos, blockState);
                    if (!success || !block.hasTileEntity(blockState)) continue;
                    this.copyTileEntity(world, blockPos, localPos);
                }
            }
        }
    }

    private void copyEntities(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        List entityList = world.func_72872_a(Entity.class, axisAlignedBB).stream().filter(entity -> !(entity instanceof EntityPlayer)).collect(Collectors.toList());
        this.entities.clear();
        for (Entity entity2 : entityList) {
            this.addEntity(entity2);
        }
    }

    private void copyTileEntity(World world, BlockPos blockPos, BlockPos localPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return;
        }
        try {
            this.setTileEntity(localPos, tileEntity);
        }
        catch (Exception exception) {
            this.setBlockState(localPos, Blocks.field_150357_h.func_176223_P());
        }
    }

    public void addEntity(Entity entity) {
        if (entity == null || entity instanceof EntityPlayer) {
            return;
        }
        for (Entity e : this.entities) {
            if (!entity.func_110124_au().equals(e.func_110124_au())) continue;
            return;
        }
        this.entities.add(entity);
    }

    public void removeEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        this.entities.removeIf(e -> entity.func_110124_au().equals(e.func_110124_au()));
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("Width", (short)this.width);
        tag.func_74777_a("Height", (short)this.height);
        tag.func_74777_a("Length", (short)this.length);
        int size = this.width * this.length * this.height;
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        HashMap<String, Short> mappings = new HashMap<String, Short>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    String name;
                    int index = x + (y * this.length + z) * this.width;
                    IBlockState blockState = this.getBlockState(new BlockPos(x, y, z));
                    Block block = blockState.func_177230_c();
                    int blockId = Block.field_149771_c.func_148757_b((Object)block);
                    localBlocks[index] = (byte)blockId;
                    localMetadata[index] = (byte)block.func_176201_c(blockState);
                    extraBlocks[index] = (byte)(blockId >> 8);
                    if (extraBlocks[index] > 0) {
                        extra = true;
                    }
                    if (mappings.containsKey(name = String.valueOf(Block.field_149771_c.func_177774_c((Object)block)))) continue;
                    mappings.put(name, (short)blockId);
                }
            }
        }
        NBTTagList tileEntitiesList = new NBTTagList();
        for (TileEntity tileEntity : this.getTileEntities()) {
            try {
                NBTTagCompound tileEntityTagCompound = tileEntity.serializeNBT();
                tileEntitiesList.func_74742_a((NBTBase)tileEntityTagCompound);
            }
            catch (Exception e) {
                BlockPos tePos = tileEntity.func_174877_v();
                int index = tePos.func_177958_n() + (tePos.func_177956_o() * this.length + tePos.func_177952_p()) * this.width;
                localBlocks[index] = (byte)Block.field_149771_c.func_148757_b((Object)Blocks.field_150357_h);
                localMetadata[index] = 0;
                extraBlocks[index] = 0;
            }
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2] << 4 | extraBlocks[i * 2 + 1]) : (byte)(extraBlocks[i * 2] << 4);
        }
        NBTTagList entityList = new NBTTagList();
        List<Entity> entities = this.getEntities();
        for (Entity entity : entities) {
            NBTTagCompound entityCompound = entity.serializeNBT();
            entityList.func_74742_a((NBTBase)entityCompound);
        }
        tag.func_74778_a("Materials", "Alpha");
        tag.func_74773_a("Blocks", localBlocks);
        tag.func_74773_a("Data", localMetadata);
        if (extra) {
            tag.func_74773_a("AddBlocks", extraBlocksNibble);
        }
        tag.func_74782_a("Entities", (NBTBase)entityList);
        tag.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        int width = tag.func_74765_d("Width");
        int length = tag.func_74765_d("Length");
        int height = tag.func_74765_d("Height");
        this.width = width;
        this.length = length;
        this.height = height;
        this.init();
        byte[] blocks = tag.func_74770_j("Blocks");
        byte[] metadata = tag.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        if (tag.func_74764_b("AddBlocks")) {
            extra = true;
            byte[] extraBlocksNibble = tag.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = blocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = metadata[index] & 0xFF;
                    Block block = (Block)Block.field_149771_c.func_148754_a(blockID);
                    BlockPos blockPos = new BlockPos(x, y, z);
                    IBlockState blockState = block.func_176203_a(meta);
                    this.setBlockState(blockPos, blockState);
                }
            }
        }
        NBTTagList tileEntities = tag.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            TileEntity tileEntity = TileEntity.func_190200_a(null, (NBTTagCompound)tileEntities.func_150305_b(i));
            if (tileEntity == null) continue;
            this.setTileEntity(tileEntity.func_174877_v(), tileEntity);
        }
    }
}

