/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.regions.shapes;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.mappet.api.regions.shapes.BoxShape;
import mchorse.mappet.api.regions.shapes.CylinderShape;
import mchorse.mappet.api.regions.shapes.SphereShape;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class AbstractShape
implements INBTSerializable<NBTTagCompound> {
    public Vector3d pos = new Vector3d();

    public static AbstractShape fromString(String string) {
        if (string.equals("box")) {
            return new BoxShape();
        }
        if (string.equals("sphere")) {
            return new SphereShape();
        }
        if (string.equals("cylinder")) {
            return new CylinderShape();
        }
        return null;
    }

    public void copyFrom(AbstractShape shape) {
        this.pos.set((Tuple3d)shape.pos);
    }

    public boolean isEntityInside(Entity entity, BlockPos tile) {
        if (this.pos == null) {
            return false;
        }
        return this.isEntityInside(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, tile);
    }

    public boolean isEntityInside(double x, double y, double z, BlockPos tile) {
        if (this.pos == null) {
            return false;
        }
        return this.isInside(x - (double)tile.func_177958_n() - 0.5, y - (double)tile.func_177956_o() - 0.5, z - (double)tile.func_177952_p() - 0.5);
    }

    public abstract String getType();

    public abstract boolean isInside(double var1, double var3, double var5);

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("PosX", this.pos.x);
        tag.func_74780_a("PosY", this.pos.y);
        tag.func_74780_a("PosZ", this.pos.z);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("PosX") && tag.func_74764_b("PosY") && tag.func_74764_b("PosZ")) {
            this.pos = new Vector3d(tag.func_74769_h("PosX"), tag.func_74769_h("PosY"), tag.func_74769_h("PosZ"));
        }
    }
}

