/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests.rewards;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.api.quests.rewards.IReward;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ItemStackReward
implements IReward {
    public List<ItemStack> stacks = new ArrayList<ItemStack>();

    public ItemStackReward(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            this.stacks.add(stack);
        }
    }

    @Override
    public void reward(EntityPlayer player) {
        for (ItemStack stack : this.stacks) {
            ItemStack copy = stack.func_77946_l();
            if (player.func_191521_c(copy) || copy.func_190926_b()) continue;
            player.func_71019_a(copy, false);
        }
    }

    @Override
    public IReward copy() {
        ItemStackReward reward = new ItemStackReward(new ItemStack[0]);
        for (ItemStack stack : this.stacks) {
            reward.stacks.add(stack.func_77946_l());
        }
        return reward;
    }

    @Override
    public String getType() {
        return "item";
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList items = new NBTTagList();
        tag.func_74782_a("Items", (NBTBase)items);
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            items.func_74742_a((NBTBase)stack.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Items")) {
            NBTTagList items = tag.func_150295_c("Items", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                ItemStack stack = new ItemStack(items.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                this.stacks.add(stack);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        int c = buf.readInt();
        for (int i = 0; i < c; ++i) {
            this.stacks.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }
}

