/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests.objectives;

import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.quests.objectives.AbstractObjective;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class StateObjective
extends AbstractObjective {
    public Checker expression = new Checker();
    private boolean result;
    private String compiledMessage;

    @Override
    public void initiate(EntityPlayer player) {
        super.initiate(player);
        if (this.message.contains("${")) {
            this.compiledMessage = new DataContext((Entity)player).process(this.message);
        }
    }

    @Override
    public boolean isComplete(EntityPlayer player) {
        return this.result;
    }

    public boolean updateValue(EntityPlayer player) {
        boolean result = this.result;
        DataContext data = new DataContext((Entity)player);
        this.result = this.expression.check(data);
        if (this.message.contains("${")) {
            this.compiledMessage = data.process(this.message);
            return true;
        }
        return this.result != result;
    }

    @Override
    public void complete(EntityPlayer player) {
    }

    @Override
    public String stringifyObjective(EntityPlayer player) {
        return this.compiledMessage == null ? this.message : this.compiledMessage;
    }

    @Override
    public String getType() {
        return "state";
    }

    @Override
    public NBTTagCompound partialSerializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.result) {
            tag.func_74757_a("Result", this.result);
        }
        return tag;
    }

    @Override
    public void partialDeserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Result")) {
            this.result = tag.func_74767_n("Result");
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("Expression", this.expression.serializeNBT());
        tag.func_74757_a("Result", this.result);
        if (this.compiledMessage != null) {
            tag.func_74778_a("CompiledMessage", this.compiledMessage);
        }
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.expression.deserializeNBT(tag.func_74781_a("Expression"));
        this.result = tag.func_74767_n("Result");
        this.compiledMessage = tag.func_74764_b("CompiledMessage") ? tag.func_74779_i("CompiledMessage") : null;
    }
}

