/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.npcs;

import com.google.common.base.CaseFormat;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.mappet.api.npcs.NpcDrop;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.utils.NBTUtils;
import mchorse.mappet.utils.NpcStateUtils;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.utils.ValueSerializer;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NpcState
implements INBTSerializable<NBTTagCompound> {
    public ValueString stateName = new ValueString("StateName", "");
    public ValueString id = new ValueString("Id", "");
    public States states = new States();
    public ValueBoolean unique = new ValueBoolean("Unique");
    public ValueFloat pathDistance = new ValueFloat("PathDistance", 32.0f);
    public ValueFloat maxHealth = new ValueFloat("MaxHealth", 20.0f);
    public ValueFloat health = new ValueFloat("Health", 20.0f);
    public ValueInt regenDelay = new ValueInt("RegenDelay", 80);
    public ValueInt regenFrequency = new ValueInt("RegenFrequency", 20);
    public ValueFloat damage = new ValueFloat("Damage", 2.0f);
    public ValueInt damageDelay = new ValueInt("DamageDelay", 10);
    public ValueBoolean canRanged = new ValueBoolean("CanRanged");
    public ValueBoolean canFallDamage = new ValueBoolean("CanFallDamage", true);
    public ValueBoolean canGetBurned = new ValueBoolean("CanGetBurned", true);
    public ValueBoolean invincible = new ValueBoolean("Invincible");
    public ValueBoolean killable = new ValueBoolean("Killable", true);
    public ValueFloat speed = new ValueFloat("Speed", 3.0f);
    public ValueFloat jumpPower = new ValueFloat("JumpPower", 0.6f);
    public ValueBoolean canSwim = new ValueBoolean("CanSwim", true);
    public ValueBoolean immovable = new ValueBoolean("Immovable");
    public ValueBoolean hasPost = new ValueBoolean("HasPost");
    public BlockPos postPosition;
    public ValueFloat postRadius = new ValueFloat("PostRadius", 1.0f);
    public ValueFloat fallback = new ValueFloat("Fallback", 15.0f);
    public ValueBoolean patrolCirculate = new ValueBoolean("PatrolCirculate");
    public List<BlockPos> patrol = new ArrayList<BlockPos>();
    public List<Trigger> patrolTriggers = new ArrayList<Trigger>();
    public List<BlockPos> steeringOffset = new ArrayList<BlockPos>();
    public ValueString follow = new ValueString("Follow", "");
    public ValueString faction = new ValueString("Faction", "");
    public AbstractMorph morph;
    public ValueFloat sightDistance = new ValueFloat("SightDistance", 25.0f);
    public ValueFloat sightRadius = new ValueFloat("SightRadius", 120.0f);
    public List<NpcDrop> drops = new ArrayList<NpcDrop>();
    public ValueInt xp = new ValueInt("Xp", 0);
    public ValueFloat shadowSize = new ValueFloat("ShadowSize", 0.6f);
    public ValueBoolean lookAtPlayer = new ValueBoolean("LookAtPlayer");
    public ValueBoolean lookAround = new ValueBoolean("LookAround");
    public ValueBoolean wander = new ValueBoolean("Wander");
    public ValueBoolean alwaysWander = new ValueBoolean("AlwaysWander");
    public ValueBoolean canFly = new ValueBoolean("CanFly");
    public ValueDouble flightMaxHeight = new ValueDouble("FlightMaxHeight", 6.0);
    public ValueDouble flightMinHeight = new ValueDouble("FlightMinHeight", 4.0);
    public ValueFloat flee = new ValueFloat("Flee", 4.0f);
    public ValueBoolean canPickUpLoot = new ValueBoolean("CanPickUpLoot");
    public ValueBoolean hasNoGravity = new ValueBoolean("HasNoGravity", false);
    public ValueBoolean canBeSteered = new ValueBoolean("CanBeSteered", false);
    public Trigger triggerDied = new Trigger();
    public Trigger triggerDamaged = new Trigger();
    public Trigger triggerInteract = new Trigger();
    public Trigger triggerTick = new Trigger();
    public Trigger triggerTarget = new Trigger();
    public Trigger triggerInitialize = new Trigger();
    public Trigger triggerRespawn = new Trigger();
    public Trigger triggerEntityCollision = new Trigger();
    public ValueBoolean respawn = new ValueBoolean("Respawn");
    public ValueInt respawnDelay = new ValueInt("RespawnDelay");
    public ValueBoolean respawnOnCoordinates = new ValueBoolean("RespawnOnCoordinates");
    public ValueDouble respawnPosX = new ValueDouble("RespawnPosX");
    public ValueDouble respawnPosY = new ValueDouble("RespawnPosY");
    public ValueDouble respawnPosZ = new ValueDouble("RespawnPosZ");
    public ValueBoolean respawnSaveUUID = new ValueBoolean("RespawnSaveUUID");
    public ValueSerializer serializer;
    public Map<String, GenericValue> serealizableValues = new HashMap<String, GenericValue>();

    public NpcState() {
        this.serializer = new ValueSerializer();
        this.registerValue((GenericValue)this.stateName);
        this.registerValue((GenericValue)this.id);
        this.registerValue((GenericValue)this.unique);
        this.registerValue((GenericValue)this.pathDistance);
        this.registerValue((GenericValue)this.maxHealth);
        this.registerValue((GenericValue)this.health);
        this.registerValue((GenericValue)this.regenDelay);
        this.registerValue((GenericValue)this.regenFrequency);
        this.registerValue((GenericValue)this.damage);
        this.registerValue((GenericValue)this.damageDelay);
        this.registerValue((GenericValue)this.canRanged);
        this.registerValue((GenericValue)this.canFallDamage);
        this.registerValue((GenericValue)this.canGetBurned);
        this.registerValue((GenericValue)this.invincible);
        this.registerValue((GenericValue)this.killable);
        this.registerValue((GenericValue)this.speed);
        this.registerValue((GenericValue)this.jumpPower);
        this.registerValue((GenericValue)this.canSwim);
        this.registerValue((GenericValue)this.immovable);
        this.registerValue((GenericValue)this.hasPost);
        this.registerValue((GenericValue)this.postRadius);
        this.registerValue((GenericValue)this.fallback);
        this.registerValue((GenericValue)this.patrolCirculate);
        this.registerValue((GenericValue)this.follow);
        this.registerValue((GenericValue)this.faction);
        this.registerValue((GenericValue)this.sightDistance);
        this.registerValue((GenericValue)this.sightRadius);
        this.registerValue((GenericValue)this.xp);
        this.registerValue((GenericValue)this.shadowSize);
        this.registerValue((GenericValue)this.lookAtPlayer);
        this.registerValue((GenericValue)this.lookAround);
        this.registerValue((GenericValue)this.wander);
        this.registerValue((GenericValue)this.alwaysWander);
        this.registerValue((GenericValue)this.canFly);
        this.registerValue((GenericValue)this.flightMaxHeight);
        this.registerValue((GenericValue)this.flightMinHeight);
        this.registerValue((GenericValue)this.flee);
        this.registerValue((GenericValue)this.canPickUpLoot);
        this.registerValue((GenericValue)this.hasNoGravity);
        this.registerValue((GenericValue)this.canBeSteered);
        this.registerValue((GenericValue)this.respawn);
        this.registerValue((GenericValue)this.respawnDelay);
        this.registerValue((GenericValue)this.respawnOnCoordinates);
        this.registerValue((GenericValue)this.respawnPosX);
        this.registerValue((GenericValue)this.respawnPosY);
        this.registerValue((GenericValue)this.respawnPosZ);
        this.registerValue((GenericValue)this.respawnSaveUUID);
    }

    private void registerValue(GenericValue value) {
        this.serializer.registerNBTValue(value.id, (GenericBaseValue)value, true);
        this.serealizableValues.put(value.id, value);
    }

    private String processPropertyName(String property) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, property);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean edit(String property, String value) {
        Value parameter = (Value)this.serealizableValues.get(this.processPropertyName(property));
        if (parameter == null) {
            if (property.equals("post")) {
                String[] splits = value.split(" ");
                if (splits.length < 3) return false;
                int x = Integer.parseInt(splits[0]);
                int y = Integer.parseInt(splits[1]);
                int z = Integer.parseInt(splits[2]);
                this.postPosition = new BlockPos(x, y, z);
                return true;
            } else {
                if (!property.equals("morph")) return false;
                try {
                    this.morph = MorphManager.INSTANCE.morphFromNBT(JsonToNBT.func_180713_a((String)value));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        } else if (parameter instanceof ValueString) {
            ((ValueString)parameter).set((Object)value);
            return true;
        } else if (parameter instanceof ValueBoolean) {
            ((ValueBoolean)parameter).set((Object)Boolean.parseBoolean(value));
            return true;
        } else if (parameter instanceof ValueInt) {
            ((ValueInt)parameter).set((Number)Integer.parseInt(value));
            return true;
        } else if (parameter instanceof ValueFloat) {
            ((ValueFloat)parameter).set((Number)Float.valueOf(Float.parseFloat(value)));
            return true;
        } else {
            if (!(parameter instanceof ValueDouble)) return true;
            ((ValueDouble)parameter).set((Number)Double.parseDouble(value));
        }
        return true;
    }

    public NBTTagCompound serializeNBT() {
        return this.partialSerializeNBT(null);
    }

    public NBTTagCompound partialSerializeNBT(List<String> options) {
        boolean all = options == null;
        NBTTagCompound tag = new NBTTagCompound();
        if (!all && options.isEmpty()) {
            return tag;
        }
        this.serializer.toNBT(tag);
        if (all || options.contains("states")) {
            tag.func_74782_a("States", (NBTBase)this.states.serializeNBT());
        }
        if (all || options.contains("steering_offset")) {
            NBTTagList offsets = new NBTTagList();
            for (int i = 0; i < this.steeringOffset.size(); ++i) {
                offsets.func_74742_a(NBTUtils.blockPosTo(this.steeringOffset.get(i)));
            }
            tag.func_74782_a("SteeringOffsets", (NBTBase)offsets);
        }
        if (all || options.contains("post")) {
            tag.func_74782_a("Post", (NBTBase)(this.postPosition == null ? new NBTTagList() : NBTUtils.blockPosTo(this.postPosition)));
        }
        if (all || options.contains("patrol")) {
            int i;
            NBTTagList points = new NBTTagList();
            NBTTagList triggers = new NBTTagList();
            for (i = 0; i < this.patrol.size(); ++i) {
                points.func_74742_a(NBTUtils.blockPosTo(this.patrol.get(i)));
            }
            for (i = 0; i < this.patrolTriggers.size(); ++i) {
                triggers.func_74742_a((NBTBase)this.patrolTriggers.get(i).serializeNBT());
            }
            tag.func_74782_a("Patrol", (NBTBase)points);
            tag.func_74782_a("PatrolTriggers", (NBTBase)triggers);
        }
        if (all || options.contains("morph")) {
            tag.func_74782_a("Morph", (NBTBase)(this.morph == null ? new NBTTagCompound() : this.morph.toNBT()));
        }
        if (all || options.contains("drops")) {
            NBTTagList drops = new NBTTagList();
            for (NpcDrop drop : this.drops) {
                drops.func_74742_a((NBTBase)drop.serializeNBT());
            }
            tag.func_74782_a("Drops", (NBTBase)drops);
        }
        if (all || options.contains("trigger_died")) {
            tag.func_74782_a("TriggerDied", (NBTBase)this.triggerDied.serializeNBT());
        }
        if (all || options.contains("trigger_damaged")) {
            tag.func_74782_a("TriggerDamaged", (NBTBase)this.triggerDamaged.serializeNBT());
        }
        if (all || options.contains("trigger_interact")) {
            tag.func_74782_a("TriggerInteract", (NBTBase)this.triggerInteract.serializeNBT());
        }
        if (all || options.contains("trigger_tick")) {
            tag.func_74782_a("TriggerTick", (NBTBase)this.triggerTick.serializeNBT());
        }
        if (all || options.contains("trigger_target")) {
            tag.func_74782_a("TriggerTarget", (NBTBase)this.triggerTarget.serializeNBT());
        }
        if (all || options.contains("trigger_initialize")) {
            tag.func_74782_a("TriggerInitialize", (NBTBase)this.triggerInitialize.serializeNBT());
        }
        if (all || options.contains("trigger_respawn")) {
            tag.func_74782_a("TriggerRespawn", (NBTBase)this.triggerRespawn.serializeNBT());
        }
        if (all || options.contains("trigger_entity_collision")) {
            tag.func_74782_a("TriggerEntityCollision", (NBTBase)this.triggerEntityCollision.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        BlockPos pos;
        int i;
        this.serializer.fromNBT(tag);
        if (tag.func_74764_b("States")) {
            this.states.deserializeNBT(tag.func_74775_l("States"));
        }
        if (tag.func_150297_b("SteeringOffsets", 9)) {
            NBTTagList offsets = tag.func_150295_c("SteeringOffsets", 9);
            this.steeringOffset.clear();
            for (i = 0; i < offsets.func_74745_c(); ++i) {
                pos = NBTUtils.blockPosFrom(offsets.func_179238_g(i));
                if (pos == null) continue;
                this.steeringOffset.add(pos);
            }
        }
        if (tag.func_150297_b("Post", 9)) {
            this.postPosition = NBTUtils.blockPosFrom(tag.func_74781_a("Post"));
        }
        if (tag.func_150297_b("Patrol", 9)) {
            NBTTagList points = tag.func_150295_c("Patrol", 9);
            this.patrol.clear();
            for (i = 0; i < points.func_74745_c(); ++i) {
                pos = NBTUtils.blockPosFrom(points.func_179238_g(i));
                if (pos == null) continue;
                this.patrol.add(pos);
            }
            NBTTagList triggers = tag.func_150295_c("PatrolTriggers", 10);
            this.patrolTriggers.clear();
            for (int i2 = 0; i2 < triggers.func_74745_c(); ++i2) {
                Trigger trigger = new Trigger();
                trigger.deserializeNBT(triggers.func_150305_b(i2));
                this.patrolTriggers.add(trigger);
            }
        }
        if (tag.func_150297_b("Morph", 10)) {
            this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
        }
        if (tag.func_74764_b("Drops")) {
            NBTTagList drops = tag.func_150295_c("Drops", 10);
            this.drops.clear();
            for (i = 0; i < drops.func_74745_c(); ++i) {
                NBTTagCompound tagDrop = drops.func_150305_b(i);
                NpcDrop drop = new NpcDrop();
                drop.deserializeNBT(tagDrop);
                if (drop.chance <= 0.0f || drop.stack.func_190926_b()) continue;
                this.drops.add(drop);
            }
        }
        if (tag.func_74764_b("TriggerDied")) {
            this.triggerDied.deserializeNBT(tag.func_74775_l("TriggerDied"));
        }
        if (tag.func_74764_b("TriggerDamaged")) {
            this.triggerDamaged.deserializeNBT(tag.func_74775_l("TriggerDamaged"));
        }
        if (tag.func_74764_b("TriggerInteract")) {
            this.triggerInteract.deserializeNBT(tag.func_74775_l("TriggerInteract"));
        }
        if (tag.func_74764_b("TriggerTick")) {
            this.triggerTick.deserializeNBT(tag.func_74775_l("TriggerTick"));
        }
        if (tag.func_74764_b("TriggerTarget")) {
            this.triggerTarget.deserializeNBT(tag.func_74775_l("TriggerTarget"));
        }
        if (tag.func_74764_b("TriggerInitialize")) {
            this.triggerInitialize.deserializeNBT(tag.func_74775_l("TriggerInitialize"));
        }
        if (tag.func_74764_b("TriggerRespawn")) {
            this.triggerRespawn.deserializeNBT(tag.func_74775_l("TriggerRespawn"));
        }
        if (tag.func_74764_b("TriggerEntityCollision")) {
            this.triggerEntityCollision.deserializeNBT(tag.func_74775_l("TriggerEntityCollision"));
        }
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeFloat(((Float)this.shadowSize.get()).floatValue());
        buf.writeFloat(((Float)this.jumpPower.get()).floatValue());
        NpcStateUtils.stateToBuf(buf, this);
    }

    public void readFromBuf(ByteBuf buf) {
        this.shadowSize.set((Number)Float.valueOf(buf.readFloat()));
        this.jumpPower.set((Number)Float.valueOf(buf.readFloat()));
        NpcStateUtils.stateFromBuf(buf);
    }
}

