/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.huds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mchorse.mappet.api.huds.HUDMorph;
import mchorse.mappet.api.huds.HUDScene;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class HUDStage {
    public Map<String, HUDScene> scenes = new LinkedHashMap<String, HUDScene>();
    private List<HUDMorph> renderOrtho = new ArrayList<HUDMorph>();
    private List<HUDMorph> renderPerpsective = new ArrayList<HUDMorph>();
    private boolean ignoreF1;

    public HUDStage(boolean ignoreF1) {
        this.ignoreF1 = ignoreF1;
    }

    public void reset() {
        this.scenes.clear();
    }

    public void update(boolean allowExpiring) {
        this.scenes.values().removeIf(scene -> scene.update(allowExpiring));
    }

    public void render(ScaledResolution resolution, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        this.renderOrtho.clear();
        this.enableGLStates();
        int w = resolution.func_78326_a();
        int h = resolution.func_78328_b();
        float lastX = OpenGlHelper.lastBrightnessX;
        float lastY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179086_m((int)256);
        float rx = (float)Math.ceil((double)mc.field_71443_c / (double)w);
        float ry = (float)Math.ceil((double)mc.field_71440_d / (double)h);
        int vx = (int)(0.0f * rx);
        int vy = (int)((float)mc.field_71440_d - (float)(0 + h) * ry);
        int vw = (int)((float)w * rx);
        int vh = (int)((float)h * ry);
        float aspect = (float)vw / (float)vh;
        float lastFov = Float.MIN_VALUE;
        GlStateManager.func_179083_b((int)vx, (int)vy, (int)vw, (int)vh);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-2.0f);
        for (HUDScene scene : this.scenes.values()) {
            if (mc.field_71474_y.field_74319_N && scene.hide && !this.ignoreF1) continue;
            if (lastFov != scene.fov) {
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                Project.gluPerspective((float)scene.fov, (float)aspect, (float)0.05f, (float)1000.0f);
                GlStateManager.func_179128_n((int)5888);
                lastFov = scene.fov;
            }
            this.renderPerpsective.clear();
            for (HUDMorph morph : scene.morphs) {
                if (morph.ortho) {
                    this.renderOrtho.add(morph);
                    continue;
                }
                this.renderPerpsective.add(morph);
            }
            this.renderPerpsective.sort(this::depthSort);
            for (HUDMorph morph : this.renderPerpsective) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                morph.render(resolution, partialTicks);
            }
        }
        GlStateManager.func_179121_F();
        this.setupOrtho(mc, w, h, true);
        GlStateManager.func_179086_m((int)256);
        this.renderOrtho.sort(this::depthSort);
        for (HUDMorph morph : this.renderOrtho) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            morph.render(resolution, partialTicks);
        }
        this.disableGLStates();
        this.setupOrtho(mc, w, h, false);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastX, (float)lastY);
    }

    private int depthSort(HUDMorph a, HUDMorph b) {
        float diff = a.translate.z - b.translate.z;
        if (diff == 0.0f) {
            return 0;
        }
        return diff < 0.0f ? -1 : 1;
    }

    private void setupOrtho(Minecraft mc, int w, int h, boolean flip) {
        GlStateManager.func_179083_b((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        if (flip) {
            GlStateManager.func_179130_a((double)0.0, (double)w, (double)0.0, (double)h, (double)1000.0, (double)3000000.0);
        } else {
            GlStateManager.func_179130_a((double)0.0, (double)w, (double)h, (double)0.0, (double)1000.0, (double)3000000.0);
        }
        GlStateManager.func_179128_n((int)5888);
    }

    private void enableGLStates() {
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void disableGLStates() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179118_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

