/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.events.nodes;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.events.EventContext;
import mchorse.mappet.api.events.nodes.EventBaseNode;
import mchorse.mclib.math.IValue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConditionNode
extends EventBaseNode {
    public Checker condition = new Checker();

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String getDisplayTitle() {
        return this.condition.mode == Checker.Mode.CONDITION ? "" : this.condition.expression;
    }

    @Override
    public int execute(EventContext context) {
        if (this.condition.mode == Checker.Mode.CONDITION) {
            boolean result = this.condition.condition.execute(context.data);
            context.log("The result of condition is " + (result ? "true" : "false"));
            return this.booleanToExecutionCode(result);
        }
        String expression = this.condition.expression;
        IValue value = Mappet.expressions.set(context.data).parse(expression, null);
        if (value != null) {
            boolean result = value.booleanValue();
            context.log("The result \"" + expression + "\" is " + (result ? "true" : "false"));
            return this.booleanToExecutionCode(result);
        }
        context.log("Condition \"" + expression + "\" could not be executed!");
        return this.booleanToExecutionCode(false);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("Condition", this.condition.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Condition")) {
            this.condition.deserializeNBT(tag.func_74781_a("Condition"));
        }
    }
}

